/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver<J> {
    private final TypeConfiguration typeConfiguration;
    private JavaTypeDescriptor<J> domainJtd;
    private JavaTypeDescriptor<?> relationalJtd;
    private SqlTypeDescriptor relationalStd;
    private BasicValueConverter valueConverter;
    private MutabilityPlan<J> mutabilityPlan;
    private InferredBasicValueResolution<J> resolution;

    public InferredBasicValueResolver(Function<TypeConfiguration, JavaTypeDescriptor<J>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        this.domainJtd = explicitJtdAccess != null ? explicitJtdAccess.apply(typeConfiguration) : null;
        this.relationalStd = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
    }

    public BasicValue.Resolution<J> build() {
        if (this.resolution == null) {
            BasicType<?> basicType = this.typeConfiguration.getBasicTypeRegistry().resolve(this.relationalJtd, this.relationalStd);
            this.resolution = new InferredBasicValueResolution(basicType, this.domainJtd, this.relationalJtd, this.relationalStd, this.valueConverter, this.mutabilityPlan);
        }
        return this.resolution;
    }

    public void injectResolution(InferredBasicValueResolution<J> resolution) {
        this.resolution = resolution;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public JavaTypeDescriptor<?> getDomainJtd() {
        return this.domainJtd;
    }

    public void setDomainJtd(JavaTypeDescriptor domainJtd) {
        this.domainJtd = domainJtd;
    }

    public JavaTypeDescriptor<?> getRelationalJtd() {
        return this.relationalJtd;
    }

    public void setRelationalJtd(JavaTypeDescriptor<?> relationalJtd) {
        this.relationalJtd = relationalJtd;
    }

    public SqlTypeDescriptor getRelationalStd() {
        return this.relationalStd;
    }

    public void setRelationalStd(SqlTypeDescriptor relationalStd) {
        this.relationalStd = relationalStd;
    }

    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(BasicValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public MutabilityPlan getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public void setMutabilityPlan(MutabilityPlan mutabilityPlan) {
        this.mutabilityPlan = mutabilityPlan;
    }
}

