/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValue.Resolution<J> {
    private final String name;
    private final BasicType basicType;
    private final BasicValueConverter valueConverter;
    private final MutabilityPlan mutabilityPlan;

    public static NamedConverterResolution from(String name, Function<TypeConfiguration, JavaTypeDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, JpaAttributeConverterCreationContext converterCreationContext, MutabilityPlan explicitMutabilityPlan, SqlTypeDescriptorIndicators sqlTypeIndicators, MetadataBuildingContext context) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Class converterClass = classLoaderService.classForName(converterClassName);
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClass, context.getBootstrapContext().getClassmateContext());
        JpaAttributeConverter converter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
        JavaTypeDescriptor<?> explicitJtd = explicitJtdAccess != null ? explicitJtdAccess.apply(context.getBootstrapContext().getTypeConfiguration()) : null;
        JavaTypeDescriptor<Object> domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaDescriptor();
        SqlTypeDescriptor explicitStd = explicitStdAccess != null ? explicitStdAccess.apply(context.getBootstrapContext().getTypeConfiguration()) : null;
        JavaTypeDescriptor relationalJtd = converter.getRelationalJavaDescriptor();
        SqlTypeDescriptor relationalStd = explicitStd != null ? explicitStd : relationalJtd.getJdbcRecommendedSqlType(sqlTypeIndicators);
        return new NamedConverterResolution(name, new StandardBasicTypeImpl(relationalJtd, relationalStd), converter, explicitMutabilityPlan != null ? explicitMutabilityPlan : converter.getDomainJavaDescriptor().getMutabilityPlan());
    }

    private NamedConverterResolution(String name, BasicType basicType, JpaAttributeConverter valueConverter, MutabilityPlan mutabilityPlan) {
        this.name = name;
        this.basicType = basicType;
        this.valueConverter = valueConverter;
        this.mutabilityPlan = mutabilityPlan;
    }

    @Override
    public BasicType getResolvedBasicType() {
        return this.basicType;
    }

    @Override
    public JavaTypeDescriptor<J> getDomainJavaDescriptor() {
        return this.valueConverter.getDomainJavaDescriptor();
    }

    @Override
    public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
        return this.valueConverter.getRelationalJavaDescriptor();
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.basicType.getSqlTypeDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.name + ')';
    }
}

