/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.internal.NamedNativeQueryDefinitionImpl;
import org.hibernate.boot.spi.AbstractNamedQueryDefinition;
import org.hibernate.boot.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;

public interface NamedNativeQueryDefinition
extends NamedQueryDefinition {
    public String getSqlQueryString();

    public String getResultSetMappingName();

    public String getResultSetMappingClassName();

    @Override
    public NamedNativeQueryMemento resolve(SessionFactoryImplementor var1);

    public static class Builder
    extends AbstractNamedQueryDefinition.AbstractBuilder<Builder> {
        private String sqlString;
        private String resultSetMappingName;
        private String resultSetMappingClassName;
        private Set<String> querySpaces;
        private Map<String, String> parameterTypes;

        public Builder(String name) {
            super(name);
        }

        public Builder setSqlString(String sqlString) {
            this.sqlString = sqlString;
            return this.getThis();
        }

        public NamedNativeQueryDefinition build() {
            return new NamedNativeQueryDefinitionImpl(this.getName(), this.sqlString, this.resultSetMappingName, this.resultSetMappingClassName, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Set<String> getQuerySpaces() {
            return this.querySpaces;
        }

        public Builder addSynchronizedQuerySpaces(Set<String> querySpaces) {
            if (querySpaces == null || querySpaces.isEmpty()) {
                return this;
            }
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.addAll(querySpaces);
            return this.getThis();
        }

        public Builder addSynchronizedQuerySpace(String space) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.add(space);
            return this.getThis();
        }

        public Builder setQuerySpaces(Set<String> spaces) {
            this.querySpaces = spaces;
            return this;
        }

        public Builder setResultSetMappingName(String resultSetMappingName) {
            this.resultSetMappingName = resultSetMappingName;
            return this;
        }

        public Builder setResultSetMappingClassName(String resultSetMappingClassName) {
            this.resultSetMappingClassName = resultSetMappingClassName;
            return this;
        }

        public void addParameterTypeHint(String name, String type) {
            if (this.parameterTypes == null) {
                this.parameterTypes = new HashMap<String, String>();
            }
            this.parameterTypes.put(name, type);
        }
    }
}

