/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.collection.BagInitializerProducer;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;

public abstract class AbstractBagSemantics<B extends Collection<?>>
implements CollectionSemantics<B> {
    @Override
    public Class<B> getCollectionJavaType() {
        return Collection.class;
    }

    @Override
    public B instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        if (anticipatedSize < 1) {
            return (B)new ArrayList();
        }
        return (B)CollectionHelper.arrayList(anticipatedSize);
    }

    @Override
    public Iterator getElementIterator(B rawCollection) {
        if (rawCollection == null) {
            return null;
        }
        return rawCollection.iterator();
    }

    @Override
    public void visitElements(B rawCollection, Consumer action) {
        if (rawCollection != null) {
            rawCollection.forEach(action);
        }
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        return new BagInitializerProducer(attributeMapping, selected, attributeMapping.getIdentifierDescriptor() == null ? null : attributeMapping.getIdentifierDescriptor().generateFetch(fetchParent, navigablePath.append(CollectionPart.Nature.ID.getName()), FetchTiming.IMMEDIATE, selected, lockMode, null, creationState), attributeMapping.getElementDescriptor().generateFetch(fetchParent, navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, lockMode, null, creationState));
    }
}

