/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.MapSemantics;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.collection.MapInitializerProducer;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;

public abstract class AbstractMapSemantics<M extends Map<?, ?>>
implements MapSemantics<M> {
    @Override
    public Class<M> getCollectionJavaType() {
        return Map.class;
    }

    @Override
    public Iterator getKeyIterator(M rawMap) {
        if (rawMap == null) {
            return null;
        }
        return rawMap.keySet().iterator();
    }

    @Override
    public void visitKeys(M rawMap, Consumer action) {
        if (rawMap != null) {
            rawMap.keySet().forEach(action);
        }
    }

    @Override
    public void visitEntries(M rawMap, BiConsumer action) {
        if (rawMap != null) {
            rawMap.forEach(action);
        }
    }

    @Override
    public Iterator getElementIterator(Map rawMap) {
        if (rawMap == null) {
            return Collections.emptyIterator();
        }
        return rawMap.values().iterator();
    }

    @Override
    public void visitElements(M rawMap, Consumer action) {
        if (rawMap != null) {
            rawMap.values().forEach(action);
        }
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        return new MapInitializerProducer(attributeMapping, selected, attributeMapping.getIndexDescriptor().generateFetch(fetchParent, navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, lockMode, null, creationState), attributeMapping.getElementDescriptor().generateFetch(fetchParent, navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, lockMode, null, creationState));
    }
}

