/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.internal.StandardMapSemantics;
import org.hibernate.collection.internal.StandardOrderedMapSemantics;
import org.hibernate.collection.internal.StandardOrderedSetSemantics;
import org.hibernate.collection.internal.StandardSetSemantics;
import org.hibernate.collection.internal.StandardSortedMapSemantics;
import org.hibernate.collection.internal.StandardSortedSetSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.CollectionSemanticsResolver;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Set;

public class StandardCollectionSemanticsResolver
implements CollectionSemanticsResolver {
    public static final StandardCollectionSemanticsResolver INSTANCE = new StandardCollectionSemanticsResolver();

    @Override
    public CollectionSemantics resolveRepresentation(Collection bootDescriptor) {
        if (bootDescriptor instanceof PrimitiveArray) {
            throw new NotYetImplementedFor6Exception();
        }
        if (bootDescriptor instanceof Array) {
            return StandardArraySemantics.INSTANCE;
        }
        if (bootDescriptor instanceof Bag) {
            return StandardBagSemantics.INSTANCE;
        }
        if (bootDescriptor instanceof IdentifierBag) {
            return StandardIdentifierBagSemantics.INSTANCE;
        }
        if (bootDescriptor instanceof List) {
            return StandardListSemantics.INSTANCE;
        }
        if (bootDescriptor instanceof Map) {
            if (bootDescriptor.isSorted()) {
                return StandardSortedMapSemantics.INSTANCE;
            }
            if (bootDescriptor.hasOrder()) {
                return StandardOrderedMapSemantics.INSTANCE;
            }
            return StandardMapSemantics.INSTANCE;
        }
        if (bootDescriptor instanceof Set) {
            if (bootDescriptor.isSorted()) {
                return StandardSortedSetSemantics.INSTANCE;
            }
            if (bootDescriptor.hasOrder()) {
                return StandardOrderedSetSemantics.INSTANCE;
            }
            return StandardSetSemantics.INSTANCE;
        }
        throw new MappingException("Unexpected org.hibernate.mapping.Collection impl [" + bootDescriptor + "]; unknown CollectionSemantics");
    }
}

