/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.log;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;

public class LoggingHelper {
    private static final String NULL = "<null>";
    private static final String UNREFERENCED = "<unreferenced>";

    public static String toLoggableString(NavigableRole role) {
        if (role == null) {
            return UNREFERENCED;
        }
        return role.getFullPath();
    }

    public static String toLoggableString(NavigablePath path) {
        assert (path != null);
        return path.getFullPath();
    }

    public static String toLoggableString(NavigableRole role, Object key) {
        if (role == null) {
            return UNREFERENCED;
        }
        return LoggingHelper.toLoggableString(LoggingHelper.toLoggableString(role), key);
    }

    public static String toLoggableString(NavigablePath path, Object key) {
        assert (path != null);
        return LoggingHelper.toLoggableString(LoggingHelper.toLoggableString(path), key);
    }

    public static String toLoggableString(CollectionKey collectionKey) {
        return LoggingHelper.toLoggableString(collectionKey.getRole(), collectionKey.getKey());
    }

    public static String toLoggableString(EntityKey entityKey) {
        return LoggingHelper.toLoggableString(StringHelper.collapse(entityKey.getEntityName()), entityKey.getIdentifierValue());
    }

    private static String toLoggableString(String roleOrPath, Object key) {
        assert (roleOrPath != null);
        StringBuilder buffer = new StringBuilder();
        buffer.append(roleOrPath);
        buffer.append('#');
        if (key == null) {
            buffer.append(NULL);
        } else {
            buffer.append(key);
        }
        return buffer.toString();
    }

    public static String toLoggableString(PersistentCollection collectionInstance) {
        if (collectionInstance == null) {
            return NULL;
        }
        return LoggingHelper.toLoggableString(collectionInstance.getRole(), collectionInstance.getKey());
    }
}

