/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.JdbcResultMetadata;
import org.hibernate.loader.custom.NonUniqueDiscoveredSqlAliasException;
import org.hibernate.loader.custom.ResultColumnProcessor;
import org.hibernate.loader.custom.ResultRowProcessor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.param.ParameterBinder;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class CustomLoader
extends Loader {
    private final String sql;
    private final Set<Serializable> querySpaces = new HashSet<Serializable>();
    private final List<ParameterBinder> paramValueBinders;
    private final Queryable[] entityPersisters;
    private final int[] entiytOwners;
    private final EntityAliases[] entityAliases;
    private final QueryableCollection[] collectionPersisters;
    private final int[] collectionOwners;
    private final CollectionAliases[] collectionAliases;
    private final LockMode[] lockModes;
    private boolean[] includeInResultRow;
    private final ResultRowProcessor rowProcessor;
    private Type[] resultTypes;
    private String[] transformerAliases;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(factory);
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    protected String getQueryIdentifier() {
        return this.sql;
    }

    @Override
    public String getSQLString() {
        return this.sql;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    protected LockMode[] getLockModes(LockOptions lockOptions) {
        return this.lockModes;
    }

    @Override
    protected Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    @Override
    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    @Override
    protected int[] getOwners() {
        return this.entiytOwners;
    }

    public List list(SharedSessionContractImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.querySpaces, this.resultTypes);
    }

    @Override
    protected String applyLocks(String sql, QueryParameters parameters, Dialect dialect, List<AfterLoadAction> afterLoadActions) throws QueryException {
        final LockOptions lockOptions = parameters.getLockOptions();
        if (lockOptions == null || lockOptions.getLockMode() == LockMode.NONE && lockOptions.getAliasLockCount() == 0) {
            return sql;
        }
        afterLoadActions.add(new AfterLoadAction(){
            private final LockOptions originalLockOptions;
            {
                this.originalLockOptions = lockOptions.makeCopy();
            }

            @Override
            public void afterLoad(SharedSessionContractImplementor session, Object entity, Loadable persister) {
                ((Session)((Object)session)).buildLockRequest(this.originalLockOptions).lock(persister.getEntityName(), entity);
            }
        });
        parameters.getLockOptions().setLockMode(LockMode.READ);
        return sql;
    }

    public ScrollableResultsImplementor scroll(QueryParameters queryParameters, SharedSessionContractImplementor session) throws HibernateException {
        ResultTransformer resultTransformer = queryParameters.getResultTransformer();
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    protected String[] getResultRowAliases() {
        return this.transformerAliases;
    }

    @Override
    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    protected boolean[] includeInResultRow() {
        return this.includeInResultRow;
    }

    @Override
    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SharedSessionContractImplementor session) throws SQLException, HibernateException {
        return this.rowProcessor.buildResultRow(row, rs, transformer != null, session);
    }

    @Override
    protected Object[] getResultRow(Object[] row, ResultSet rs, SharedSessionContractImplementor session) throws SQLException, HibernateException {
        return this.rowProcessor.buildResultRow(row, rs, session);
    }

    @Override
    protected List getResultList(List results, ResultTransformer resultTransformer) throws QueryException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    private String[] getReturnAliasesForTransformer() {
        return this.transformerAliases;
    }

    @Override
    protected EntityAliases[] getEntityAliases() {
        return this.entityAliases;
    }

    @Override
    protected CollectionAliases[] getCollectionAliases() {
        return this.collectionAliases;
    }

    @Override
    protected int bindParameterValues(PreparedStatement statement, QueryParameters queryParameters, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        Serializable optionalId = queryParameters.getOptionalId();
        if (optionalId != null) {
            this.paramValueBinders.get(0).bind(statement, queryParameters, session, startIndex);
            return session.getFactory().getMetamodel().entityPersister(queryParameters.getOptionalEntityName()).getIdentifierType().getColumnSpan(session.getFactory());
        }
        int span = 0;
        for (ParameterBinder paramValueBinder : this.paramValueBinders) {
            span += paramValueBinder.bind(statement, queryParameters, session, startIndex + span);
        }
        return span;
    }

    @Override
    protected void autoDiscoverTypes(ResultSet rs) {
        try {
            JdbcResultMetadata metadata = new JdbcResultMetadata(this.getFactory(), rs);
            this.rowProcessor.prepareForAutoDiscovery(metadata);
            ArrayList<String> aliases = new ArrayList<String>();
            ArrayList<Type> types = new ArrayList<Type>();
            for (ResultColumnProcessor resultProcessor : this.rowProcessor.getColumnProcessors()) {
                resultProcessor.performDiscovery(metadata, types, aliases);
            }
            this.validateAliases(aliases);
            this.resultTypes = ArrayHelper.toTypeArray(types);
            this.transformerAliases = ArrayHelper.toStringArray(aliases);
        }
        catch (SQLException e) {
            throw new HibernateException("Exception while trying to autodiscover types.", e);
        }
    }

    private void validateAliases(List<String> aliases) {
        HashSet<String> aliasesSet = new HashSet<String>();
        for (String alias : aliases) {
            this.validateAlias(alias);
            boolean alreadyExisted = !aliasesSet.add(alias);
            if (!alreadyExisted) continue;
            throw new NonUniqueDiscoveredSqlAliasException("Encountered a duplicated sql alias [" + alias + "] during auto-discovery of a native-sql query");
        }
    }

    protected void validateAlias(String alias) {
    }

    @Override
    protected void putResultInQueryCache(SharedSessionContractImplementor session, QueryParameters queryParameters, Type[] resultTypes, QueryResultsCache queryCache, QueryKey key, List result) {
        super.putResultInQueryCache(session, queryParameters, this.resultTypes, queryCache, key, result);
    }
}

