/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.Limit;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.sql.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public class LoaderSqlAstCreationState
implements SqlAstProcessingState,
SqlAstCreationState,
DomainResultCreationState,
QueryOptions {
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private final SqlAstCreationContext sf;
    private final SqlAstQuerySpecProcessingStateImpl processingState;
    private final FromClauseAccess fromClauseAccess;
    private final LockOptions lockOptions;
    private final BiFunction<FetchParent, LoaderSqlAstCreationState, List<Fetch>> fetchProcessor;

    public LoaderSqlAstCreationState(QuerySpec querySpec, SqlAliasBaseManager sqlAliasBaseManager, FromClauseAccess fromClauseAccess, LockOptions lockOptions, BiFunction<FetchParent, LoaderSqlAstCreationState, List<Fetch>> fetchProcessor, SqlAstCreationContext sf) {
        this.sqlAliasBaseManager = sqlAliasBaseManager;
        this.fromClauseAccess = fromClauseAccess;
        this.lockOptions = lockOptions;
        this.fetchProcessor = fetchProcessor;
        this.sf = sf;
        this.processingState = new SqlAstQuerySpecProcessingStateImpl(querySpec, this, this, () -> Clause.IRRELEVANT);
    }

    public LoaderSqlAstCreationState(QuerySpec querySpec, SqlAliasBaseManager sqlAliasBaseManager, LockOptions lockOptions, SessionFactoryImplementor sf) {
        this(querySpec, sqlAliasBaseManager, new FromClauseIndex(), lockOptions, (fetchParent, state) -> Collections.emptyList(), sf);
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.sf;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.processingState;
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return this.lockOptions.getEffectiveLockMode(identificationVariable);
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        return this.fetchProcessor.apply(fetchParent, this);
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Integer getTimeout() {
        return null;
    }

    @Override
    public FlushMode getFlushMode() {
        return null;
    }

    @Override
    public Boolean isReadOnly() {
        return null;
    }

    @Override
    public AppliedGraph getAppliedGraph() {
        return null;
    }

    @Override
    public TupleTransformer getTupleTransformer() {
        return null;
    }

    @Override
    public ResultListTransformer getResultListTransformer() {
        return null;
    }

    @Override
    public Boolean isResultCachingEnabled() {
        return false;
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return CacheRetrieveMode.BYPASS;
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return CacheStoreMode.BYPASS;
    }

    @Override
    public String getResultCacheRegionName() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return null;
    }

    private static class FromClauseIndex
    implements FromClauseAccess {
        private TableGroup tableGroup;

        private FromClauseIndex() {
        }

        @Override
        public TableGroup findTableGroup(NavigablePath navigablePath) {
            if (this.tableGroup != null) {
                if (this.tableGroup.getNavigablePath().equals(navigablePath)) {
                    return this.tableGroup;
                }
                throw new IllegalArgumentException("NavigablePath [" + navigablePath + "] did not match base TableGroup [" + this.tableGroup.getNavigablePath() + "]");
            }
            return null;
        }

        @Override
        public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
            assert (tableGroup.getNavigablePath().equals(navigablePath));
            if (this.tableGroup != null) {
                if (this.tableGroup != tableGroup) {
                    throw new IllegalArgumentException("Base TableGroup [" + tableGroup.getNavigablePath() + "] already set - " + navigablePath);
                }
                assert (this.tableGroup.getNavigablePath().equals(navigablePath));
            } else {
                this.tableGroup = tableGroup;
            }
        }
    }
}

