/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.spi.Loadable;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.spi.CircularFetchDetector;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.sql.results.spi.FetchableContainer;
import org.jboss.logging.Logger;

public class MetamodelSelectBuilderProcess {
    private static final Logger log = Logger.getLogger(MetamodelSelectBuilderProcess.class);
    private final SqlAstCreationContext creationContext;
    private final Loadable loadable;
    private final List<ModelPart> partsToSelect;
    private final ModelPart restrictedPart;
    private final DomainResult cachedDomainResult;
    private final int numberOfKeysToLoad;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockOptions lockOptions;
    private final Consumer<JdbcParameter> jdbcParameterConsumer;
    private final CircularFetchDetector circularFetchDetector = new CircularFetchDetector();
    private int fetchDepth = 0;

    public static SelectStatement createSelect(Loadable loadable, List<ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        MetamodelSelectBuilderProcess process = new MetamodelSelectBuilderProcess(sessionFactory, loadable, partsToSelect, restrictedPart, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.execute();
    }

    private MetamodelSelectBuilderProcess(SqlAstCreationContext creationContext, Loadable loadable, List<ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this.creationContext = creationContext;
        this.loadable = loadable;
        this.partsToSelect = partsToSelect;
        this.restrictedPart = restrictedPart;
        this.cachedDomainResult = cachedDomainResult;
        this.numberOfKeysToLoad = numberOfKeysToLoad;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockOptions = lockOptions != null ? lockOptions : LockOptions.NONE;
        this.jdbcParameterConsumer = jdbcParameterConsumer;
    }

    private SelectStatement execute() {
        List<Object> domainResults;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.creationContext);
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(rootNavigablePath, null, null, this.lockOptions.getLockMode(), sqlAstCreationState.getSqlAliasBaseManager(), sqlAstCreationState.getSqlExpressionResolver(), () -> rootQuerySpec::applyPredicate, this.creationContext);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        if (this.partsToSelect != null && !this.partsToSelect.isEmpty()) {
            domainResults = new ArrayList();
            for (ModelPart part : this.partsToSelect) {
                NavigablePath navigablePath = rootNavigablePath.append(part.getPartName());
                domainResults.add(part.createDomainResult(navigablePath, rootTableGroup, null, sqlAstCreationState));
            }
        } else {
            DomainResult domainResult = this.cachedDomainResult != null ? this.cachedDomainResult : this.loadable.createDomainResult(rootNavigablePath, rootTableGroup, null, sqlAstCreationState);
            domainResults = Collections.singletonList(domainResult);
        }
        int numberOfKeyColumns = this.restrictedPart.getJdbcTypeCount(this.creationContext.getDomainModel().getTypeConfiguration());
        this.applyKeyRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, this.restrictedPart, numberOfKeyColumns, this.jdbcParameterConsumer, sqlAstCreationState);
        return new SelectStatement(rootQuerySpec, domainResults);
    }

    private void applyKeyRestriction(QuerySpec rootQuerySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, ModelPart keyPart, int numberOfKeyColumns, Consumer<JdbcParameter> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        if (numberOfKeyColumns == 1) {
            assert (keyPart instanceof BasicValuedModelPart);
            BasicValuedModelPart basicKeyPart = (BasicValuedModelPart)keyPart;
            JdbcMapping jdbcMapping2 = basicKeyPart.getJdbcMapping();
            String tableExpression = basicKeyPart.getContainingTableExpression();
            String columnExpression2 = basicKeyPart.getMappedColumnExpression();
            TableReference tableReference = rootTableGroup.resolveTableReference(tableExpression);
            ColumnReference columnRef = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression2), p -> new ColumnReference(tableReference, columnExpression2, jdbcMapping2, this.creationContext.getSessionFactory()));
            if (this.numberOfKeysToLoad == 1) {
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping2);
                jdbcParameterConsumer.accept(jdbcParameter);
                rootQuerySpec.applyPredicate(new ComparisonPredicate(columnRef, ComparisonOperator.EQUAL, jdbcParameter));
            } else {
                InListPredicate predicate = new InListPredicate(columnRef);
                for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                    for (int j = 0; j < numberOfKeyColumns; ++j) {
                        JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnRef.getJdbcMapping());
                        jdbcParameterConsumer.accept(jdbcParameter);
                        predicate.addExpression(jdbcParameter);
                    }
                }
                rootQuerySpec.applyPredicate(predicate);
            }
        } else {
            ArrayList columnReferences = new ArrayList(numberOfKeyColumns);
            keyPart.visitColumns((columnExpression, containingTableExpression, jdbcMapping) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(containingTableExpression);
                columnReferences.add((ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), p -> new ColumnReference(tableReference, columnExpression, jdbcMapping, this.creationContext.getSessionFactory())));
            });
            SqlTuple tuple = new SqlTuple(columnReferences, keyPart);
            InListPredicate predicate = new InListPredicate(tuple);
            for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                ArrayList<JdbcParameterImpl> tupleParams = new ArrayList<JdbcParameterImpl>();
                for (int j = 0; j < numberOfKeyColumns; ++j) {
                    ColumnReference columnReference = (ColumnReference)columnReferences.get(j);
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnReference.getJdbcMapping());
                    jdbcParameterConsumer.accept(jdbcParameter);
                    tupleParams.add(jdbcParameter);
                }
                SqlTuple paramTuple = new SqlTuple(tupleParams, keyPart);
                predicate.addExpression(paramTuple);
            }
            rootQuerySpec.applyPredicate(predicate);
        }
    }

    private List<Fetch> visitFetches(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        log.tracef("Starting visitation of FetchParent's Fetchables : %s", (Object)fetchParent.getNavigablePath());
        ArrayList<Fetch> fetches = new ArrayList<Fetch>();
        Consumer<Fetchable> processor = fetchable -> {
            NavigablePath fetchablePath = fetchParent.getNavigablePath().append(fetchable.getFetchableName());
            Fetch biDirectionalFetch = this.circularFetchDetector.findBiDirectionalFetch(fetchParent, (Fetchable)fetchable, creationState);
            if (biDirectionalFetch != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            LockMode lockMode = LockMode.READ;
            FetchTiming fetchTiming = fetchable.getMappedFetchStrategy().getTiming();
            boolean joined = fetchable.getMappedFetchStrategy().getStyle() == FetchStyle.JOIN;
            Integer maximumFetchDepth = this.creationContext.getMaximumFetchDepth();
            if (maximumFetchDepth != null) {
                if (this.fetchDepth == maximumFetchDepth) {
                    joined = false;
                } else if (this.fetchDepth > maximumFetchDepth) {
                    return;
                }
            }
            try {
                if (!(fetchable instanceof BasicValuedModelPart)) {
                    --this.fetchDepth;
                }
                Fetch fetch = fetchable.generateFetch(fetchParent, fetchablePath, fetchTiming, joined, lockMode, null, creationState);
                fetches.add(fetch);
            }
            finally {
                if (!(fetchable instanceof BasicValuedModelPart)) {
                    --this.fetchDepth;
                }
            }
        };
        FetchableContainer referencedMappingContainer = fetchParent.getReferencedMappingContainer();
        referencedMappingContainer.visitKeyFetchables(processor, null);
        referencedMappingContainer.visitFetchables(processor, null);
        return fetches;
    }
}

