/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Iterator;
import java.util.List;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.CollectionLoader;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;

public class SingleCollectionKeyLoader
implements CollectionLoader {
    private final PluralAttributeMapping pluralAttributeMapping;
    private final SelectStatement sqlAst;
    private final List<JdbcParameter> jdbcParameters;

    public SingleCollectionKeyLoader(PluralAttributeMapping pluralAttributeMapping, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters) {
        this.pluralAttributeMapping = pluralAttributeMapping;
        this.sqlAst = sqlAst;
        this.jdbcParameters = jdbcParameters;
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.pluralAttributeMapping;
    }

    @Override
    public PersistentCollection load(Object key, final SharedSessionContractImplementor session) {
        final CollectionKey collectionKey = new CollectionKey(this.pluralAttributeMapping.getCollectionDescriptor(), key);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(this.sqlAst);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.pluralAttributeMapping.getKeyDescriptor().getJdbcTypeCount(sessionFactory.getTypeConfiguration()));
        Iterator<JdbcParameter> paramItr = this.jdbcParameters.iterator();
        this.pluralAttributeMapping.getKeyDescriptor().visitJdbcValues(key, Clause.WHERE, (value, type) -> {
            assert (paramItr.hasNext());
            JdbcParameter parameter = (JdbcParameter)paramItr.next();
            jdbcParameterBindings.addBinding(parameter, new JdbcParameterBinding(){

                @Override
                public JdbcMapping getBindType() {
                    return type;
                }

                @Override
                public Object getBindValue() {
                    return value;
                }
            });
        }, session);
        assert (!paramItr.hasNext());
        JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public CollectionKey getCollectionKey() {
                return collectionKey;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerPassThruImpl.instance());
        return session.getPersistenceContext().getCollection(collectionKey);
    }
}

