/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.named.NamedQueryProducer;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;

public class SingleIdEntityLoaderProvidedQueryImpl<T>
implements SingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final NamedQueryProducer namedQueryMemento;

    public SingleIdEntityLoaderProvidedQueryImpl(EntityMappingType entityDescriptor, String loadQueryName, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.namedQueryMemento = SingleIdEntityLoaderProvidedQueryImpl.resolveNamedQuery(loadQueryName, sessionFactory);
        if (this.namedQueryMemento == null) {
            throw new IllegalArgumentException("Could not resolve named load-query [" + entityDescriptor.getEntityName() + "] : " + loadQueryName);
        }
    }

    private static NamedQueryProducer resolveNamedQuery(String queryName, SessionFactoryImplementor sf) {
        NamedQueryRepository namedQueryRepository = sf.getQueryEngine().getNamedQueryRepository();
        NamedNativeQueryMemento nativeQueryMemento = namedQueryRepository.getNativeQueryMemento(queryName);
        if (nativeQueryMemento != null) {
            return nativeQueryMemento;
        }
        return namedQueryRepository.getHqlQueryMemento(queryName);
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, SharedSessionContractImplementor session) {
        QueryImplementor query = this.namedQueryMemento.toQuery(session, this.entityDescriptor.getMappedJavaTypeDescriptor().getJavaType());
        query.setParameter(0, pkValue);
        return (T)query.uniqueResult();
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return new Object[0];
    }
}

