/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.internal.MetamodelSelectBuilderProcess;
import org.hibernate.loader.internal.Preparable;
import org.hibernate.loader.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.internal.SingleIdLoadPlan;
import org.hibernate.loader.spi.InternalFetchProfile;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class SingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderSupport<T>
implements Preparable {
    private EnumMap<LockMode, SingleIdLoadPlan> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<InternalFetchProfile, SingleIdLoadPlan> selectByInternalCascadeProfile;
    private AtomicInteger nonReusablePlansGenerated = new AtomicInteger();

    public AtomicInteger getNonReusablePlansGenerated() {
        return this.nonReusablePlansGenerated;
    }

    public SingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
    }

    @Override
    public void prepare() {
    }

    @Override
    public T load(Object key, LockOptions lockOptions, SharedSessionContractImplementor session) {
        SingleIdLoadPlan<T> loadPlan = this.resolveLoadPlan(lockOptions, session);
        return loadPlan.load(key, lockOptions, session);
    }

    private SingleIdLoadPlan<T> resolveLoadPlan(LockOptions lockOptions, SharedSessionContractImplementor session) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (this.getLoadable().isAffectedByEnabledFilters(loadQueryInfluencers)) {
            this.nonReusablePlansGenerated.incrementAndGet();
            return this.createLoadPlan(lockOptions, loadQueryInfluencers, session.getFactory());
        }
        InternalFetchProfile enabledInternalFetchProfile = loadQueryInfluencers.getEnabledInternalFetchProfile();
        if (enabledInternalFetchProfile != null && LockMode.UPGRADE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(InternalFetchProfile.class);
            } else {
                SingleIdLoadPlan existing = this.selectByInternalCascadeProfile.get((Object)enabledInternalFetchProfile);
                if (existing != null) {
                    return existing;
                }
            }
            SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, session.getFactory());
            this.selectByInternalCascadeProfile.put(enabledInternalFetchProfile, plan);
            return plan;
        }
        boolean reusable = this.determineIfReusable(lockOptions, loadQueryInfluencers);
        if (reusable) {
            SingleIdLoadPlan existing = this.selectByLockMode.get((Object)lockOptions.getLockMode());
            if (existing != null) {
                return existing;
            }
            SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, session.getFactory());
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
            return plan;
        }
        this.nonReusablePlansGenerated.incrementAndGet();
        return this.createLoadPlan(lockOptions, loadQueryInfluencers, session.getFactory());
    }

    private boolean determineIfReusable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        if (this.getLoadable().isAffectedByEntityGraph(loadQueryInfluencers)) {
            return false;
        }
        if (this.getLoadable().isAffectedByEnabledFetchProfiles(loadQueryInfluencers)) {
            return false;
        }
        return lockOptions.getTimeOut() == -1;
    }

    private SingleIdLoadPlan<T> createLoadPlan(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlAst = MetamodelSelectBuilderProcess.createSelect(this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, 1, queryInfluencers, lockOptions, jdbcParameters::add, sessionFactory);
        return new SingleIdLoadPlan(this.getLoadable().getIdentifierMapping(), sqlAst, jdbcParameters);
    }
}

