/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.spi;

import org.hibernate.internal.util.StringHelper;

public enum InternalFetchProfile {
    MERGE("merge"),
    REFRESH("refresh");

    private final String legacyName;

    private InternalFetchProfile(String legacyName) {
        this.legacyName = legacyName;
    }

    public String getLegacyName() {
        return this.legacyName;
    }

    public static InternalFetchProfile fromLegacyName(String legacyName) {
        if (StringHelper.isEmpty(legacyName)) {
            return null;
        }
        if (InternalFetchProfile.MERGE.legacyName.equalsIgnoreCase(legacyName)) {
            return MERGE;
        }
        if (InternalFetchProfile.REFRESH.legacyName.equalsIgnoreCase(legacyName)) {
            return REFRESH;
        }
        throw new IllegalArgumentException("Passed name [" + legacyName + "] not recognized as a legacy internal fetch profile name; supported values include: 'merge' and 'refresh'");
    }
}

