/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.process.internal.EnumeratedValueResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.NamedConverterResolution;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.RowVersionType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.RowVersionTypeDescriptor;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValue
extends SimpleValue
implements SqlTypeDescriptorIndicators {
    private final TypeConfiguration typeConfiguration;
    private final int preferredJdbcTypeCodeForBoolean;
    private Function<TypeConfiguration, JavaTypeDescriptor<?>> explicitJavaTypeAccess;
    private Function<TypeConfiguration, SqlTypeDescriptor> explicitSqlTypeAccess;
    private MutabilityPlan explicitMutabilityPlan;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumerationStyle;
    private TemporalType temporalPrecision;
    private ConverterDescriptor attributeConverterDescriptor;
    private Class resolvedJavaClass;
    private String ownerName;
    private String propertyName;
    private Properties explicitLocalTypeParams;
    private BasicValue dependentValue;
    private Resolution<?> resolution;

    public BasicValue(MetadataBuildingContext buildingContext) {
        super(buildingContext);
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        this.preferredJdbcTypeCodeForBoolean = buildingContext.getPreferredSqlTypeCodeForBoolean();
    }

    public BasicValue(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        this.preferredJdbcTypeCodeForBoolean = buildingContext.getPreferredSqlTypeCodeForBoolean();
    }

    public void setJavaClass(Class resolvedJavaClass) {
        this.resolvedJavaClass = resolvedJavaClass;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.resolution != null) {
            throw new IllegalStateException("BasicValue already resolved");
        }
        this.ownerName = className;
        this.propertyName = propertyName;
    }

    public void setEnumerationStyle(EnumType enumerationStyle, String enumJavaTypeName) {
        this.enumerationStyle = enumerationStyle;
        this.resolvedJavaClass = this.getBuildingContext().getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class).classForName(enumJavaTypeName);
    }

    public EnumType getEnumerationStyle() {
        return this.enumerationStyle;
    }

    @Override
    public ConverterDescriptor getJpaAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    @Override
    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptor = descriptor;
    }

    @Override
    public Type getType() throws MappingException {
        this.resolve();
        assert (this.resolution != null);
        return this.resolution.getResolvedBasicType();
    }

    public Resolution<?> resolve() {
        if (this.resolution != null) {
            return this.resolution;
        }
        String explicitTypeName = this.getTypeName();
        if (explicitTypeName != null) {
            this.resolution = BasicValue.interpretExplicitlyNamedType(explicitTypeName, this.enumerationStyle, this.resolvedJavaClass, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.attributeConverterDescriptor, this.explicitMutabilityPlan, this.explicitLocalTypeParams, this, this.typeConfiguration, this.getBuildingContext());
        } else {
            ServiceRegistry serviceRegistry = this.typeConfiguration.getServiceRegistry();
            ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
            this.resolution = BasicValue.implicitlyResolveBasicType(this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.attributeConverterDescriptor, this, () -> {
                if (this.resolvedJavaClass != null) {
                    return this.getBuildingContext().getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(this.resolvedJavaClass);
                }
                if (this.ownerName != null && this.propertyName != null) {
                    Class reflectedJavaType = ReflectHelper.reflectedPropertyClass(this.ownerName, this.propertyName, classLoaderService);
                    BasicType basicType = this.getBuildingContext().getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(reflectedJavaType.getName());
                    if (basicType != null) {
                        return basicType.getJavaTypeDescriptor();
                    }
                    return this.getBuildingContext().getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(reflectedJavaType);
                }
                if (this.dependentValue != null) {
                    return this.dependentValue.resolve().getDomainJavaDescriptor();
                }
                return null;
            }, this.isVersion(), this.typeConfiguration);
        }
        return this.resolution;
    }

    private static Resolution interpretExplicitlyNamedType(String name, EnumType enumerationStyle, Class resolvedJavaClass, Function<TypeConfiguration, JavaTypeDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, ConverterDescriptor converterDescriptor, MutabilityPlan explicitMutabilityPlan, Properties localTypeParams, SqlTypeDescriptorIndicators stdIndicators, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        final ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, converterCreationContext, explicitMutabilityPlan, stdIndicators, context);
        }
        if (enumerationStyle != null) {
            EnumValueConverter valueConverter;
            SqlTypeDescriptor std;
            JavaTypeDescriptor<Object> jdbcJtd;
            assert (resolvedJavaClass != null);
            assert (resolvedJavaClass.isEnum());
            JavaTypeDescriptorRegistry jtdRegistry = typeConfiguration.getJavaTypeDescriptorRegistry();
            SqlTypeDescriptorRegistry stdRegistry = typeConfiguration.getSqlTypeDescriptorRegistry();
            EnumJavaTypeDescriptor domainJtd = (EnumJavaTypeDescriptor)jtdRegistry.getDescriptor(resolvedJavaClass);
            if (enumerationStyle == EnumType.ORDINAL) {
                jdbcJtd = jtdRegistry.getDescriptor(Integer.class);
                SqlTypeDescriptor explicitStd = explicitStdAccess == null ? null : explicitStdAccess.apply(typeConfiguration);
                std = explicitStd != null ? explicitStd : stdRegistry.getDescriptor(4);
                valueConverter = new OrdinalEnumValueConverter(domainJtd, std, jdbcJtd);
            } else {
                jdbcJtd = jtdRegistry.getDescriptor(String.class);
                std = jdbcJtd.getJdbcRecommendedSqlType(stdIndicators);
                valueConverter = new NamedEnumValueConverter(domainJtd, std, jdbcJtd);
            }
            CustomType valueMapper = new CustomType(new org.hibernate.type.EnumType(resolvedJavaClass, valueConverter, typeConfiguration), typeConfiguration);
            return new EnumeratedValueResolution(valueMapper, domainJtd, jdbcJtd, std, valueConverter);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(name);
        if (basicTypeByName != null) {
            JavaTypeDescriptor domainJtd;
            JpaAttributeConverter valueConverter;
            if (converterDescriptor == null) {
                valueConverter = null;
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            } else {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlan, context);
        }
        TypeDefinition typeDefinition = context.getTypeDefinitionRegistry().resolve(name);
        if (typeDefinition != null) {
            return typeDefinition.resolve(explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), localTypeParams, explicitMutabilityPlan, context);
        }
        ClassLoaderService cls = typeConfiguration.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, null, typeConfiguration);
                context.getTypeDefinitionRegistry().register(implicitDefinition);
                return implicitDefinition.resolve(explicitJtdAccess != null ? explicitJtdAccess.apply(typeConfiguration) : null, explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null, null, explicitMutabilityPlan, context);
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), explicitMutabilityPlan, localTypeParams, context);
        }
        catch (ClassLoadingException classLoadingException) {
            throw new MappingException("Could not resolve named type : " + name);
        }
    }

    private static Resolution implicitlyResolveBasicType(Function<TypeConfiguration, JavaTypeDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, ConverterDescriptor attributeConverterDescriptor, SqlTypeDescriptorIndicators stdIndicators, Supplier<JavaTypeDescriptor> reflectedJtdResolver, boolean isVersion, final TypeConfiguration typeConfiguration) {
        InferredBasicValueResolver<Object> resolver = new InferredBasicValueResolver<Object>(explicitJtdAccess, explicitStdAccess, typeConfiguration);
        if (attributeConverterDescriptor != null) {
            assert (!isVersion) : "Version attribute cannot define AttributeConverter";
            Class converterDomainJavaType = attributeConverterDescriptor.getDomainValueResolvedType().getErasedType();
            JavaTypeDescriptor converterDomainJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(converterDomainJavaType);
            if (resolver.getDomainJtd() == null) {
                resolver.setDomainJtd(converterDomainJtd);
            } else if (!resolver.getDomainJtd().equals(converterDomainJtd)) {
                throw new HibernateException("JavaTypeDescriptors did not match between BasicTypeParameters#getJavaTypeDescriptor and BasicTypeParameters#getAttributeConverterDefinition#getDomainType");
            }
            Class converterRelationalJavaType = attributeConverterDescriptor.getRelationalValueResolvedType().getErasedType();
            resolver.setRelationalJtd(typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(converterRelationalJavaType));
            SqlTypeDescriptor converterHintedStd = resolver.getRelationalJtd().getJdbcRecommendedSqlType(stdIndicators);
            if (resolver.getRelationalStd() == null) {
                resolver.setRelationalStd(converterHintedStd);
            } else if (!resolver.getRelationalStd().equals(converterHintedStd)) {
                throw new HibernateException("SqlTypeDescriptors did not match between BasicTypeParameters#getSqlTypeDescriptor and BasicTypeParameters#getAttributeConverterDefinition#getJdbcType");
            }
            resolver.setValueConverter(attributeConverterDescriptor.createJpaAttributeConverter(new JpaAttributeConverterCreationContext(){

                @Override
                public ManagedBeanRegistry getManagedBeanRegistry() {
                    return typeConfiguration.getServiceRegistry().getService(ManagedBeanRegistry.class);
                }

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }
            }));
        } else {
            if (resolver.getDomainJtd() == null) {
                resolver.setDomainJtd(reflectedJtdResolver.get());
            }
            if (resolver.getDomainJtd() instanceof EnumJavaTypeDescriptor) {
                EnumJavaTypeDescriptor enumJavaDescriptor = (EnumJavaTypeDescriptor)resolver.getDomainJtd();
                EnumType enumType = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : EnumType.ORDINAL;
                switch (enumType) {
                    case STRING: {
                        JavaTypeDescriptor<String> stringJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(String.class);
                        SqlTypeDescriptor relationalStd = stringJtd.getJdbcRecommendedSqlType(stdIndicators);
                        resolver.setRelationalJtd(stringJtd);
                        resolver.setRelationalStd(relationalStd);
                        NamedEnumValueConverter valueConverter = new NamedEnumValueConverter(enumJavaDescriptor, relationalStd, stringJtd);
                        resolver.setValueConverter(valueConverter);
                        org.hibernate.type.EnumType enumMappingType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaType(), valueConverter, typeConfiguration);
                        CustomType basicType = new CustomType(enumMappingType, typeConfiguration);
                        resolver.injectResolution(new InferredBasicValueResolution<String>(basicType, enumJavaDescriptor, stringJtd, relationalStd, valueConverter, ImmutableMutabilityPlan.INSTANCE));
                        break;
                    }
                    case ORDINAL: {
                        JavaTypeDescriptor<Integer> integerJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Integer.class);
                        SqlTypeDescriptor std = integerJtd.getJdbcRecommendedSqlType(stdIndicators);
                        resolver.setRelationalJtd(integerJtd);
                        resolver.setRelationalStd(std);
                        OrdinalEnumValueConverter valueConverter = new OrdinalEnumValueConverter(enumJavaDescriptor, std, integerJtd);
                        resolver.setValueConverter(valueConverter);
                        org.hibernate.type.EnumType enumMappingType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaType(), valueConverter, typeConfiguration);
                        CustomType basicType = new CustomType(enumMappingType, typeConfiguration);
                        resolver.injectResolution(new InferredBasicValueResolution<Integer>(basicType, enumJavaDescriptor, integerJtd, std, valueConverter, ImmutableMutabilityPlan.INSTANCE));
                        break;
                    }
                    default: {
                        throw new HibernateException("Unknown EnumType : " + enumType);
                    }
                }
            } else if (resolver.getDomainJtd() instanceof TemporalJavaTypeDescriptor) {
                if (stdIndicators.getTemporalPrecision() != null) {
                    resolver.setDomainJtd(((TemporalJavaTypeDescriptor)resolver.getDomainJtd()).resolveTypeForPrecision(stdIndicators.getTemporalPrecision(), typeConfiguration));
                }
            } else if (resolver.getDomainJtd() instanceof PrimitiveByteArrayTypeDescriptor && isVersion) {
                resolver.setDomainJtd(RowVersionTypeDescriptor.INSTANCE);
                resolver.injectResolution(new InferredBasicValueResolution<byte[]>(RowVersionType.INSTANCE, RowVersionType.INSTANCE.getJavaTypeDescriptor(), RowVersionType.INSTANCE.getJavaTypeDescriptor(), RowVersionType.INSTANCE.getSqlTypeDescriptor(), null, ImmutableMutabilityPlan.INSTANCE));
            }
        }
        if (resolver.getRelationalStd() == null) {
            if (resolver.getRelationalJtd() == null) {
                if (resolver.getDomainJtd() == null) {
                    throw new IllegalArgumentException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use");
                }
                resolver.setRelationalJtd(resolver.getDomainJtd());
            }
            resolver.setRelationalStd(resolver.getRelationalJtd().getJdbcRecommendedSqlType(stdIndicators));
        } else if (resolver.getRelationalJtd() == null) {
            resolver.setRelationalJtd(resolver.getRelationalStd().getJdbcRecommendedJavaTypeMapping(typeConfiguration));
            if (resolver.getDomainJtd() == null) {
                resolver.setDomainJtd(resolver.getRelationalJtd());
            }
        }
        return resolver.build();
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getEnumerationStyle();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredJdbcTypeCodeForBoolean;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setExplicitTypeParams(Properties explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    public static interface Resolution<J> {
        public BasicType getResolvedBasicType();

        public JavaTypeDescriptor<J> getDomainJavaDescriptor();

        public JavaTypeDescriptor<?> getRelationalJavaDescriptor();

        public SqlTypeDescriptor getRelationalSqlTypeDescriptor();

        public BasicValueConverter getValueConverter();

        public MutabilityPlan<J> getMutabilityPlan();
    }
}

