/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEmbeddableRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final JavaTypeDescriptor<?> embeddableJavaTypeDescriptor;
    private final int propertySpan;
    private final PropertyAccess[] propertyAccesses;
    private final boolean hasCustomAccessors;
    private final Map<String, Integer> attributeNameToPositionMap;

    public AbstractEmbeddableRepresentationStrategy(Component bootDescriptor, JavaTypeDescriptor<?> embeddableJavaTypeDescriptor, RuntimeModelCreationContext creationContext) {
        this.propertySpan = bootDescriptor.getPropertySpan();
        this.embeddableJavaTypeDescriptor = embeddableJavaTypeDescriptor;
        this.propertyAccesses = new PropertyAccess[this.propertySpan];
        this.attributeNameToPositionMap = CollectionHelper.concurrentMap(this.propertySpan);
        boolean foundCustomAccessor = false;
        Iterator itr = bootDescriptor.getPropertyIterator();
        int i = 0;
        while (itr.hasNext()) {
            Property prop = (Property)itr.next();
            this.propertyAccesses[i] = this.buildPropertyAccess(prop);
            this.attributeNameToPositionMap.put(prop.getName(), i);
            if (!prop.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            ++i;
        }
        this.hasCustomAccessors = foundCustomAccessor;
    }

    protected abstract PropertyAccess buildPropertyAccess(Property var1);

    public JavaTypeDescriptor<?> getEmbeddableJavaTypeDescriptor() {
        return this.embeddableJavaTypeDescriptor;
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.getEmbeddableJavaTypeDescriptor();
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public PropertyAccess[] getPropertyAccesses() {
        return this.propertyAccesses;
    }

    public boolean hasCustomAccessors() {
        return this.hasCustomAccessors;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return this.propertyAccesses[this.attributeNameToPositionMap.get(bootAttributeDescriptor.getName())];
    }
}

