/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Type;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.AttributeContext;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.MemberResolver;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.internal.PluralAttributeMetadataImpl;
import org.hibernate.metamodel.internal.SingularAttributeMetadata;
import org.hibernate.metamodel.internal.SingularAttributeMetadataImpl;
import org.hibernate.metamodel.internal.ValueContext;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessMapImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;

public class AttributeFactory {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(AttributeFactory.class);
    private final MetadataContext context;
    private static final MemberResolver embeddedMemberResolver = (attributeContext, metadataContext) -> {
        EmbeddableDomainType ownerType = (EmbeddableDomainType)attributeContext.getOwnerType();
        if (ownerType.getRepresentationStrategy().getMode() == RepresentationMode.MAP) {
            return new MapMember(attributeContext.getPropertyMapping().getName(), ownerType.getExpressableJavaTypeDescriptor().getJavaType());
        }
        return ownerType.getRepresentationStrategy().resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter().getMember();
    };
    private static final MemberResolver virtualIdentifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityMetamodel entityMetamodel = AttributeFactory.getDeclarerEntityMetamodel(identifiableType, metadataContext);
        if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        Type type = entityMetamodel.getIdentifierProperty().getType();
        if (!(type instanceof EmbeddedComponentType)) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        EmbeddedComponentType componentType = (EmbeddedComponentType)type;
        String attributeName = attributeContext.getPropertyMapping().getName();
        Getter getter = componentType.getComponentTuplizer().getGetter(componentType.getPropertyIndex(attributeName));
        return PropertyAccessMapImpl.GetterImpl.class.isInstance(getter) ? new MapMember(attributeName, attributeContext.getPropertyMapping().getType().getReturnedClass()) : getter.getMember();
    };
    private static final MemberResolver normalMemberResolver = (attributeContext, metadataContext) -> {
        ManagedDomainType ownerType = attributeContext.getOwnerType();
        Property property = attributeContext.getPropertyMapping();
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
            return embeddedMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        if (Type.PersistenceType.ENTITY == persistenceType || Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
            String propertyName;
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)ownerType;
            EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
            EntityMetamodel entityMetamodel = declaringEntityMapping.getEntityMetamodel();
            Integer index = entityMetamodel.getPropertyIndexOrNull(propertyName = property.getName());
            if (index == null) {
                return virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext);
            }
            Getter getter = declaringEntityMapping.getRepresentationStrategy().resolvePropertyAccess(property).getGetter();
            return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(propertyName, property.getType().getReturnedClass()) : getter.getMember();
        }
        throw new IllegalArgumentException("Unexpected owner type : " + persistenceType);
    };
    private final MemberResolver identifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityMetamodel entityMetamodel = declaringEntityMapping.getEntityMetamodel();
        if (!attributeContext.getPropertyMapping().getName().equals(entityMetamodel.getIdentifierProperty().getName())) {
            return virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        Getter getter = declaringEntityMapping.getRepresentationStrategy().resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter();
        if (getter instanceof PropertyAccessMapImpl.GetterImpl) {
            return new MapMember(entityMetamodel.getIdentifierProperty().getName(), entityMetamodel.getIdentifierProperty().getType().getReturnedClass());
        }
        return getter.getMember();
    };
    private final MemberResolver versionMemberResolver = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext, MetadataContext metadataContext) {
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
            EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
            EntityMetamodel entityMetamodel = declaringEntityMapping.getEntityMetamodel();
            String versionPropertyName = attributeContext.getPropertyMapping().getName();
            if (!versionPropertyName.equals(entityMetamodel.getVersionProperty().getName())) {
                throw new IllegalArgumentException("Given property did not match declared version property");
            }
            Getter getter = declaringEntityMapping.getRepresentationStrategy().resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter();
            if (PropertyAccessMapImpl.GetterImpl.class.isInstance(getter)) {
                return new MapMember(versionPropertyName, attributeContext.getPropertyMapping().getType().getReturnedClass());
            }
            return getter.getMember();
        }
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property) {
        return AttributeFactory.buildAttribute(ownerType, property, this.context);
    }

    public static <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property, MetadataContext metadataContext) {
        if (property.isSynthetic()) {
            LOG.tracef("Skipping synthetic property %s(%s)", ownerType.getTypeName(), property.getName());
            return null;
        }
        LOG.trace("Building attribute [" + ownerType.getTypeName() + "." + property.getName() + "]");
        AttributeContext<X> attributeContext = AttributeFactory.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = AttributeFactory.determineAttributeMetadata(attributeContext, normalMemberResolver, metadataContext);
        if (attributeMetadata == null) {
            return null;
        }
        if (attributeMetadata.isPlural()) {
            return PluralAttributeBuilder.build((PluralAttributeMetadata)attributeMetadata, metadataContext);
        }
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        SimpleDomainType<Y> metaModelType = AttributeFactory.determineSimpleType(singularAttributeMetadata.getValueContext(), metadataContext);
        return new SingularAttributeImpl<X, Y>(ownerType, attributeMetadata.getName(), attributeMetadata.getAttributeClassification(), metaModelType, attributeMetadata.getMember(), false, false, property.isOptional(), metadataContext);
    }

    private static <X> AttributeContext<X> wrap(final ManagedDomainType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public ManagedDomainType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularPersistentAttribute<X, Y> buildIdAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.trace("Building identifier attribute [" + ownerType.getTypeName() + "." + property.getName() + "]");
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.identifierMemberResolver);
        return new SingularAttributeImpl.Identifier<X, Y>(ownerType, property.getName(), this.determineSimpleType(attributeMetadata.getValueContext()), attributeMetadata.getMember(), attributeMetadata.getAttributeClassification(), this.context);
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.trace("Building version attribute [ownerType.getTypeName().property.getName()]");
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.versionMemberResolver);
        return new SingularAttributeImpl.Version<X, Y>(ownerType, property.getName(), attributeMetadata.getAttributeClassification(), this.determineSimpleType(attributeMetadata.getValueContext()), attributeMetadata.getMember(), this.context);
    }

    private <Y> SimpleDomainType<Y> determineSimpleType(ValueContext typeContext) {
        return AttributeFactory.determineSimpleType(typeContext, this.context);
    }

    public static <Y> SimpleDomainType<Y> determineSimpleType(ValueContext typeContext, MetadataContext context) {
        switch (typeContext.getValueClassification()) {
            case BASIC: {
                return context.resolveBasicType(typeContext.getJpaBindableType());
            }
            case ENTITY: {
                EntityType type = (EntityType)typeContext.getHibernateValue().getType();
                return context.locateEntityType(type.getAssociatedEntityName());
            }
            case EMBEDDABLE: {
                Component component = (Component)typeContext.getHibernateValue();
                if (component.getComponentClass() != null || component.getComponentClassName() != null) {
                    Class embeddableClass = component.getComponentClass() != null ? component.getComponentClass() : context.getTypeConfiguration().getServiceRegistry().getService(ClassLoaderService.class).classForName(component.getComponentClassName());
                    EmbeddableDomainType cached = context.locateEmbeddable(embeddableClass);
                    if (cached != null) {
                        return cached;
                    }
                    JavaTypeDescriptorRegistry registry = context.getTypeConfiguration().getJavaTypeDescriptorRegistry();
                    JavaTypeDescriptor javaTypeDescriptor = registry.resolveDescriptor(embeddableClass);
                    EmbeddableRepresentationStrategy representationStrategy = context.getTypeConfiguration().getMetadataBuildingContext().getBuildingOptions().getManagedTypeRepresentationResolver().resolveStrategy(component, context.getRuntimeModelCreationContext());
                    EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(javaTypeDescriptor, representationStrategy, context.getJpaMetamodel());
                    context.registerEmbeddableType(embeddableType, component);
                    return embeddableType;
                }
                EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(component.getRoleName(), context.getJpaMetamodel());
                AttributeContainer.InFlightAccess inFlightAccess = embeddableType.getInFlightAccess();
                Iterator subProperties = component.getPropertyIterator();
                while (subProperties.hasNext()) {
                    Property property = (Property)subProperties.next();
                    PersistentAttribute attribute = AttributeFactory.buildAttribute(embeddableType, property, context);
                    if (attribute == null) continue;
                    inFlightAccess.addAttribute(attribute);
                }
                inFlightAccess.finishUp();
                return embeddableType;
            }
        }
        throw new AssertionFailure("Unknown type : " + (Object)((Object)typeContext.getValueClassification()));
    }

    private EntityMetamodel getDeclarerEntityMetamodel(AbstractIdentifiableType<?> ownerType) {
        return AttributeFactory.getDeclarerEntityMetamodel(ownerType, this.context);
    }

    private static EntityPersister getDeclaringEntity(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return metadataContext.getMetamodel().getEntityDescriptor(ownerType.getTypeName());
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = metadataContext.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return metadataContext.getMetamodel().findEntityDescriptor(persistentClass.getClassName());
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private static EntityMetamodel getDeclarerEntityMetamodel(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return metadataContext.getMetamodel().getEntityDescriptor(ownerType.getTypeName()).getEntityMetamodel();
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = metadataContext.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return metadataContext.getMetamodel().findEntityDescriptor(persistentClass.getClassName()).getEntityMetamodel();
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        return AttributeFactory.determineAttributeMetadata(attributeContext, memberResolver, this.context);
    }

    private static <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver, MetadataContext context) {
        Property propertyMapping = attributeContext.getPropertyMapping();
        String propertyName = propertyMapping.getName();
        LOG.trace("Starting attribute metadata determination [" + propertyName + "]");
        Member member = memberResolver.resolveMember(attributeContext, context);
        LOG.trace("    Determined member [" + member + "]");
        Value value = propertyMapping.getValue();
        Type type = value.getType();
        LOG.trace("    Determined type [name=" + type.getName() + ", class=" + type.getClass().getName() + "]");
        if (type.isAnyType()) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.ANY, context);
        }
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationClassification(member), context);
            }
            if (value instanceof Collection) {
                Value keyValue;
                Type keyType;
                AttributeClassification elementClassification;
                AttributeClassification attributeClassification;
                Collection collValue = (Collection)value;
                Value elementValue = collValue.getElement();
                Type elementType = elementValue.getType();
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                if (elementType.isAnyType()) {
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                    elementClassification = AttributeClassification.ANY;
                } else if (elementValue instanceof Component) {
                    elementClassification = AttributeClassification.EMBEDDED;
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                } else if (elementType.isAssociationType()) {
                    attributeClassification = elementClassification = isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
                } else {
                    elementClassification = AttributeClassification.BASIC;
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                }
                AttributeClassification indexClassification = value instanceof Map ? ((keyType = (keyValue = ((Map)value).getIndex()).getType()).isAnyType() ? AttributeClassification.ANY : (keyValue instanceof Component ? AttributeClassification.EMBEDDED : (keyType.isAssociationType() ? AttributeClassification.MANY_TO_ONE : AttributeClassification.BASIC))) : (value instanceof List ? AttributeClassification.BASIC : null);
                return new PluralAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, attributeClassification, elementClassification, indexClassification, context);
            }
            if (value instanceof OneToMany) {
                throw new IllegalArgumentException("HUH???");
            }
        } else {
            if (propertyMapping.isComposite()) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.EMBEDDED, context);
            }
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.BASIC, context);
        }
        throw new UnsupportedOperationException("oops, we are missing something: " + propertyMapping);
    }

    public static AttributeClassification determineSingularAssociationClassification(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
        }
        if (member instanceof MapMember) {
            return AttributeClassification.MANY_TO_ONE;
        }
        return ((Method)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
    }

    protected <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType) {
        return AttributeFactory.accountForPrimitiveTypes(declaredType, this.context);
    }

    public static <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType, MetadataContext metadataContext) {
        return declaredType;
    }

    public static ParameterizedType getSignatureType(Member member) {
        java.lang.reflect.Type type = member instanceof Field ? ((Field)member).getGenericType() : (member instanceof Method ? ((Method)member).getGenericReturnType() : ((MapMember)member).getType());
        if (type instanceof Class) {
            return null;
        }
        return (ParameterizedType)type;
    }

    public static boolean isManyToMany(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(ManyToMany.class) != null;
        }
        if (member instanceof Method) {
            return ((Method)member).getAnnotation(ManyToMany.class) != null;
        }
        return false;
    }
}

