/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.spi.Instantiator;

public class DynamicMapInstantiator
implements Instantiator<Map> {
    public static final EntityNameResolver ENTITY_NAME_RESOLVER = entity -> {
        if (!(entity instanceof Map)) {
            return null;
        }
        String entityName = DynamicMapInstantiator.extractEmbeddedEntityName((Map)entity);
        if (entityName == null) {
            throw new HibernateException("Could not determine type of dynamic map entity");
        }
        return entityName;
    };
    public static final String KEY = "$type$";
    private final String roleName;
    private final Set<String> isInstanceEntityNames = new HashSet<String>();

    public DynamicMapInstantiator(Component bootMapping) {
        this.roleName = bootMapping.getRoleName();
    }

    public DynamicMapInstantiator(PersistentClass bootMapping) {
        this.roleName = bootMapping.getEntityName();
        this.isInstanceEntityNames.add(this.roleName);
        if (bootMapping.hasSubclasses()) {
            Iterator itr = bootMapping.getSubclassClosureIterator();
            while (itr.hasNext()) {
                PersistentClass subclassInfo = (PersistentClass)itr.next();
                this.isInstanceEntityNames.add(subclassInfo.getEntityName());
            }
        }
    }

    @Override
    public Map instantiate(SharedSessionContractImplementor session) {
        Map map = this.generateMap();
        if (this.roleName != null) {
            map.put(KEY, this.roleName);
        }
        return map;
    }

    protected Map generateMap() {
        return new HashMap();
    }

    @Override
    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        if (object instanceof Map) {
            if (this.roleName == null) {
                return true;
            }
            String type = (String)((Map)object).get(KEY);
            return type == null || this.isInstanceEntityNames.contains(type);
        }
        return false;
    }

    public static String extractEmbeddedEntityName(Map entity) {
        if (entity == null) {
            return null;
        }
        String entityName = (String)entity.get(KEY);
        if (entityName == null) {
            throw new HibernateException("Could not determine type of dynamic map entity");
        }
        return entityName;
    }

    public static class BasicEntityNameResolver
    implements EntityNameResolver {
        public static final BasicEntityNameResolver INSTANCE = new BasicEntityNameResolver();

        @Override
        public String resolveEntityName(Object entity) {
            if (!(entity instanceof Map)) {
                return null;
            }
            String entityName = DynamicMapInstantiator.extractEmbeddedEntityName((Map)entity);
            if (entityName == null) {
                throw new HibernateException("Could not determine type of dynamic map entity");
            }
            return entityName;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

