/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.AbstractEmbeddableRepresentationStrategy;
import org.hibernate.metamodel.internal.OptimizedPojoInstantiatorImpl;
import org.hibernate.metamodel.internal.PojoInstantiatorImpl;
import org.hibernate.metamodel.spi.Instantiator;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;

public class StandardPojoEmbeddableRepresentationStrategy
extends AbstractEmbeddableRepresentationStrategy {
    private final StrategySelector strategySelector;
    private final ReflectionOptimizer reflectionOptimizer;
    private final Instantiator instantiator;

    public StandardPojoEmbeddableRepresentationStrategy(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        super(bootDescriptor, creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(bootDescriptor.getComponentClass()), creationContext);
        ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer;
        assert (bootDescriptor.getComponentClass() != null);
        this.strategySelector = creationContext.getSessionFactory().getServiceRegistry().getService(StrategySelector.class);
        this.reflectionOptimizer = this.buildReflectionOptimizer(bootDescriptor, creationContext);
        this.instantiator = this.reflectionOptimizer != null && this.reflectionOptimizer.getInstantiationOptimizer() != null ? ((instantiationOptimizer = this.reflectionOptimizer.getInstantiationOptimizer()) != null ? new OptimizedPojoInstantiatorImpl(this.getEmbeddableJavaTypeDescriptor(), instantiationOptimizer) : new PojoInstantiatorImpl(this.getEmbeddableJavaTypeDescriptor())) : new PojoInstantiatorImpl(this.getEmbeddableJavaTypeDescriptor());
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    @Override
    protected PropertyAccess buildPropertyAccess(Property bootAttributeDescriptor) {
        PropertyAccessStrategy strategy = null;
        String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
        BuiltInPropertyAccessStrategies namedStrategy = BuiltInPropertyAccessStrategies.interpret(propertyAccessorName);
        if (namedStrategy != null) {
            strategy = namedStrategy.getStrategy();
        }
        if (strategy == null) {
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttributeDescriptor instanceof Backref) {
                Backref backref = (Backref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttributeDescriptor instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.getEmbeddableJavaTypeDescriptor().getJavaType().getName(), bootAttributeDescriptor.getName()));
        }
        return strategy.buildPropertyAccess(this.getEmbeddableJavaTypeDescriptor().getJavaType(), bootAttributeDescriptor.getName());
    }

    private ReflectionOptimizer buildReflectionOptimizer(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (!Environment.useReflectionOptimizer()) {
            return null;
        }
        if (this.hasCustomAccessors()) {
            return null;
        }
        String[] getterNames = new String[this.getPropertySpan()];
        String[] setterNames = new String[this.getPropertySpan()];
        Class[] propTypes = new Class[this.getPropertySpan()];
        for (int i = 0; i < this.getPropertyAccesses().length; ++i) {
            PropertyAccess propertyAccess = this.getPropertyAccesses()[i];
            getterNames[i] = propertyAccess.getGetter().getMethodName();
            setterNames[i] = propertyAccess.getSetter().getMethodName();
            propTypes[i] = propertyAccess.getGetter().getReturnType();
        }
        return Environment.getBytecodeProvider().getReflectionOptimizer(bootDescriptor.getComponentClass(), getterNames, setterNames, propTypes);
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public <J> Instantiator<J> getInstantiator() {
        return this.instantiator;
    }
}

