/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.sql.results.spi.Fetchable;

public interface CollectionPart
extends ModelPart,
Fetchable {
    public Nature getNature();

    public MappingType getPartTypeDescriptor();

    @Override
    default public String getPartName() {
        return this.getNature().getName();
    }

    public static enum Nature {
        ELEMENT("{element}"),
        INDEX("{index}"),
        ID("{collection-id}");

        private final String name;

        private Nature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Nature fromName(String name) {
            if ("key".equals(name) || "{key}".equals(name) || "keys".equals(name) || "{keys}".equals(name) || "index".equals(name) || "{index}".equals(name) || "indices".equals(name) || "{indices}".equals(name)) {
                return INDEX;
            }
            if ("element".equals(name) || "{element}".equals(name) || "elements".equals(name) || "{elements}".equals(name) || "value".equals(name) || "{value}".equals(name) || "values".equals(name) || "{values}".equals(name)) {
                return ELEMENT;
            }
            if (Nature.ID.name.equals(name)) {
                return ID;
            }
            throw new IllegalArgumentException("Unrecognized CollectionPart Nature name [" + name + "]; expecting `" + Nature.ELEMENT.name + "` or `" + Nature.INDEX.name + "`");
        }
    }
}

