/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.composite.CompositeResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableMappingType
implements ManagedMappingType {
    private final JavaTypeDescriptor embeddableJtd;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final SessionFactoryImplementor sessionFactory;
    private final SortedMap<String, AttributeMapping> attributeMappings = new TreeMap<String, AttributeMapping>();
    private EmbeddableValuedModelPart valueMapping;
    private int cachedJdbcTypeCount = -1;
    private List<JdbcMapping> cachedJdbcMappings;

    public static EmbeddableMappingType from(Component bootDescriptor, CompositeType compositeType, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableRepresentationStrategy representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, creationContext);
        EmbeddableMappingType mappingType = new EmbeddableMappingType(bootDescriptor, representationStrategy, creationContext.getSessionFactory());
        mappingType.valueMapping = embeddedPartBuilder.apply(mappingType);
        creationProcess.registerInitializationCallback(() -> mappingType.finishInitialization(bootDescriptor, compositeType, creationProcess));
        return mappingType;
    }

    public EmbeddableMappingType(Component bootDescriptor, EmbeddableRepresentationStrategy representationStrategy, SessionFactoryImplementor sessionFactory) {
        this.embeddableJtd = representationStrategy.getMappedJavaTypeDescriptor();
        this.representationStrategy = representationStrategy;
        this.sessionFactory = sessionFactory;
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, MappingModelCreationProcess creationProcess) {
        String containingTableExpression = this.valueMapping.getContainingTableExpression();
        List<String> mappedColumnExpressions = this.valueMapping.getMappedColumnExpressions();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        Iterator propertyIterator = bootDescriptor.getPropertyIterator();
        while (propertyIterator.hasNext()) {
            Property bootPropertyDescriptor = (Property)propertyIterator.next();
            if (subtypes[attributeIndex] instanceof BasicType) {
                this.attributeMappings.put(bootPropertyDescriptor.getName(), MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, this, (BasicType)subtypes[attributeIndex], containingTableExpression, mappedColumnExpressions.get(columnPosition++), this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess));
            } else if (subtypes[attributeIndex] instanceof CompositeType) {
                CompositeType subCompositeType = (CompositeType)subtypes[attributeIndex];
                int columnSpan = subCompositeType.getColumnSpan(creationProcess.getCreationContext().getSessionFactory());
                this.attributeMappings.put(bootPropertyDescriptor.getName(), MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, this, subCompositeType, containingTableExpression, ArrayHelper.toStringArray(mappedColumnExpressions.subList(columnPosition, columnPosition + columnSpan)), this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess));
                columnPosition += columnSpan;
            }
            ++attributeIndex;
        }
        return true;
    }

    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.valueMapping;
    }

    @Override
    public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
        return this.embeddableJtd;
    }

    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public String getPartName() {
        return this.getEmbeddedValueMapping().getPartName();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new CompositeResult(navigablePath, this.valueMapping, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int getNumberOfFetchables() {
        return this.attributeMappings.size();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(attributeMapping -> fetchableConsumer.accept((Fetchable)((Object)attributeMapping)));
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        if (this.cachedJdbcTypeCount == -1) {
            int count = 0;
            for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
                count += attributeMapping.getJdbcTypeCount(typeConfiguration);
            }
            this.cachedJdbcTypeCount = count;
        }
        return this.cachedJdbcTypeCount;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        if (this.cachedJdbcMappings == null) {
            ArrayList result = new ArrayList();
            this.visitJdbcTypes(result::add, Clause.IRRELEVANT, typeConfiguration);
            this.cachedJdbcMappings = Collections.unmodifiableList(result);
        }
        return this.cachedJdbcMappings;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.attributeMappings.forEach((s, attributeMapping) -> attributeMapping.visitJdbcTypes(action, clause, typeConfiguration));
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void visitDisassembledJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        this.attributeMappings.forEach((s, attributeMapping) -> {
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            attributeMapping.visitJdbcValues(o, clause, consumer, session);
        });
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        this.attributeMappings.values().forEach(attributeMapping -> attributeMapping.visitColumns(consumer));
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        return (AttributeMapping)this.attributeMappings.get(name);
    }

    @Override
    public Collection<AttributeMapping> getAttributeMappings() {
        return this.attributeMappings.values();
    }

    @Override
    public void visitAttributeMappings(Consumer<AttributeMapping> action) {
        this.attributeMappings.values().forEach(action);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return (ModelPart)this.attributeMappings.get(name);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(consumer::accept);
    }

    public void setPropertyValues(final Object compositeInstance, final Object[] resolvedValues) {
        this.visitAttributeMappings(new Consumer<AttributeMapping>(){
            private int i = 0;

            @Override
            public void accept(AttributeMapping attributeMapping) {
                attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(null).getPropertyAccess().getSetter().set(compositeInstance, resolvedValues[this.i++], EmbeddableMappingType.this.sessionFactory);
            }
        });
    }
}

