/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.loader.spi.Loadable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReferenceCollector;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public interface EntityMappingType
extends ManagedMappingType,
Loadable {
    public EntityPersister getEntityPersister();

    public String getEntityName();

    @Override
    default public String getPartName() {
        return this.getEntityName();
    }

    @Override
    default public String getRootPathName() {
        return this.getEntityName();
    }

    @Override
    default public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedJavaTypeDescriptor();
    }

    default public AttributeMapping findDeclaredAttributeMapping(String name) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public int getNumberOfDeclaredAttributeMappings() {
        return this.getDeclaredAttributeMappings().size();
    }

    default public Collection<AttributeMapping> getDeclaredAttributeMappings() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public void visitDeclaredAttributeMappings(Consumer<AttributeMapping> action) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public EntityMappingType getSuperMappingType() {
        return null;
    }

    default public boolean isTypeOrSuperType(EntityMappingType targetType) {
        return targetType == this;
    }

    default public boolean isTypeOrSuperType(ManagedMappingType targetType) {
        if (targetType instanceof EntityMappingType) {
            return this.isTypeOrSuperType((EntityMappingType)targetType);
        }
        return false;
    }

    default public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy() {
        return this.getEntityPersister().getSqmMultiTableMutationStrategy();
    }

    public EntityIdentifierMapping getIdentifierMapping();

    public EntityVersionMapping getVersionMapping();

    default public EntityDiscriminatorMapping getDiscriminatorMapping() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public NaturalIdMapping getNaturalIdMapping();

    default public void visitAttributeMappings(Consumer<AttributeMapping> action, EntityMappingType targetType) {
        this.getAttributeMappings().forEach(action);
    }

    default public void visitSubTypeAttributeMappings(Consumer<AttributeMapping> action) {
    }

    default public void visitSuperTypeAttributeMappings(Consumer<AttributeMapping> action) {
    }

    default public void visitConstraintOrderedTables(ConstraintOrderedTableConsumer consumer) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public void visitAttributeMappings(Consumer<AttributeMapping> action) {
        this.getAttributeMappings().forEach(action);
    }

    default public Object[] extractConcreteTypeStateValues(final Map<AttributeMapping, DomainResultAssembler> assemblerMapping, final RowProcessingState rowProcessingState) {
        final Object[] values = new Object[this.getNumberOfAttributeMappings()];
        this.visitStateArrayContributors(new Consumer<StateArrayContributorMapping>(){
            private int index;

            @Override
            public void accept(StateArrayContributorMapping attribute) {
                DomainResultAssembler assembler = (DomainResultAssembler)assemblerMapping.get(attribute);
                Serializable value = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
                values[this.index++] = value;
            }
        });
        return values;
    }

    @Override
    default public void visitStateArrayContributors(Consumer<StateArrayContributorMapping> mappingConsumer) {
        this.visitAttributeMappings(attributeMapping -> mappingConsumer.accept((StateArrayContributorMapping)attributeMapping));
    }

    @Override
    default public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFilters(influencers);
    }

    @Override
    default public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEntityGraph(influencers);
    }

    @Override
    default public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    default public TableGroup createRootTableGroup(NavigablePath navigablePath, String explicitSourceAlias, JoinType tableReferenceJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationContext creationContext) {
        return this.getEntityPersister().createRootTableGroup(navigablePath, explicitSourceAlias, tableReferenceJoinType, lockMode, aliasBaseGenerator, sqlExpressionResolver, additionalPredicateCollectorAccess, creationContext);
    }

    @Override
    default public void applyTableReferences(SqlAliasBase sqlAliasBase, JoinType baseJoinType, TableReferenceCollector collector, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        this.getEntityPersister().applyTableReferences(sqlAliasBase, baseJoinType, collector, sqlExpressionResolver, creationContext);
    }

    @Override
    default public int getNumberOfAttributeMappings() {
        return this.getEntityPersister().getNumberOfAttributeMappings();
    }

    @Override
    default public Collection<AttributeMapping> getAttributeMappings() {
        return this.getEntityPersister().getAttributeMappings();
    }

    @Override
    default public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
        return this.getEntityPersister().getMappedJavaTypeDescriptor();
    }

    @Override
    default public String getSqlAliasStem() {
        return this.getEntityPersister().getSqlAliasStem();
    }

    @Override
    default public int getNumberOfFetchables() {
        return this.getEntityPersister().getNumberOfFetchables();
    }

    public static interface ConstraintOrderedTableConsumer {
        public void consume(String var1, Supplier<Consumer<ColumnConsumer>> var2);
    }
}

