/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.basic.BasicFetch;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEntityDiscriminatorMapping
implements EntityDiscriminatorMapping {
    private final EntityPersister entityDescriptor;
    private final String tableExpression;
    private final String mappedColumnExpression;
    private final BasicType mappingType;

    public AbstractEntityDiscriminatorMapping(EntityPersister entityDescriptor, String tableExpression, String mappedColumnExpression, BasicType mappingType) {
        this.entityDescriptor = entityDescriptor;
        this.tableExpression = tableExpression;
        this.mappedColumnExpression = mappedColumnExpression;
        this.mappingType = mappingType;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.mappedColumnExpression;
    }

    @Override
    public BasicValueConverter getConverter() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return "{discriminator}";
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(tableGroup, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, false, this.getConverter(), fetchTiming, creationState);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.mappingType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.mappingType.getJdbcMapping();
    }

    protected abstract SqlSelection resolveSqlSelection(TableGroup var1, DomainResultCreationState var2);
}

