/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.SqlResultsLogger;
import org.hibernate.sql.results.internal.domain.basic.BasicFetch;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValuedCollectionPart
implements CollectionPart,
BasicValuedModelPart {
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final BasicType mapper;
    private final BasicValueConverter valueConverter;
    private final String tableExpression;
    private final String columnExpression;

    public BasicValuedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, BasicType mapper, BasicValueConverter valueConverter, String tableExpression, String columnExpression) {
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.mapper = mapper;
        this.valueConverter = valueConverter;
        this.tableExpression = tableExpression;
        this.columnExpression = columnExpression;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public BasicType getPartTypeDescriptor() {
        return this.mapper;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.columnExpression;
    }

    @Override
    public BasicValueConverter getConverter() {
        return this.valueConverter;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.mapper.getMappedJavaTypeDescriptor();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), this.valueConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver exprResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        return exprResolver.resolveSqlSelection(exprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnExpression), sqlAstProcessingState -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnExpression, (JdbcMapping)this.mapper, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.mapper;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.mapper;
    }

    @Override
    public String getFetchableName() {
        return this.nature == CollectionPart.Nature.ELEMENT ? "{value}" : "{key}";
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlResultsLogger.INSTANCE.debugf("Generating Fetch for collection-part : `%s` -> `%s`", this.collectionDescriptor.getRole(), this.nature.getName());
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(fetchablePath.getParent());
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, false, this.valueConverter, FetchTiming.IMMEDIATE, creationState);
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        return Collections.singletonList(this.getJdbcMapping());
    }
}

