/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.CompositeTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceCollector;
import org.hibernate.sql.results.internal.domain.composite.CompositeFetch;
import org.hibernate.sql.results.internal.domain.composite.CompositeResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddedAttributeMapping
extends AbstractSingularAttributeMapping
implements EmbeddableValuedModelPart,
Fetchable {
    private final String tableExpression;
    private final String[] attrColumnNames;

    public EmbeddedAttributeMapping(String name, int stateArrayPosition, String tableExpression, String[] attrColumnNames, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, EmbeddableMappingType valueMapping, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, valueMapping, declaringType, propertyAccess);
        this.tableExpression = tableExpression;
        this.attrColumnNames = attrColumnNames;
    }

    @Override
    public EmbeddableMappingType getMappedTypeDescriptor() {
        return (EmbeddableMappingType)super.getMappedTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.getMappedTypeDescriptor();
    }

    @Override
    public SingularAttributeMapping getParentInjectionAttributeMapping() {
        return null;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public List<String> getMappedColumnExpressions() {
        return Arrays.asList(this.attrColumnNames);
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddableTypeDescriptor().visitJdbcTypes(action, clause, typeConfiguration);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().visitJdbcValues(value, clause, valuesConsumer, session);
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        this.getEmbeddableTypeDescriptor().visitColumns(consumer);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new CompositeResult(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new CompositeFetch(fetchablePath, this, fetchParent, fetchTiming, this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), creationState);
    }

    @Override
    public Expression toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, final SqlAstCreationState sqlAstCreationState) {
        final ArrayList columnReferences = CollectionHelper.arrayList(this.attrColumnNames.length);
        final TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().visitJdbcTypes(new Consumer<JdbcMapping>(){
            private int index = 0;

            @Override
            public void accept(JdbcMapping jdbcMapping) {
                String attrColumnExpr = EmbeddedAttributeMapping.this.attrColumnNames[this.index++];
                Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, attrColumnExpr), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), attrColumnExpr, jdbcMapping, sqlAstCreationState.getCreationContext().getSessionFactory()));
                columnReferences.add((ColumnReference)columnReference);
            }
        }, clause, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getMappedTypeDescriptor().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getMappedTypeDescriptor().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, JoinType joinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        CompositeTableGroup compositeTableGroup = new CompositeTableGroup(navigablePath, this, lhs);
        lhs.addTableGroupJoin(new TableGroupJoin(navigablePath, JoinType.INNER, compositeTableGroup, null));
        return new TableGroupJoin(navigablePath, joinType, compositeTableGroup);
    }

    @Override
    public void applyTableReferences(SqlAliasBase sqlAliasBase, JoinType baseJoinType, TableReferenceCollector collector, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        this.getEmbeddableTypeDescriptor().visitAttributeMappings(attrMapping -> {
            if (attrMapping instanceof TableGroupProducer) {
                ((TableGroupProducer)((Object)attrMapping)).applyTableReferences(sqlAliasBase, baseJoinType, collector, sqlExpressionResolver, creationContext);
            } else if (attrMapping.getMappedTypeDescriptor() instanceof TableGroupProducer) {
                ((TableGroupProducer)((Object)attrMapping.getMappedTypeDescriptor())).applyTableReferences(sqlAliasBase, baseJoinType, collector, sqlExpressionResolver, creationContext);
            }
        });
    }

    @Override
    public String getSqlAliasStem() {
        return this.getAttributeName();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }
}

