/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadata;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.ValueMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.BasicValuedSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.CollectionIdentifierDescriptorImpl;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.spi.DomainMetamodel;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.internal.domain.basic.BasicFetch;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingModelCreationHelper {
    private MappingModelCreationHelper() {
    }

    public static BasicEntityIdentifierMapping buildSimpleIdentifierMapping(final EntityPersister entityPersister, final String rootTable, final String pkColumnName, final BasicType idType, final MappingModelCreationProcess creationProcess) {
        assert (entityPersister.hasIdentifierProperty());
        assert (entityPersister.getIdentifierPropertyName() != null);
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        final PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        return new BasicEntityIdentifierMapping(){

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MappingType getMappedTypeDescriptor() {
                return ((BasicType)entityPersister.getIdentifierType()).getMappedTypeDescriptor();
            }

            @Override
            public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
                return 1;
            }

            @Override
            public void visitColumns(ColumnConsumer consumer) {
                consumer.accept(this.getMappedColumnExpression(), this.getContainingTableExpression(), this.getJdbcMapping());
            }

            @Override
            public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
                action.accept(idType);
            }

            @Override
            public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
                valuesConsumer.consume(value, idType);
            }

            @Override
            public JavaTypeDescriptor getJavaTypeDescriptor() {
                return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
            }

            @Override
            public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
                SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
                TableReference rootTableReference = tableGroup.resolveTableReference(rootTable);
                Expression expression = expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(rootTableReference, pkColumnName), sqlAstProcessingState -> new ColumnReference(rootTableReference.getIdentificationVariable(), pkColumnName, ((BasicValuedMapping)((Object)entityPersister.getIdentifierType())).getJdbcMapping(), creationProcess.getCreationContext().getSessionFactory()));
                SqlSelection sqlSelection = expressionResolver.resolveSqlSelection(expression, idType.getExpressableJavaTypeDescriptor(), creationProcess.getCreationContext().getSessionFactory().getTypeConfiguration());
                return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, entityPersister.getIdentifierMapping().getMappedTypeDescriptor().getMappedJavaTypeDescriptor());
            }

            @Override
            public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
                SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
                TableReference rootTableReference = tableGroup.resolveTableReference(rootTable);
                Expression expression = expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(rootTableReference, pkColumnName), sqlAstProcessingState -> new ColumnReference(rootTable, pkColumnName, ((BasicValuedModelPart)((Object)entityPersister.getIdentifierType())).getJdbcMapping(), creationProcess.getCreationContext().getSessionFactory()));
                expressionResolver.resolveSqlSelection(expression, idType.getExpressableJavaTypeDescriptor(), creationProcess.getCreationContext().getSessionFactory().getTypeConfiguration());
            }

            @Override
            public String getContainingTableExpression() {
                return rootTable;
            }

            @Override
            public BasicValueConverter getConverter() {
                return null;
            }

            @Override
            public String getMappedColumnExpression() {
                return pkColumnName;
            }

            @Override
            public JdbcMapping getJdbcMapping() {
                return idType;
            }

            @Override
            public String getFetchableName() {
                return entityPersister.getIdentifierPropertyName();
            }

            @Override
            public FetchStrategy getMappedFetchStrategy() {
                return FetchStrategy.IMMEDIATE_JOIN;
            }

            @Override
            public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
                return new BasicFetch(0, fetchParent, fetchablePath, this, false, null, FetchTiming.IMMEDIATE, creationState);
            }
        };
    }

    public static EntityIdentifierMapping buildEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, Property bootProperty, String attributeName, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(propertyAccess);
        EmbeddableMappingType embeddableMappingType = EmbeddableMappingType.from((Component)bootProperty.getValue(), cidType, attributeMappingType -> new EmbeddedIdentifierMappingImpl(attributeName, (MappingType)attributeMappingType, attributeMetadataAccess, propertyAccess, rootTableName, rootTableKeyColumnNames), creationProcess);
        return (EmbeddedIdentifierMappingImpl)embeddableMappingType.getEmbeddedValueMapping();
    }

    public static EntityIdentifierMapping buildNonEncapsulatedCompositeIdentifierMapping(final EntityPersister entityPersister, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        final PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        return new EntityIdentifierMapping(){

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MappingType getMappedTypeDescriptor() {
                return entityPersister;
            }

            @Override
            public JavaTypeDescriptor getJavaTypeDescriptor() {
                return this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor();
            }

            @Override
            public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
                return ((ModelPart)((Object)entityPersister.getIdentifierType())).createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
            }

            @Override
            public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
                ((ModelPart)((Object)entityPersister.getIdentifierType())).applySqlSelections(navigablePath, tableGroup, creationState);
            }
        };
    }

    public static BasicValuedSingularAttributeMapping buildBasicAttributeMapping(String attrName, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, BasicType attrType, String tableExpression, String attrColumnName, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        FetchStrategy fetchStrategy;
        final BasicValue.Resolution<?> resolution = ((BasicValue)bootProperty.getValue()).resolve();
        BasicValueConverter valueConverter = resolution.getValueConverter();
        StateArrayContributorMetadataAccess attributeMetadataAccess = entityMappingType -> new StateArrayContributorMetadata(){
            private final MutabilityPlan mutabilityPlan;
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            {
                this.mutabilityPlan = resolution.getMutabilityPlan();
                this.nullable = bootProperty.getValue().isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
        FetchStrategy fetchStrategy2 = fetchStrategy = bootProperty.isLazy() ? new FetchStrategy(FetchTiming.DELAYED, FetchStyle.SELECT) : FetchStrategy.IMMEDIATE_JOIN;
        if (valueConverter != null) {
            assert (valueConverter.getRelationalJavaDescriptor() == resolution.getRelationalJavaDescriptor());
            BasicType<?> mappingBasicType = creationProcess.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().resolve(valueConverter.getRelationalJavaDescriptor(), resolution.getRelationalSqlTypeDescriptor());
            return new BasicValuedSingularAttributeMapping(attrName, stateArrayPosition, attributeMetadataAccess, fetchStrategy, tableExpression, attrColumnName, valueConverter, mappingBasicType, mappingBasicType.getJdbcMapping(), declaringType, propertyAccess);
        }
        return new BasicValuedSingularAttributeMapping(attrName, stateArrayPosition, attributeMetadataAccess, fetchStrategy, tableExpression, attrColumnName, null, attrType, attrType, declaringType, propertyAccess);
    }

    public static EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] attrColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
        EmbeddableMappingType embeddableMappingType = EmbeddableMappingType.from((Component)bootProperty.getValue(), attrType, attributeMappingType -> new EmbeddedAttributeMapping(attrName, stateArrayPosition, tableExpression, attrColumnNames, attributeMetadataAccess, FetchStrategy.IMMEDIATE_JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess), creationProcess);
        return (EmbeddedAttributeMapping)embeddableMappingType.getEmbeddedValueMapping();
    }

    protected static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final Property bootProperty, final Type attrType, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, final MappingModelCreationProcess creationProcess) {
        return entityMappingType -> new StateArrayContributorMetadata(){
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            private final MutabilityPlan mutabilityPlan;
            {
                this.nullable = bootProperty.getValue().isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
                this.mutabilityPlan = this.updateable ? new MutabilityPlan(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return attrType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    public Serializable disassemble(Object value) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }

                    public Object assemble(Serializable cached) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
    }

    protected static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final PropertyAccess propertyAccess) {
        return entityMappingType -> new StateArrayContributorMetadata(){
            private final MutabilityPlan mutabilityPlan = ImmutableMutabilityPlan.INSTANCE;

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return false;
            }

            @Override
            public boolean isInsertable() {
                return true;
            }

            @Override
            public boolean isUpdatable() {
                return false;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return false;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return true;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return null;
            }
        };
    }

    public static PluralAttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, final PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        CollectionPart indexDescriptor;
        CollectionMappingTypeImpl collectionMappingType;
        org.hibernate.mapping.Collection bootValueMapping = (org.hibernate.mapping.Collection)bootProperty.getValue();
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        Dialect dialect = sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect();
        DomainMetamodel domainModel = creationContext.getDomainModel();
        CollectionPersister collectionDescriptor = domainModel.findCollectionDescriptor(bootValueMapping.getRole());
        assert (collectionDescriptor != null);
        String tableExpression = ((Joinable)((Object)collectionDescriptor)).getTableName();
        String sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(bootProperty.getName());
        JavaTypeDescriptorRegistry jtdRegistry = creationContext.getJavaTypeDescriptorRegistry();
        ForeignKeyDescriptor keyDescriptor = MappingModelCreationHelper.interpretKeyDescriptor(bootProperty, bootValueMapping, collectionDescriptor, declaringType, dialect, creationProcess);
        CollectionPart elementDescriptor = MappingModelCreationHelper.interpretElement(bootValueMapping, tableExpression, collectionDescriptor, sqlAliasStem, dialect, creationProcess);
        CollectionIdentifierDescriptorImpl identifierDescriptor = null;
        CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
        switch (collectionSemantics.getCollectionClassification()) {
            case ARRAY: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(Object[].class), StandardArraySemantics.INSTANCE);
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), null, tableExpression, index.getColumnIterator().next().getText(dialect));
                break;
            }
            case BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(Collection.class), StandardBagSemantics.INSTANCE);
                indexDescriptor = null;
                break;
            }
            case IDBAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(Collection.class), StandardIdentifierBagSemantics.INSTANCE);
                indexDescriptor = null;
                assert (collectionDescriptor instanceof SQLLoadableCollection);
                SQLLoadableCollection loadableCollection = (SQLLoadableCollection)collectionDescriptor;
                String identifierColumnName = loadableCollection.getIdentifierColumnName();
                assert (identifierColumnName != null);
                identifierDescriptor = new CollectionIdentifierDescriptorImpl(collectionDescriptor, tableExpression, identifierColumnName, (BasicType)loadableCollection.getIdentifierType());
                break;
            }
            case LIST: {
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), null, tableExpression, index.getColumnIterator().next().getText(dialect));
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(List.class), StandardListSemantics.INSTANCE);
                break;
            }
            case MAP: 
            case ORDERED_MAP: 
            case SORTED_MAP: {
                Class mapJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedMap.class : Map.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(mapJavaType), collectionSemantics);
                indexDescriptor = MappingModelCreationHelper.interpretMapKey(bootValueMapping, collectionDescriptor, tableExpression, sqlAliasStem, dialect, creationProcess);
                break;
            }
            case SET: 
            case ORDERED_SET: 
            case SORTED_SET: {
                Class setJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedSet.class : Set.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor(setJavaType), collectionSemantics);
                indexDescriptor = null;
                break;
            }
            default: {
                throw new MappingException("Unexpected CollectionClassification : " + (Object)((Object)collectionSemantics.getCollectionClassification()));
            }
        }
        StateArrayContributorMetadata contributorMetadata = new StateArrayContributorMetadata(){

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return ImmutableMutabilityPlan.instance();
            }

            @Override
            public boolean isNullable() {
                return bootProperty.isOptional();
            }

            @Override
            public boolean isInsertable() {
                return bootProperty.isInsertable();
            }

            @Override
            public boolean isUpdatable() {
                return bootProperty.isUpdateable();
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return false;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return bootProperty.isOptimisticLocked();
            }
        };
        FetchStyle style = FetchStrategyHelper.determineFetchStyleByMetadata(((OuterJoinLoadable)declaringType).getFetchMode(stateArrayPosition), collectionDescriptor.getCollectionType(), sessionFactory);
        return new PluralAttributeMappingImpl(attrName, bootValueMapping, propertyAccess, entityMappingType -> contributorMetadata, collectionMappingType, stateArrayPosition, keyDescriptor, elementDescriptor, indexDescriptor, identifierDescriptor, new FetchStrategy(FetchStrategyHelper.determineFetchTiming(style, collectionDescriptor.getCollectionType(), sessionFactory), style), cascadeStyle, declaringType, collectionDescriptor);
    }

    private static ForeignKeyDescriptor interpretKeyDescriptor(Property bootProperty, org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, ManagedMappingType declaringType, Dialect dialect, MappingModelCreationProcess creationProcess) {
        Type keyType = bootValueMapping.getKey().getType();
        String lhsPropertyName = collectionDescriptor.getCollectionType().getLHSPropertyName();
        ValueMapping fkTarget = lhsPropertyName == null ? collectionDescriptor.getOwnerEntityPersister().getIdentifierMapping() : declaringType.findAttributeMapping(lhsPropertyName);
        if (keyType instanceof BasicType) {
            assert (bootValueMapping.getKey().getColumnSpan() == 1);
            assert (fkTarget instanceof BasicValuedModelPart);
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)fkTarget;
            return new SimpleForeignKeyDescriptor(((AssociationType)bootValueMapping.getType()).getForeignKeyDirection(), bootValueMapping.getKey().getTable().getName(), bootValueMapping.getKey().getColumnIterator().next().getText(dialect), simpleFkTarget.getContainingTableExpression(), simpleFkTarget.getMappedColumnExpression(), (BasicType)keyType);
        }
        throw new NotYetImplementedFor6Exception("Support for composite foreign-keys not yet implemented: " + bootValueMapping.getRole());
    }

    public static void interpretKeyDescriptor(SingularAssociationAttributeMapping attributeMapping, Property bootProperty, ToOne bootValueMapping, EntityPersister declaringEntityDescriptor, Dialect dialect, MappingModelCreationProcess creationProcess) {
        if (attributeMapping.getForeignKeyDescriptor() != null) {
            return;
        }
        EntityPersister referencedEntityDescriptor = creationProcess.getEntityPersister(bootValueMapping.getReferencedEntityName());
        ForeignKeyDirection foreignKeyDirection = ((AssociationType)bootValueMapping.getType()).getForeignKeyDirection();
        referencedEntityDescriptor.prepareMappingModel(creationProcess);
        EntityIdentifierMapping fkTarget = bootValueMapping.isReferenceToPrimaryKey() ? referencedEntityDescriptor.getIdentifierMapping() : declaringEntityDescriptor.getIdentifierMapping();
        JdbcServices jdbcServices = creationProcess.getCreationContext().getSessionFactory().getJdbcServices();
        if (fkTarget instanceof BasicValuedModelPart) {
            if (bootValueMapping.isReferenceToPrimaryKey()) {
                Iterator<Selectable> columnIterator = bootValueMapping.getColumnIterator();
                String keyColumnExpression = columnIterator.hasNext() ? columnIterator.next().getText(dialect) : bootValueMapping.getTable().getColumn(0).getName();
                String keyTableIdentifierExpression = creationProcess.getCreationContext().getBootstrapContext().getMetadataBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(bootValueMapping.getTable().getNameIdentifier(), jdbcServices.getJdbcEnvironment()).getText();
                BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)((Object)fkTarget);
                SimpleForeignKeyDescriptor foreignKeyDescriptor = new SimpleForeignKeyDescriptor(foreignKeyDirection, keyTableIdentifierExpression, keyColumnExpression, simpleFkTarget.getContainingTableExpression(), simpleFkTarget.getMappedColumnExpression(), simpleFkTarget.getJdbcMapping());
                attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
            } else {
                SingularAssociationAttributeMapping subPart = (SingularAssociationAttributeMapping)referencedEntityDescriptor.findSubPart(bootValueMapping.getReferencedPropertyName());
                ForeignKeyDescriptor foreignKeyDescriptor = subPart.getForeignKeyDescriptor();
                if (foreignKeyDescriptor == null) {
                    PersistentClass entityBinding = creationProcess.getCreationContext().getBootModel().getEntityBinding(referencedEntityDescriptor.getEntityName());
                    Property property = entityBinding.getProperty(bootValueMapping.getReferencedPropertyName());
                    MappingModelCreationHelper.interpretKeyDescriptor(subPart, property, (ToOne)property.getValue(), referencedEntityDescriptor, dialect, creationProcess);
                    attributeMapping.setForeignKeyDescriptor(subPart.getForeignKeyDescriptor());
                } else {
                    attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
                }
            }
        } else {
            throw new NotYetImplementedFor6Exception("Support for composite foreign-keys not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
        }
    }

    private static CollectionPart interpretMapKey(org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, String tableExpression, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        assert (bootValueMapping instanceof IndexedCollection);
        IndexedCollection indexedCollection = (IndexedCollection)bootValueMapping;
        Value bootMapKeyDescriptor = indexedCollection.getIndex();
        if (bootMapKeyDescriptor instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)bootMapKeyDescriptor;
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, basicValue.resolve().getResolvedBasicType(), basicValue.resolve().getValueConverter(), tableExpression, basicValue.getColumnIterator().next().getText(dialect));
        }
        if (bootMapKeyDescriptor instanceof Component) {
            Component component = (Component)bootMapKeyDescriptor;
            CompositeType compositeType = (CompositeType)component.getType();
            ArrayList columnExpressions = CollectionHelper.arrayList(component.getColumnSpan());
            Iterator<Selectable> columnIterator = component.getColumnIterator();
            while (columnIterator.hasNext()) {
                columnExpressions.add(columnIterator.next().getText(dialect));
            }
            EmbeddableMappingType mappingType = EmbeddableMappingType.from(component, compositeType, inflightDescriptor -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, (EmbeddableMappingType)inflightDescriptor, null, tableExpression, columnExpressions, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (bootMapKeyDescriptor instanceof OneToMany || bootMapKeyDescriptor instanceof ToOne) {
            EntityPersister associatedEntity = bootMapKeyDescriptor instanceof OneToMany ? creationProcess.getEntityPersister(((OneToMany)bootMapKeyDescriptor).getReferencedEntityName()) : creationProcess.getEntityPersister(((ToOne)bootMapKeyDescriptor).getReferencedEntityName());
            return new EntityCollectionPart(CollectionPart.Nature.ELEMENT, associatedEntity);
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with index type [" + bootMapKeyDescriptor + "] not yet implemented");
    }

    private static CollectionPart interpretElement(org.hibernate.mapping.Collection bootDescriptor, String tableExpression, CollectionPersister collectionDescriptor, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        Value element = bootDescriptor.getElement();
        if (element instanceof BasicValue) {
            BasicValue basicElement = (BasicValue)element;
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, basicElement.resolve().getResolvedBasicType(), basicElement.resolve().getValueConverter(), tableExpression, basicElement.getColumnIterator().next().getText(dialect));
        }
        if (element instanceof Component) {
            Component component = (Component)element;
            CompositeType compositeType = (CompositeType)collectionDescriptor.getElementType();
            ArrayList columnExpressions = CollectionHelper.arrayList(component.getColumnSpan());
            Iterator<Selectable> columnIterator = component.getColumnIterator();
            while (columnIterator.hasNext()) {
                columnExpressions.add(columnIterator.next().getText(dialect));
            }
            EmbeddableMappingType mappingType = EmbeddableMappingType.from(component, compositeType, embeddableMappingType -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, (EmbeddableMappingType)embeddableMappingType, null, tableExpression, columnExpressions, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (element instanceof OneToMany || element instanceof ToOne) {
            EntityPersister associatedEntity = element instanceof OneToMany ? creationProcess.getEntityPersister(((OneToMany)element).getReferencedEntityName()) : creationProcess.getEntityPersister(((ToOne)element).getReferencedEntityName());
            return new EntityCollectionPart(CollectionPart.Nature.ELEMENT, associatedEntity);
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with element type [" + element + "] not yet implemented");
    }

    public static SingularAssociationAttributeMapping buildSingularAssociationAttributeMapping(String attrName, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        ToOne value = (ToOne)bootProperty.getValue();
        EntityPersister entityPersister = creationProcess.getEntityPersister(value.getReferencedEntityName());
        StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
        SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        AssociationType type = (AssociationType)bootProperty.getType();
        FetchStyle fetchStyle = FetchStrategyHelper.determineFetchStyleByMetadata(bootProperty.getValue().getFetchMode(), type, sessionFactory);
        FetchTiming fetchTiming = FetchStrategyHelper.determineFetchTiming(fetchStyle, type, sessionFactory);
        FetchStrategy fetchStrategy = new FetchStrategy(fetchTiming, fetchStyle);
        return new SingularAssociationAttributeMapping(attrName, stateArrayPosition, (ToOne)bootProperty.getValue(), stateArrayContributorMetadataAccess, fetchStrategy, entityPersister, declaringType, propertyAccess);
    }

    private static class CollectionMappingTypeImpl
    implements CollectionMappingType {
        private final JavaTypeDescriptor collectionJtd;
        private final CollectionSemantics semantics;

        public CollectionMappingTypeImpl(JavaTypeDescriptor collectionJtd, CollectionSemantics semantics) {
            this.collectionJtd = collectionJtd;
            this.semantics = semantics;
        }

        public CollectionSemantics getCollectionSemantics() {
            return this.semantics;
        }

        @Override
        public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
            return this.collectionJtd;
        }
    }
}

