/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;

public class MappingModelCreationProcess {
    private final Map<String, EntityPersister> entityPersisterMap;
    private final RuntimeModelCreationContext creationContext;
    private String currentlyProcessingRole;
    private List<PostInitCallback> postInitCallbacks;

    public static void process(Map<String, EntityPersister> entityPersisterMap, RuntimeModelCreationContext creationContext) {
        MappingModelCreationProcess process = new MappingModelCreationProcess(entityPersisterMap, creationContext);
        process.execute();
    }

    private MappingModelCreationProcess(Map<String, EntityPersister> entityPersisterMap, RuntimeModelCreationContext creationContext) {
        this.entityPersisterMap = entityPersisterMap;
        this.creationContext = creationContext;
    }

    public RuntimeModelCreationContext getCreationContext() {
        return this.creationContext;
    }

    public EntityPersister getEntityPersister(String name) {
        return this.entityPersisterMap.get(name);
    }

    private void execute() {
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            entityPersister.linkWithSuperType(this);
        }
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            this.currentlyProcessingRole = entityPersister.getEntityName();
            entityPersister.prepareMappingModel(this);
        }
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            this.currentlyProcessingRole = entityPersister.getEntityName();
            entityPersister.finishMappingModelInitialization(this);
        }
        while (this.postInitCallbacks != null && !this.postInitCallbacks.isEmpty()) {
            ArrayList<PostInitCallback> copy = new ArrayList<PostInitCallback>(new ArrayList<PostInitCallback>(this.postInitCallbacks));
            for (PostInitCallback callback : copy) {
                boolean completed = callback.process();
                if (!completed) continue;
                this.postInitCallbacks.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModelPart> T processSubPart(String localName, SubPartMappingProducer<T> subPartMappingProducer) {
        assert (this.currentlyProcessingRole != null);
        String initialRole = this.currentlyProcessingRole;
        this.currentlyProcessingRole = this.currentlyProcessingRole + '#' + localName;
        try {
            ModelPart modelPart = (ModelPart)subPartMappingProducer.produceSubMapping(this.currentlyProcessingRole, this);
            return (T)modelPart;
        }
        finally {
            this.currentlyProcessingRole = initialRole;
        }
    }

    public void registerInitializationCallback(PostInitCallback callback) {
        if (this.postInitCallbacks == null) {
            this.postInitCallbacks = new ArrayList<PostInitCallback>();
        }
        this.postInitCallbacks.add(callback);
    }

    @FunctionalInterface
    public static interface SubPartMappingProducer<T> {
        public T produceSubMapping(String var1, MappingModelCreationProcess var2);
    }

    @FunctionalInterface
    public static interface PostInitCallback {
        public boolean process();
    }
}

