/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.List;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupBuilder;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceCollector;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.internal.domain.collection.CollectionDomainResult;
import org.hibernate.sql.results.internal.domain.collection.DelayedCollectionFetch;
import org.hibernate.sql.results.internal.domain.collection.EagerCollectionFetch;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public class PluralAttributeMappingImpl
extends AbstractAttributeMapping
implements PluralAttributeMapping {
    private final int stateArrayPosition;
    private final PropertyAccess propertyAccess;
    private final StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess;
    private final ForeignKeyDescriptor fkDescriptor;
    private final CollectionPart elementDescriptor;
    private final CollectionPart indexDescriptor;
    private final CollectionIdentifierDescriptor identifierDescriptor;
    private final FetchStrategy fetchStrategy;
    private final CascadeStyle cascadeStyle;
    private final CollectionPersister collectionDescriptor;
    private final String separateCollectionTable;
    private final String sqlAliasStem;
    private final PluralAttributeMapping.IndexMetadata indexMetadata;

    public PluralAttributeMappingImpl(String attributeName, final Collection bootDescriptor, PropertyAccess propertyAccess, StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess, CollectionMappingType collectionMappingType, int stateArrayPosition, ForeignKeyDescriptor fkDescriptor, CollectionPart elementDescriptor, final CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchStrategy fetchStrategy, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor) {
        super(attributeName, collectionMappingType, declaringType);
        this.propertyAccess = propertyAccess;
        this.stateArrayContributorMetadataAccess = stateArrayContributorMetadataAccess;
        this.stateArrayPosition = stateArrayPosition;
        this.fkDescriptor = fkDescriptor;
        this.elementDescriptor = elementDescriptor;
        this.indexDescriptor = indexDescriptor;
        this.identifierDescriptor = identifierDescriptor;
        this.fetchStrategy = fetchStrategy;
        this.cascadeStyle = cascadeStyle;
        this.collectionDescriptor = collectionDescriptor;
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(attributeName);
        this.separateCollectionTable = bootDescriptor.isOneToMany() ? null : ((Joinable)((Object)collectionDescriptor)).getTableName();
        this.indexMetadata = new PluralAttributeMapping.IndexMetadata(){
            final int baseIndex;
            {
                this.baseIndex = bootDescriptor instanceof List ? ((List)bootDescriptor).getBaseIndex() : -1;
            }

            @Override
            public CollectionPart getIndexDescriptor() {
                return indexDescriptor;
            }

            @Override
            public int getListIndexBase() {
                return this.baseIndex;
            }
        };
        if (collectionDescriptor instanceof Aware) {
            ((Aware)((Object)collectionDescriptor)).injectAttributeMapping(this);
        }
    }

    @Override
    public CollectionMappingType getMappedTypeDescriptor() {
        return (CollectionMappingType)super.getMappedTypeDescriptor();
    }

    @Override
    public ForeignKeyDescriptor getKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionPart getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionPart getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public PluralAttributeMapping.IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public CollectionIdentifierDescriptor getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public String getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public StateArrayContributorMetadataAccess getAttributeMetadataAccess() {
        return this.stateArrayContributorMetadataAccess;
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getFetchableName() {
        return this.getAttributeName();
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        return new CollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        if (fetchTiming == FetchTiming.IMMEDIATE || selected) {
            TableGroup collectionTableGroup = sqlAstCreationState.getFromClauseAccess().resolveTableGroup(fetchablePath, p -> {
                TableGroup lhsTableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
                TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, JoinType.LEFT, lockMode, creationState.getSqlAliasBaseManager(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
                lhsTableGroup.addTableGroupJoin(tableGroupJoin);
                sqlAstCreationState.getFromClauseAccess().registerTableGroup(fetchablePath, tableGroupJoin.getJoinedGroup());
                return tableGroupJoin.getJoinedGroup();
            });
            return new EagerCollectionFetch(fetchablePath, this, this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), fetchParent, creationState);
        }
        return new DelayedCollectionFetch(fetchablePath, this, true, fetchParent);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, JoinType joinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String aliasRoot = explicitSourceAlias == null ? this.sqlAliasStem : explicitSourceAlias;
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(aliasRoot);
        TableGroupBuilder tableGroupBuilder = TableGroupBuilder.builder(navigablePath, this, lockMode, sqlAliasBase, creationContext.getSessionFactory());
        this.applyTableReferences(sqlAliasBase, joinType, tableGroupBuilder, sqlExpressionResolver, creationContext);
        TableGroup tableGroup = tableGroupBuilder.build();
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, joinType, tableGroup, this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, joinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public void applyTableReferences(SqlAliasBase sqlAliasBase, JoinType baseJoinType, TableReferenceCollector collector, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        this.getCollectionDescriptor().applyTableReferences(sqlAliasBase, baseJoinType, collector, sqlExpressionResolver, creationContext);
    }

    @Override
    public TableGroup createRootTableGroup(NavigablePath navigablePath, String explicitSourceAlias, JoinType tableReferenceJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationContext creationContext) {
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        TableGroupBuilder tableGroupBuilder = TableGroupBuilder.builder(navigablePath, this, lockMode, sqlAliasBase, creationContext.getSessionFactory());
        this.applyTableReferences(sqlAliasBase, tableReferenceJoinType, tableGroupBuilder, sqlExpressionResolver, creationContext);
        return tableGroupBuilder.build();
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFilters(influencers);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEntityGraph(influencers);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    public String getRootPathName() {
        return this.getCollectionDescriptor().getRole();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromName(name);
        if (nature == CollectionPart.Nature.ELEMENT) {
            return this.elementDescriptor;
        }
        if (nature == CollectionPart.Nature.INDEX) {
            return this.indexDescriptor;
        }
        if (nature == CollectionPart.Nature.ID) {
            return this.identifierDescriptor;
        }
        return null;
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.elementDescriptor);
        if (this.indexDescriptor != null) {
            consumer.accept(this.indexDescriptor);
        }
    }

    @Override
    public int getNumberOfFetchables() {
        return this.indexDescriptor == null ? 1 : 2;
    }

    public String toString() {
        return "PluralAttribute(" + this.getCollectionDescriptor().getRole() + ")";
    }

    public static interface Aware {
        public void injectAttributeMapping(PluralAttributeMapping var1);
    }
}

