/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart {
    private final String keyColumnContainingTable;
    private final String keyColumnExpression;
    private final String targetColumnContainingTable;
    private final String targetColumnExpression;
    private final JdbcMapping jdbcMapping;
    private final ForeignKeyDirection fKeyDirection;

    public SimpleForeignKeyDescriptor(ForeignKeyDirection fKeyDirection, String keyColumnContainingTable, String keyColumnExpression, String targetColumnContainingTable, String targetColumnExpression, JdbcMapping jdbcMapping) {
        this.fKeyDirection = fKeyDirection;
        this.keyColumnContainingTable = keyColumnContainingTable;
        this.keyColumnExpression = keyColumnExpression;
        this.targetColumnContainingTable = targetColumnContainingTable;
        this.targetColumnExpression = targetColumnExpression;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
        String identificationVariable = tableReference.getIdentificationVariable();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.keyColumnExpression), s -> new ColumnReference(identificationVariable, this.keyColumnExpression, this.jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.jdbcMapping.getJavaTypeDescriptor());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, JoinType joinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        if (lhs.getTableExpression().equals(this.keyColumnContainingTable)) {
            assert (rhs.getTableExpression().equals(this.targetColumnContainingTable));
            return new ComparisonPredicate(new ColumnReference(lhs, this.keyColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
        }
        assert (rhs.getTableExpression().equals(this.keyColumnContainingTable));
        return new ComparisonPredicate(new ColumnReference(lhs, this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.keyColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, JoinType joinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        ColumnReference targetColumnReference;
        TableReference keyTableReference = this.getTableReference(lhs, tableGroup, this.keyColumnContainingTable);
        ColumnReference keyColumnReference = new ColumnReference(keyTableReference, this.keyColumnExpression, this.jdbcMapping, creationContext.getSessionFactory());
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            TableReference targetTableKeyReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.targetColumnContainingTable);
            targetColumnReference = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(targetTableKeyReference, this.targetColumnExpression), s -> new ColumnReference(targetTableKeyReference.getIdentificationVariable(), this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
        } else {
            TableReference targetTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
            targetColumnReference = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(targetTableKeyReference, this.targetColumnExpression), s -> new ColumnReference(targetTableKeyReference.getIdentificationVariable(), this.targetColumnExpression, this.jdbcMapping, creationContext.getSessionFactory()));
        }
        if (this.fKeyDirection == ForeignKeyDirection.FROM_PARENT) {
            return new ComparisonPredicate(targetColumnReference, ComparisonOperator.EQUAL, keyColumnReference);
        }
        return new ComparisonPredicate(keyColumnReference, ComparisonOperator.EQUAL, targetColumnReference);
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.jdbcMapping.getJavaTypeDescriptor();
    }

    @Override
    public void visitReferringColumns(ColumnConsumer consumer) {
        consumer.accept(this.keyColumnContainingTable, this.keyColumnExpression, this.jdbcMapping);
    }

    @Override
    public void visitTargetColumns(ColumnConsumer consumer) {
        consumer.accept(this.targetColumnContainingTable, this.targetColumnExpression, this.jdbcMapping);
    }

    @Override
    public void visitColumnMappings(ForeignKeyDescriptor.FkColumnMappingConsumer consumer) {
        consumer.consume(this.keyColumnContainingTable, this.keyColumnExpression, this.targetColumnContainingTable, this.targetColumnExpression, this.jdbcMapping);
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        return Collections.singletonList(this.jdbcMapping);
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.jdbcMapping);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.jdbcMapping);
    }

    @Override
    public String getContainingTableExpression() {
        return this.keyColumnContainingTable;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.keyColumnExpression;
    }

    @Override
    public BasicValueConverter getConverter() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return FetchStrategy.IMMEDIATE_JOIN;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }
}

