/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupBuilder;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReferenceCollector;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.internal.domain.entity.DelayedEntityFetchImpl;
import org.hibernate.sql.results.internal.domain.entity.EntityFetch;
import org.hibernate.sql.results.internal.domain.entity.SelectEntityFetchImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public class SingularAssociationAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedModelPart,
TableGroupJoinProducer {
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean referringPrimaryKey;
    protected final boolean unwrapProxy;
    private final String referencedPropertyName;
    private ForeignKeyDescriptor foreignKeyDescriptor;

    public SingularAssociationAttributeMapping(String name, int stateArrayPosition, ToOne value, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, EntityMappingType type, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, type, declaringType, propertyAccess);
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = value.isNullable();
        this.referencedPropertyName = value.getReferencedPropertyName();
        this.referringPrimaryKey = value.isReferenceToPrimaryKey();
        this.unwrapProxy = value.isUnwrapProxy();
    }

    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        this.foreignKeyDescriptor = foreignKeyDescriptor;
    }

    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public EntityMappingType getMappedTypeDescriptor() {
        return (EntityMappingType)super.getMappedTypeDescriptor();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.getMappedTypeDescriptor();
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup lhsTableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        if (fetchTiming == FetchTiming.IMMEDIATE && selected) {
            if (sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchablePath) == null) {
                JoinType joinType = this.isNullable ? JoinType.LEFT : JoinType.INNER;
                TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, joinType, lockMode, creationState.getSqlAliasBaseManager(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
                lhsTableGroup.addTableGroupJoin(tableGroupJoin);
                sqlAstCreationState.getFromClauseAccess().registerTableGroup(fetchablePath, tableGroupJoin.getJoinedGroup());
            }
            return new EntityFetch(fetchParent, this, lockMode, true, fetchablePath, creationState);
        }
        DomainResult result = this.referringPrimaryKey ? this.foreignKeyDescriptor.createDomainResult(fetchablePath, lhsTableGroup, creationState) : ((EntityPersister)this.getDeclaringType()).getIdentifierMapping().createDomainResult(fetchablePath, lhsTableGroup, null, creationState);
        if (fetchTiming == FetchTiming.IMMEDIATE && !selected) {
            return new SelectEntityFetchImpl(fetchParent, this, lockMode, fetchablePath, result);
        }
        return new DelayedEntityFetchImpl(fetchParent, this, lockMode, this.isNullable, fetchablePath, result);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, JoinType joinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String aliasRoot = explicitSourceAlias == null ? this.sqlAliasStem : explicitSourceAlias;
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(aliasRoot);
        TableGroupBuilder tableGroupBuilder = TableGroupBuilder.builder(navigablePath, this, lockMode, sqlAliasBase, creationContext.getSessionFactory());
        this.applyTableReferences(sqlAliasBase, joinType, tableGroupBuilder, sqlExpressionResolver, creationContext);
        this.getMappedTypeDescriptor().getIdentifierMapping();
        TableGroup tableGroup = tableGroupBuilder.build();
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, joinType, tableGroup, null);
        lhs.addTableGroupJoin(tableGroupJoin);
        Predicate predicate = this.foreignKeyDescriptor.generateJoinPredicate(lhs, tableGroup, joinType, sqlExpressionResolver, creationContext);
        tableGroupJoin.applyPredicate(predicate);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public void applyTableReferences(SqlAliasBase sqlAliasBase, JoinType baseJoinType, TableReferenceCollector collector, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        this.getMappedTypeDescriptor().applyTableReferences(sqlAliasBase, baseJoinType, collector, sqlExpressionResolver, creationContext);
    }

    @Override
    public boolean isCircular(FetchParent fetchParent, SqlAstProcessingState creationState) {
        NavigablePath panentNaviblePath = fetchParent.getNavigablePath();
        NavigablePath parentParentNavigablePath = panentNaviblePath.getParent();
        if (parentParentNavigablePath == null) {
            return false;
        }
        if (this.getAttributeName().equals(parentParentNavigablePath.getLocalName())) {
            return true;
        }
        ModelPartContainer modelPart = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(parentParentNavigablePath).getModelPart();
        SingularAssociationAttributeMapping part = (SingularAssociationAttributeMapping)modelPart.findSubPart(panentNaviblePath.getLocalName(), null);
        if (panentNaviblePath.getLocalName().equals(this.referencedPropertyName) && part.getFetchableName().equals(this.referencedPropertyName)) {
            return true;
        }
        return part.getReferencedPropertyName() != null && part.getReferencedPropertyName().equals(this.getAttributeName());
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }
}

