/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.AbstractManagedType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractIdentifiableType<J>
extends AbstractManagedType<J>
implements IdentifiableDomainType<J>,
Serializable {
    private final boolean hasIdentifierProperty;
    private final boolean hasIdClass;
    private SingularPersistentAttribute<J, ?> id;
    private Set<SingularPersistentAttribute<? super J, ?>> idClassAttributes;
    private SqmPathSource identifierDescriptor;
    private final boolean isVersioned;
    private SingularPersistentAttribute<J, ?> versionAttribute;
    private static final Logger log = Logger.getLogger(AbstractIdentifiableType.class);

    public AbstractIdentifiableType(String typeName, JavaTypeDescriptor<J> javaTypeDescriptor, IdentifiableDomainType<? super J> superType, boolean hasIdClass, boolean hasIdentifierProperty, boolean versioned, JpaMetamodel jpaMetamodel) {
        super(typeName, javaTypeDescriptor, superType, jpaMetamodel);
        this.hasIdClass = hasIdClass;
        this.hasIdentifierProperty = hasIdentifierProperty;
        this.isVersioned = versioned;
    }

    protected InFlightAccessImpl createInFlightAccess() {
        return new InFlightAccessImpl(super.createInFlightAccess());
    }

    public InFlightAccessImpl getInFlightAccess() {
        return (InFlightAccessImpl)super.getInFlightAccess();
    }

    @Override
    public SqmPathSource getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public boolean hasIdClass() {
        return this.hasIdClass;
    }

    public boolean hasSingleIdAttribute() {
        return !this.hasIdClass() && this.hasIdentifierProperty;
    }

    @Override
    public IdentifiableDomainType<? super J> getSuperType() {
        return (IdentifiableDomainType)super.getSuperType();
    }

    @Override
    public IdentifiableDomainType<? super J> getSupertype() {
        return this.getSuperType();
    }

    @Override
    public <Y> SingularPersistentAttribute<? super J, Y> getId(Class<Y> javaType) {
        this.ensureNoIdClass();
        SingularPersistentAttribute id = this.findIdAttribute();
        if (id != null) {
            this.checkType(id, javaType);
        }
        return id;
    }

    private void ensureNoIdClass() {
        if (this.hasIdClass()) {
            throw new IllegalArgumentException("Illegal call to IdentifiableType#getId for class [" + this.getTypeName() + "] defined with @IdClass");
        }
    }

    @Override
    public SingularPersistentAttribute findIdAttribute() {
        SingularPersistentAttribute id;
        if (this.id != null) {
            return this.id;
        }
        if (this.getSuperType() != null && (id = this.getSuperType().findIdAttribute()) != null) {
            return id;
        }
        return null;
    }

    private void checkType(SingularPersistentAttribute attribute, Class javaType) {
        if (!javaType.isAssignableFrom(attribute.getType().getJavaType())) {
            throw new IllegalArgumentException(String.format("Attribute [%s#%s : %s] not castable to requested type [%s]", this.getTypeName(), attribute.getName(), attribute.getType().getJavaType().getName(), javaType.getName()));
        }
    }

    @Override
    public <Y> SingularPersistentAttribute<J, Y> getDeclaredId(Class<Y> javaType) {
        this.ensureNoIdClass();
        if (this.id == null) {
            throw new IllegalArgumentException("The id attribute is not declared on this type [" + this.getTypeName() + "]");
        }
        this.checkType(this.id, javaType);
        return this.id;
    }

    @Override
    public SimpleDomainType<?> getIdType() {
        SingularPersistentAttribute id = this.findIdAttribute();
        if (id != null) {
            return id.getType();
        }
        Set<SingularPersistentAttribute<J, ?>> idClassAttributes = this.getIdClassAttributesSafely();
        if (idClassAttributes != null && idClassAttributes.size() == 1) {
            return idClassAttributes.iterator().next().getType();
        }
        return null;
    }

    public Set<SingularPersistentAttribute<? super J, ?>> getIdClassAttributesSafely() {
        if (!this.hasIdClass()) {
            return null;
        }
        HashSet attributes = new HashSet();
        this.visitIdClassAttributes(attributes::add);
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    @Override
    public Set<SingularAttribute<? super J, ?>> getIdClassAttributes() {
        if (!this.hasIdClass()) {
            throw new IllegalArgumentException("This class [" + this.getJavaType() + "] does not define an IdClass");
        }
        HashSet attributes = new HashSet();
        this.visitIdClassAttributes(attributes::add);
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException("Unable to locate IdClass attributes [" + this.getJavaType() + "]");
        }
        return attributes;
    }

    @Override
    public void visitIdClassAttributes(Consumer<SingularPersistentAttribute<? super J, ?>> attributeConsumer) {
        if (this.idClassAttributes != null) {
            this.idClassAttributes.forEach(attributeConsumer);
        } else if (this.getSuperType() != null) {
            this.getSuperType().visitIdClassAttributes(attributeConsumer);
        }
    }

    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public boolean hasDeclaredVersionAttribute() {
        return this.isVersioned && this.versionAttribute != null;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super J, Y> getVersion(Class<Y> javaType) {
        if (!this.hasVersionAttribute()) {
            return null;
        }
        SingularPersistentAttribute version = this.findVersionAttribute();
        if (version != null) {
            this.checkType(version, javaType);
        }
        return version;
    }

    @Override
    public SingularPersistentAttribute findVersionAttribute() {
        if (this.versionAttribute != null) {
            return this.versionAttribute;
        }
        if (this.getSuperType() != null) {
            return this.getSuperType().findVersionAttribute();
        }
        return null;
    }

    @Override
    public <Y> SingularPersistentAttribute<J, Y> getDeclaredVersion(Class<Y> javaType) {
        this.checkDeclaredVersion();
        this.checkType(this.versionAttribute, javaType);
        return this.versionAttribute;
    }

    private void checkDeclaredVersion() {
        if (this.versionAttribute == null || this.getSuperType() != null && this.getSuperType().hasVersionAttribute()) {
            throw new IllegalArgumentException("The version attribute is not declared by this type [" + this.getJavaType() + "]");
        }
    }

    public SingularAttribute<J, ?> getDeclaredVersion() {
        this.checkDeclaredVersion();
        return this.versionAttribute;
    }

    private SqmPathSource interpretIdDescriptor() {
        log.tracef("Interpreting domain-model identifier descriptor", new Object[0]);
        if (this.getSuperType() != null) {
            return this.getSuperType().getIdentifierDescriptor();
        }
        if (this.id != null) {
            Type type = this.id.getType();
            if (type instanceof BasicDomainType) {
                return new BasicSqmPathSource("{id}", (BasicDomainType)type, Bindable.BindableType.SINGULAR_ATTRIBUTE);
            }
            assert (type instanceof EmbeddableDomainType);
            EmbeddableDomainType compositeType = (EmbeddableDomainType)type;
            return new EmbeddedSqmPathSource("{id}", compositeType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
        }
        if (this.idClassAttributes != null && !this.idClassAttributes.isEmpty()) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        throw new UnsupportedOperationException("Could not build SqmPathSource for entity identifier : " + this.getTypeName());
    }

    private class InFlightAccessImpl
    extends AbstractManagedType.InFlightAccessImpl {
        private final AttributeContainer.InFlightAccess managedTypeAccess;

        private InFlightAccessImpl(AttributeContainer.InFlightAccess managedTypeAccess) {
            this.managedTypeAccess = managedTypeAccess;
        }

        @Override
        public void applyIdAttribute(SingularPersistentAttribute idAttribute) {
            AbstractIdentifiableType.this.id = idAttribute;
            this.managedTypeAccess.addAttribute(idAttribute);
        }

        @Override
        public void applyIdClassAttributes(Set idClassAttributes) {
            for (SingularAttribute idClassAttribute : idClassAttributes) {
                if (AbstractIdentifiableType.this != idClassAttribute.getDeclaringType()) continue;
                SingularPersistentAttribute declaredAttribute = (SingularPersistentAttribute)idClassAttribute;
                this.addAttribute((PersistentAttribute)declaredAttribute);
            }
            AbstractIdentifiableType.this.idClassAttributes = idClassAttributes;
        }

        @Override
        public void applyVersionAttribute(SingularPersistentAttribute versionAttribute) {
            AbstractIdentifiableType.this.versionAttribute = versionAttribute;
            this.managedTypeAccess.addAttribute(versionAttribute);
        }

        @Override
        public void addAttribute(PersistentAttribute attribute) {
            this.managedTypeAccess.addAttribute(attribute);
        }

        @Override
        public void finishUp() {
            this.managedTypeAccess.finishUp();
            AbstractIdentifiableType.this.identifierDescriptor = AbstractIdentifiableType.this.interpretIdDescriptor();
        }
    }
}

