/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.persistence.EntityGraph;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedSubgraph;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.InflightRuntimeMetamodel;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class JpaMetamodelImpl
implements JpaMetamodel {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(JpaMetamodel.class);
    private static final String INVALID_IMPORT = "";
    private final TypeConfiguration typeConfiguration;
    private final Map<String, EntityDomainType<?>> jpaEntityTypeMap = new ConcurrentHashMap();
    private final Map<Class<?>, MappedSuperclassDomainType<?>> jpaMappedSuperclassTypeMap = new ConcurrentHashMap();
    private final Map<Class, EmbeddableDomainType<?>> jpaEmbeddableDescriptorMap = new ConcurrentHashMap();
    private final transient Map<String, RootGraphImplementor> entityGraphMap = new ConcurrentHashMap<String, RootGraphImplementor>();
    private final Map<Class, SqmPolymorphicRootDescriptor<?>> polymorphicEntityReferenceMap = new ConcurrentHashMap();
    private final Map<Class, String> entityProxyInterfaceMap = new ConcurrentHashMap<Class, String>();
    private final Map<String, String> nameToImportNameMap = new ConcurrentHashMap<String, String>();

    public JpaMetamodelImpl(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public <X> EntityDomainType<X> entity(String entityName) {
        return this.jpaEntityTypeMap.get(entityName);
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        EntityDomainType<X> entityDescriptor;
        String rename = this.resolveImportedName(entityName);
        if (rename != null) {
            entityName = rename;
        }
        if ((entityDescriptor = this.entity(entityName)) != null) {
            return entityDescriptor;
        }
        Class<X> requestedClass = this.resolveRequestedClass(entityName);
        if (requestedClass != null) {
            return this.resolveEntityReference(requestedClass);
        }
        throw new IllegalArgumentException("Could not resolve entity reference " + entityName);
    }

    @Override
    public void visitManagedTypes(Consumer<ManagedDomainType<?>> action) {
        this.visitEntityTypes(action);
        this.visitEmbeddables(action);
        this.jpaMappedSuperclassTypeMap.values().forEach(action);
    }

    @Override
    public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
        ManagedType type = this.jpaEntityTypeMap.get(cls);
        if (type == null) {
            type = this.jpaMappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.jpaEmbeddableDescriptorMap.get(cls);
        }
        if (type == null) {
            return null;
        }
        return (ManagedDomainType)type;
    }

    @Override
    public void visitEntityTypes(Consumer<EntityDomainType<?>> action) {
        this.jpaEntityTypeMap.values().forEach(action);
    }

    @Override
    public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
        EntityType entityType = this.jpaEntityTypeMap.get(cls);
        if (entityType == null) {
            return null;
        }
        return (EntityDomainType)entityType;
    }

    @Override
    public void visitRootEntityTypes(Consumer<EntityDomainType<?>> action) {
        this.jpaEntityTypeMap.values().forEach(entityDomainType -> {
            if (entityDomainType.getSuperType() == null) {
                action.accept((EntityDomainType<?>)entityDomainType);
            }
        });
    }

    @Override
    public void visitEmbeddables(Consumer<EmbeddableDomainType<?>> action) {
        this.jpaEmbeddableDescriptorMap.values().forEach(action);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        ManagedType type = this.jpaEntityTypeMap.get(cls);
        if (type == null) {
            type = this.jpaMappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.jpaEmbeddableDescriptorMap.get(cls);
        }
        if (type == null) {
            throw new IllegalArgumentException("Not a managed type: " + cls);
        }
        return (ManagedDomainType)type;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        EntityType entityType = this.jpaEntityTypeMap.get(cls.getName());
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls.getName());
        }
        return (EntityDomainType)entityType;
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        EmbeddableDomainType<?> embeddableType = this.jpaEmbeddableDescriptorMap.get(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an embeddable: " + cls);
        }
        return embeddableType;
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        int setSize = CollectionHelper.determineProperSizing(this.jpaEntityTypeMap.size() + this.jpaMappedSuperclassTypeMap.size() + this.jpaEmbeddableDescriptorMap.size());
        HashSet managedTypes = new HashSet(setSize);
        managedTypes.addAll(this.jpaEntityTypeMap.values());
        managedTypes.addAll(this.jpaMappedSuperclassTypeMap.values());
        managedTypes.addAll(this.jpaEmbeddableDescriptorMap.values());
        return managedTypes;
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.jpaEntityTypeMap.values());
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.jpaEmbeddableDescriptorMap.values());
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        EntityGraph old = this.entityGraphMap.put(graphName, entityGraph.makeImmutableCopy(graphName));
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", graphName);
        }
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.entityGraphMap.get(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        EntityType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity : " + entityClass.getName());
        }
        ArrayList<RootGraphImplementor<T>> results = new ArrayList<RootGraphImplementor<T>>();
        for (EntityGraph entityGraph : this.entityGraphMap.values()) {
            RootGraphImplementor egi;
            if (!(entityGraph instanceof RootGraphImplementor) || !(egi = (RootGraphImplementor)entityGraph).appliesTo(entityType)) continue;
            results.add(egi);
        }
        return results;
    }

    @Override
    public String qualifyImportableName(String queryName) {
        return this.resolveImportedName(queryName);
    }

    private String resolveImportedName(String name) {
        String result = this.nameToImportNameMap.get(name);
        if (result == null) {
            try {
                this.getServiceRegistry().getService(ClassLoaderService.class).classForName(name);
                this.nameToImportNameMap.put(name, name);
                return name;
            }
            catch (ClassLoadingException cnfe) {
                this.nameToImportNameMap.put(name, INVALID_IMPORT);
                return null;
            }
        }
        if (result == INVALID_IMPORT) {
            return null;
        }
        return result;
    }

    private void applyNamedEntityGraphs(Collection<NamedEntityGraphDefinition> namedEntityGraphs) {
        for (NamedEntityGraphDefinition definition : namedEntityGraphs) {
            log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s", definition.getRegisteredName(), definition.getEntityName(), definition.getJpaEntityName());
            EntityDomainType entityType = this.entity(definition.getEntityName());
            if (entityType == null) {
                throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
            }
            RootGraphImpl entityGraph = new RootGraphImpl(definition.getRegisteredName(), entityType, (JpaMetamodel)this);
            NamedEntityGraph namedEntityGraph = definition.getAnnotation();
            if (namedEntityGraph.includeAllAttributes()) {
                for (Object attributeObject : entityType.getAttributes()) {
                    entityGraph.addAttributeNodes(new Attribute[]{(Attribute)attributeObject});
                }
            }
            if (namedEntityGraph.attributeNodes() != null) {
                this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
            }
            this.entityGraphMap.put(definition.getRegisteredName(), entityGraph);
        }
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            SubGraph subgraph;
            String value = namedAttributeNode.value();
            AttributeNode attributeNode = graphNode.addAttributeNode(value);
            if (StringHelper.isNotEmpty(namedAttributeNode.subgraph())) {
                subgraph = attributeNode.makeSubGraph();
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), (SubGraphImplementor)subgraph);
            }
            if (!StringHelper.isNotEmpty(namedAttributeNode.keySubgraph())) continue;
            subgraph = attributeNode.makeKeySubGraph();
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), (SubGraphImplementor)subgraph);
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubGraphImplementor subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    private <X> Class<X> resolveRequestedClass(String entityName) {
        try {
            return this.getServiceRegistry().getService(ClassLoaderService.class).classForName(entityName);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public <T> EntityDomainType<T> resolveEntityReference(Class<T> javaType) {
        EntityDomainType<?> descriptor = this.jpaEntityTypeMap.get(javaType);
        if (descriptor != null) {
            return descriptor;
        }
        String proxyEntityName = this.entityProxyInterfaceMap.get(javaType);
        if (proxyEntityName != null) {
            return this.jpaEntityTypeMap.get(proxyEntityName);
        }
        if (this.polymorphicEntityReferenceMap.containsKey(javaType)) {
            return this.polymorphicEntityReferenceMap.get(javaType);
        }
        HashSet matchingDescriptors = new HashSet();
        this.visitEntityTypes(entityDomainType -> {
            if (javaType.isAssignableFrom(entityDomainType.getJavaType())) {
                matchingDescriptors.add((EntityDomainType<?>)entityDomainType);
            }
        });
        if (!matchingDescriptors.isEmpty()) {
            SqmPolymorphicRootDescriptor<T> descriptor2 = new SqmPolymorphicRootDescriptor<T>(this.typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(javaType), matchingDescriptors);
            this.polymorphicEntityReferenceMap.put(javaType, descriptor2);
            return descriptor2;
        }
        throw new IllegalArgumentException("Could not resolve entity reference : " + javaType.getName());
    }

    public static JpaMetamodel buildMetamodel(RuntimeModelCreationContext runtimeModelCreationContext, MetadataImplementor bootMetamodel, InflightRuntimeMetamodel inflightRuntimeMetamodel, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, Collection<NamedEntityGraphDefinition> namedEntityGraphDefinitions) {
        JpaMetamodelImpl jpaMetamodel = new JpaMetamodelImpl(inflightRuntimeMetamodel.getTypeConfiguration());
        jpaMetamodel.processJpa(bootMetamodel, inflightRuntimeMetamodel.getEntityProxyInterfaceMap(), jpaStaticMetaModelPopulationSetting, namedEntityGraphDefinitions, runtimeModelCreationContext);
        return jpaMetamodel;
    }

    public void processJpa(MetadataImplementor bootMetamodel, Map<Class, String> entityProxyInterfaceMap, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, Collection<NamedEntityGraphDefinition> namedEntityGraphDefinitions, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.nameToImportNameMap.putAll(bootMetamodel.getImports());
        this.entityProxyInterfaceMap.putAll(entityProxyInterfaceMap);
        if (jpaStaticMetaModelPopulationSetting != JpaStaticMetaModelPopulationSetting.DISABLED) {
            MetadataContext context = new MetadataContext(this, runtimeModelCreationContext, bootMetamodel.getMappedSuperclassMappingsCopy(), jpaStaticMetaModelPopulationSetting);
            for (PersistentClass persistentClass : bootMetamodel.getEntityBindings()) {
                this.locateOrBuildEntityType(persistentClass, context, this.typeConfiguration);
            }
            this.handleUnusedMappedSuperclasses(context, this.typeConfiguration);
            context.wrapUp();
            this.nameToImportNameMap.putAll(bootMetamodel.getImports());
            this.jpaEntityTypeMap.putAll(context.getEntityTypesByEntityName());
            this.jpaMappedSuperclassTypeMap.putAll(context.getMappedSuperclassTypeMap());
            for (EmbeddableDomainType embeddableDomainType : context.getEmbeddableTypeSet()) {
                this.jpaEmbeddableDescriptorMap.put(embeddableDomainType.getJavaType(), embeddableDomainType);
            }
        }
        this.applyNamedEntityGraphs(namedEntityGraphDefinitions);
    }

    private EntityDomainType<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        EntityDomainType<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = this.buildEntityType(persistentClass, context, typeConfiguration);
        }
        return entityType;
    }

    private EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> superType;
        Class javaType = persistentClass.getMappedClass();
        context.pushEntityWorkedOn(persistentClass);
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaTypeDescriptor javaTypeDescriptor = context.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        EntityTypeImpl entityType = new EntityTypeImpl(javaTypeDescriptor, superType, persistentClass, (JpaMetamodel)this);
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private void handleUnusedMappedSuperclasses(MetadataContext context, TypeConfiguration typeConfiguration) {
        Set<MappedSuperclass> unusedMappedSuperclasses = context.getUnusedMappedSuperclasses();
        if (!unusedMappedSuperclasses.isEmpty()) {
            for (MappedSuperclass mappedSuperclass : unusedMappedSuperclasses) {
                log.unusedMappedSuperclass(mappedSuperclass.getMappedClass().getName());
                this.locateOrBuildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
            }
        }
    }

    private MappedSuperclassDomainType<?> locateOrBuildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        if (mappedSuperclassType == null) {
            mappedSuperclassType = this.buildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
        }
        return mappedSuperclassType;
    }

    private MappedSuperclassTypeImpl<?> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaTypeDescriptor javaTypeDescriptor = context.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(mappedSuperclass.getMappedClass());
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaTypeDescriptor, mappedSuperclass, superType, (JpaMetamodel)this);
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }
}

