/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.internal.AttributeFactory;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.BagAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.ListAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MapAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.SetAttributeImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class PluralAttributeBuilder<D, C, E, K> {
    private final JavaTypeDescriptor<C> collectionJtd;
    private final AttributeClassification attributeClassification;
    private final CollectionClassification collectionClassification;
    private final SimpleDomainType<E> elementType;
    private final SimpleDomainType<K> listIndexOrMapKeyType;
    private final ManagedDomainType<D> declaringType;
    private final Property property;
    private final Member member;

    public PluralAttributeBuilder(JavaTypeDescriptor<C> collectionJtd, AttributeClassification attributeClassification, CollectionClassification collectionClassification, SimpleDomainType<E> elementType, SimpleDomainType<K> listIndexOrMapKeyType, ManagedDomainType<D> declaringType, Property property, Member member) {
        this.collectionJtd = collectionJtd;
        this.attributeClassification = attributeClassification;
        this.collectionClassification = collectionClassification;
        this.elementType = elementType;
        this.listIndexOrMapKeyType = listIndexOrMapKeyType;
        this.declaringType = declaringType;
        this.property = property;
        this.member = member;
    }

    public static <Y, X> PersistentAttribute<X, Y> build(PluralAttributeMetadata<?, Y, ?> attributeMetadata, MetadataContext metadataContext) {
        JavaTypeDescriptor attributeJtd = metadataContext.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(attributeMetadata.getJavaType());
        PluralAttributeBuilder builder = new PluralAttributeBuilder(attributeJtd, attributeMetadata.getAttributeClassification(), attributeMetadata.getCollectionClassification(), AttributeFactory.determineSimpleType(attributeMetadata.getElementValueContext(), metadataContext), PluralAttributeBuilder.determineListIndexOrMapKeyType(attributeMetadata, metadataContext), attributeMetadata.getOwnerType(), attributeMetadata.getPropertyMapping(), attributeMetadata.getMember());
        if (Map.class.equals(attributeJtd.getJavaType())) {
            return new MapAttributeImpl(builder, metadataContext);
        }
        if (Set.class.equals(attributeJtd.getJavaType())) {
            return new SetAttributeImpl(builder, metadataContext);
        }
        if (List.class.equals(attributeJtd.getJavaType())) {
            return new ListAttributeImpl(builder, metadataContext);
        }
        if (Collection.class.equals(attributeJtd.getJavaType())) {
            return new BagAttributeImpl(builder, metadataContext);
        }
        if (attributeJtd.getJavaType().isArray()) {
            return new ListAttributeImpl(builder, metadataContext);
        }
        if (Map.class.isAssignableFrom(attributeJtd.getJavaType())) {
            return new MapAttributeImpl(builder, metadataContext);
        }
        if (Set.class.isAssignableFrom(attributeJtd.getJavaType())) {
            return new SetAttributeImpl(builder, metadataContext);
        }
        if (List.class.isAssignableFrom(attributeJtd.getJavaType())) {
            return new ListAttributeImpl(builder, metadataContext);
        }
        if (Collection.class.isAssignableFrom(attributeJtd.getJavaType())) {
            return new BagAttributeImpl(builder, metadataContext);
        }
        throw new UnsupportedOperationException("Unknown collection: " + attributeJtd.getJavaType());
    }

    private static SimpleDomainType<?> determineListIndexOrMapKeyType(PluralAttributeMetadata<?, ?, ?> attributeMetadata, MetadataContext metadataContext) {
        if (Map.class.isAssignableFrom(attributeMetadata.getJavaType())) {
            return AttributeFactory.determineSimpleType(attributeMetadata.getMapKeyValueContext(), metadataContext);
        }
        if (List.class.isAssignableFrom(attributeMetadata.getJavaType())) {
            return metadataContext.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(Integer.class);
        }
        return null;
    }

    public ManagedDomainType<D> getDeclaringType() {
        return this.declaringType;
    }

    public AttributeClassification getAttributeClassification() {
        return this.attributeClassification;
    }

    public CollectionClassification getCollectionClassification() {
        return this.collectionClassification;
    }

    public SimpleDomainType<K> getListIndexOrMapKeyType() {
        return this.listIndexOrMapKeyType;
    }

    public JavaTypeDescriptor<C> getCollectionJavaTypeDescriptor() {
        return this.collectionJtd;
    }

    public SimpleDomainType<E> getValueType() {
        return this.elementType;
    }

    public Property getProperty() {
        return this.property;
    }

    public Member getMember() {
        return this.member;
    }
}

