/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.internal.AbstractProducedQuery;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(NamedQueryLoader.class);
    private final String queryName;
    private final EntityPersister persister;
    private final int position;

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
        this.position = 1;
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        if (lockOptions != null) {
            LOG.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(id, optionalObject, session);
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        LOG.debugf("Loading entity: %s using named query: %s", this.persister.getEntityName(), this.queryName);
        AbstractProducedQuery query = (AbstractProducedQuery)session.getNamedQuery(this.queryName);
        if (query.getParameterMetadata().hasNamedParameters()) {
            query.setParameter(query.getParameterMetadata().getNamedParameterNames().iterator().next(), (Object)id, (AllowableParameterType)((Object)this.persister.getIdentifierType()));
        } else {
            query.setParameter(this.position, (Object)id, (AllowableParameterType)((Object)this.persister.getIdentifierType()));
        }
        query.setOptionalId(id);
        query.setOptionalEntityName(this.persister.getEntityName());
        query.setOptionalObject(optionalObject);
        query.setHibernateFlushMode(FlushMode.MANUAL);
        query.list();
        return session.getPersistenceContextInternal().getEntity(session.generateEntityKey(id, this.persister));
    }
}

