/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.util.function.Consumer;
import javax.persistence.ParameterMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.ProcedureParamBindings;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.sql.exec.spi.JdbcCall;

public class StandardCallableStatementSupport
implements CallableStatementSupport {
    public static final StandardCallableStatementSupport NO_REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(false);
    public static final StandardCallableStatementSupport REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(true);
    private final boolean supportsRefCursors;

    public StandardCallableStatementSupport(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
    }

    @Override
    public JdbcCall interpretCall(String procedureName, FunctionReturnImpl functionReturn, ParameterMetadataImplementor parameterMetadata, ProcedureParamBindings paramBindings, final SharedSessionContractImplementor session) {
        final StringBuilder buffer = new StringBuilder().append("{call ").append(procedureName).append("(");
        parameterMetadata.visitParameters(new Consumer<QueryParameterImplementor<?>>(){
            String sep = "";

            @Override
            public void accept(QueryParameterImplementor<?> param) {
                if (param == null) {
                    throw new QueryException("Parameter registrations had gaps");
                }
                ProcedureParameterImplementor parameter = (ProcedureParameterImplementor)param;
                if (parameter.getMode() != ParameterMode.REF_CURSOR) {
                    throw new NotYetImplementedFor6Exception(this.getClass());
                }
                StandardCallableStatementSupport.this.verifyRefCursorSupport(session.getJdbcServices().getJdbcEnvironment().getDialect());
                buffer.append(this.sep).append("?");
                this.sep = ",";
            }
        });
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    private void verifyRefCursorSupport(Dialect dialect) {
        if (!this.supportsRefCursors) {
            throw new QueryException("Dialect [" + dialect.getClass().getName() + "] not known to support REF_CURSOR parameters");
        }
    }

    @Override
    public void registerParameters(String procedureName, CallableStatement statement, ParameterStrategy parameterStrategy, ParameterMetadataImplementor parameterMetadata, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

