/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.ResultSetMapping;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.jboss.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    private Util() {
    }

    public static void resolveResultSetMappings(String[] resultSetMappingNames, Class[] resultSetMappingClasses, Consumer<DomainResultProducer> resultProducerConsumer, Consumer<String> querySpaceConsumer, SessionFactoryImplementor sessionFactory) {
        if (!ArrayHelper.isEmpty(resultSetMappingNames)) {
            if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
                throw new IllegalArgumentException("Cannot specify both result-set mapping names and classes");
            }
            Util.resolveResultSetMappingNames(resultSetMappingNames, resultProducerConsumer, querySpaceConsumer, sessionFactory);
        } else if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
            Util.resolveResultSetMappingClasses(resultSetMappingClasses, resultProducerConsumer, querySpaceConsumer, sessionFactory);
        }
    }

    public static void resolveResultSetMappingNames(String[] resultSetMappingNames, Consumer<DomainResultProducer> resultProducerConsumer, Consumer<String> querySpaceConsumer, SessionFactoryImplementor sessionFactory) {
        NamedQueryRepository namedQueryRepository = sessionFactory.getQueryEngine().getNamedQueryRepository();
        for (String resultSetMappingName : resultSetMappingNames) {
            NamedResultSetMappingMemento memento = namedQueryRepository.getResultSetMappingMemento(resultSetMappingName);
            ResultSetMapping resultSetMapping = memento.toResultSetMapping();
            resultProducerConsumer.accept(resultSetMapping);
        }
    }

    public static void resolveResultSetMappingClasses(Class[] resultSetMappingClasses, Consumer<DomainResultProducer> resultProducerConsumer, Consumer<String> querySpaceConsumer, SessionFactoryImplementor sessionFactory) {
        throw new NotYetImplementedFor6Exception(Util.class);
    }
}

