/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Objects;
import org.hibernate.DotIdentifierSequence;
import org.hibernate.internal.util.StringHelper;

public class NavigablePath
implements DotIdentifierSequence {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigablePath parent;
    private final String fullPath;
    private final int hashCode;

    public NavigablePath(NavigablePath parent, String navigableName) {
        String parentFullPath;
        this.parent = parent;
        this.fullPath = IDENTIFIER_MAPPER_PROPERTY.equals(navigableName) ? (parent != null ? parent.getFullPath() : "") : (parent != null ? (StringHelper.isEmpty(parentFullPath = parent.getFullPath()) ? navigableName : parentFullPath + "." + navigableName) : navigableName);
        this.hashCode = this.fullPath.hashCode();
    }

    public NavigablePath(String localName) {
        this(localName, null);
    }

    public NavigablePath(String rootName, String alias) {
        this.parent = null;
        this.fullPath = alias == null ? rootName : rootName + "(" + alias + ")";
        this.hashCode = this.fullPath.hashCode();
    }

    public NavigablePath() {
        this("");
    }

    @Override
    public NavigablePath append(String property) {
        return new NavigablePath(this, property);
    }

    public NavigablePath append(String property, String alias) {
        return new NavigablePath(this, property);
    }

    @Override
    public NavigablePath getParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.parent == null ? this.fullPath : StringHelper.unqualify(this.fullPath);
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fullPath + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigablePath other = (NavigablePath)o;
        return Objects.equals(this.getFullPath(), other.getFullPath());
    }
}

