/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.lang.reflect.Field;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.jboss.logging.Logger;

public class BasicDotIdentifierConsumer
implements DotIdentifierConsumer {
    private static final Logger log = Logger.getLogger(BasicDotIdentifierConsumer.class);
    private final SqmCreationState creationState;
    private String pathSoFar;
    private SemanticPathPart currentPart;

    public BasicDotIdentifierConsumer(SqmCreationState creationState) {
        this.creationState = creationState;
    }

    public BasicDotIdentifierConsumer(SemanticPathPart initialState, SqmCreationState creationState) {
        this.currentPart = initialState;
        this.creationState = creationState;
    }

    protected SqmCreationState getCreationState() {
        return this.creationState;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.currentPart;
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        this.pathSoFar = this.pathSoFar == null ? identifier : this.pathSoFar + '.' + identifier;
        log.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, isBase, isTerminal, this.pathSoFar});
        this.currentPart = this.currentPart.resolvePathPart(identifier, isTerminal, this.creationState);
    }

    protected void reset() {
        this.pathSoFar = null;
        this.currentPart = this.createBasePart();
    }

    protected SemanticPathPart createBasePart() {
        return new BaseLocalSequencePart();
    }

    public class BaseLocalSequencePart
    implements SemanticPathPart {
        private boolean isBase = true;

        @Override
        public SemanticPathPart resolvePathPart(String identifier, boolean isTerminal, SqmCreationState creationState) {
            block13: {
                if (this.isBase) {
                    this.isBase = false;
                    SqmPathRegistry sqmPathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
                    SqmFrom pathRootByAlias = sqmPathRegistry.findFromByAlias(identifier);
                    if (pathRootByAlias != null) {
                        this.validateAsRoot(pathRootByAlias);
                        if (isTerminal) {
                            return pathRootByAlias;
                        }
                        return new DomainPathPart(pathRootByAlias);
                    }
                    SqmFrom pathRootByExposedNavigable = sqmPathRegistry.findFromExposing(identifier);
                    if (pathRootByExposedNavigable != null) {
                        this.validateAsRoot(pathRootByExposedNavigable);
                        SqmPathSource<?> subPathSource = pathRootByExposedNavigable.getReferencedPathSource().findSubPathSource(identifier);
                        SqmPath<?> sqmPath = subPathSource.createSqmPath(pathRootByExposedNavigable, creationState);
                        if (isTerminal) {
                            return sqmPath;
                        }
                        pathRootByExposedNavigable.registerImplicitJoinPath(sqmPath);
                        return new DomainPathPart(pathRootByAlias);
                    }
                }
                if (!isTerminal) {
                    return this;
                }
                int splitPosition = BasicDotIdentifierConsumer.this.pathSoFar.lastIndexOf(46);
                if (splitPosition > 0) {
                    String prefix = BasicDotIdentifierConsumer.this.pathSoFar.substring(0, splitPosition);
                    String terminal = BasicDotIdentifierConsumer.this.pathSoFar.substring(splitPosition + 1);
                    try {
                        SqmCreationContext creationContext = creationState.getCreationContext();
                        Class namedClass = creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(prefix);
                        if (namedClass == null) break block13;
                        JavaTypeDescriptorRegistry javaTypeDescriptorRegistry = creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry();
                        try {
                            Field referencedField = namedClass.getDeclaredField(terminal);
                            if (referencedField != null) {
                                JavaTypeDescriptor<?> fieldJtd = javaTypeDescriptorRegistry.getDescriptor(referencedField.getType());
                                return new SqmFieldLiteral(referencedField, fieldJtd, creationContext.getNodeBuilder());
                            }
                        }
                        catch (Exception referencedField) {
                            // empty catch block
                        }
                        if (namedClass.isEnum()) {
                            Object referencedEnum = Enum.valueOf(namedClass, terminal);
                            return new SqmEnumLiteral((Enum)referencedEnum, (EnumJavaTypeDescriptor)javaTypeDescriptorRegistry.resolveDescriptor(namedClass), terminal, creationContext.getNodeBuilder());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            throw new ParsingException("Could not interpret dot-ident : " + BasicDotIdentifierConsumer.this.pathSoFar);
        }

        protected void validateAsRoot(SqmFrom pathRoot) {
        }

        @Override
        public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState processingState) {
            return BasicDotIdentifierConsumer.this.currentPart.resolveIndexedAccess(selector, isTerminal, processingState);
        }
    }
}

