/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.SortOrder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.HqlLogger;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.HqlParser;
import org.hibernate.query.hql.internal.HqlParserBaseVisitor;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.SqmCastTarget;
import org.hibernate.query.sqm.function.SqmDistinct;
import org.hibernate.query.sqm.function.SqmExtractUnit;
import org.hibernate.query.sqm.function.SqmStar;
import org.hibernate.query.sqm.function.SqmTrimSpecification;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.NamedSqmFunctionTemplate;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.LiteralHelper;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.DowncastLocation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder
extends HqlParserBaseVisitor
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<TreatHandler> treatHandlerStack = new StandardStack<TreatHandlerNormal>(new TreatHandlerNormal());
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private ParameterCollector parameterCollector;
    private JavaTypeDescriptor<List> listJavaTypeDescriptor;
    private JavaTypeDescriptor<Map> mapJavaTypeDescriptor;

    public static SqmStatement buildSemanticModel(HqlParser.StatementContext hqlParseTree, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder(creationOptions, creationContext).visitStatement(hqlParseTree);
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    public SemanticQueryBuilder(SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    protected Stack<ParameterDeclarationContext> getParameterDeclarationContextStack() {
        return this.parameterDeclarationContextStack;
    }

    @Override
    public SqmStatement visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            if (ctx.selectStatement() != null) {
                SqmSelectStatement sqmSelectStatement = this.visitSelectStatement(ctx.selectStatement());
                return sqmSelectStatement;
            }
            if (ctx.insertStatement() != null) {
                SqmInsertSelectStatement sqmInsertSelectStatement = this.visitInsertStatement(ctx.insertStatement());
                return sqmInsertSelectStatement;
            }
            if (ctx.updateStatement() != null) {
                SqmUpdateStatement sqmUpdateStatement = this.visitUpdateStatement(ctx.updateStatement());
                return sqmUpdateStatement;
            }
            if (ctx.deleteStatement() != null) {
                SqmDeleteStatement sqmDeleteStatement = this.visitDeleteStatement(ctx.deleteStatement());
                return sqmDeleteStatement;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    @Override
    public SqmSelectStatement visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        if (this.creationOptions.useStrictJpaCompliance() && ctx.querySpec().selectClause() == null) {
            throw new StrictJpaComplianceViolation("Encountered implicit select-clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
        }
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            selectStatement.setQuerySpec(this.visitQuerySpec(ctx.querySpec()));
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertSelectStatement visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertSelectStatement insertStatement;
        Object targetType = this.visitEntityName(ctx.insertSpec().intoSpec().entityName());
        SqmRoot root = new SqmRoot(targetType, null, this.creationContext.getNodeBuilder());
        this.processingStateStack.getCurrent().getPathRegistry().register(root);
        this.parameterCollector = insertStatement = new SqmInsertSelectStatement(root, (NodeBuilder)this.creationContext.getQueryEngine().getCriteriaBuilder());
        this.processingStateStack.push(new SqmDmlCreationProcessingState(insertStatement, this));
        try {
            insertStatement.setSelectQuerySpec(this.visitQuerySpec(ctx.querySpec()));
            for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : ctx.insertSpec().targetFieldsSpec().dotIdentifierSequence()) {
                SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement;
            return sqmInsertSelectStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        SqmRoot root = new SqmRoot(this.visitEntityName(ctx.entityName()), this.visitIdentificationVariableDef(ctx.identificationVariableDef()), this.creationContext.getNodeBuilder());
        this.parameterCollector = updateStatement = new SqmUpdateStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register(root);
        try {
            for (HqlParser.AssignmentContext assignmentContext : ctx.setClause().assignment()) {
                updateStatement.applyAssignment(this.consumeDomainPath(assignmentContext.dotIdentifierSequence()), (SqmExpression)assignmentContext.expression().accept(this));
            }
            updateStatement.applyPredicate(this.visitWhereClause(ctx.whereClause()));
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        SqmRoot root = new SqmRoot(this.visitEntityName(ctx.entityName()), this.visitIdentificationVariableDef(ctx.identificationVariableDef()), this.creationContext.getNodeBuilder());
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(root, SqmQuerySource.HQL, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        sqmDeleteCreationState.getPathRegistry().register(root);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            if (ctx.whereClause() != null && ctx.whereClause().predicate() != null) {
                deleteStatement.applyPredicate((SqmPredicate)ctx.whereClause().predicate().accept(this));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQuerySpec visitQuerySpec(HqlParser.QuerySpecContext ctx) {
        SqmOrderByClause orderByClause;
        SqmSelectClause selectClause;
        SqmQuerySpec sqmQuerySpec = new SqmQuerySpec(this.creationContext.getNodeBuilder());
        this.treatHandlerStack.push(new TreatHandlerFromClause());
        try {
            sqmQuerySpec.setFromClause(this.visitFromClause(ctx.fromClause()));
        }
        finally {
            this.treatHandlerStack.pop();
        }
        if (ctx.selectClause() != null) {
            selectClause = this.visitSelectClause(ctx.selectClause());
        } else {
            log.debugf("Encountered implicit select clause : " + ctx.getText(), new Object[0]);
            selectClause = this.buildInferredSelectClause(sqmQuerySpec.getFromClause());
        }
        sqmQuerySpec.setSelectClause(selectClause);
        SqmWhereClause whereClause = new SqmWhereClause(this.creationContext.getNodeBuilder());
        if (ctx.whereClause() != null) {
            this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.WHERE));
            try {
                whereClause.setPredicate((SqmPredicate)ctx.whereClause().accept(this));
            }
            finally {
                this.treatHandlerStack.pop();
            }
        }
        sqmQuerySpec.setWhereClause(whereClause);
        if (ctx.orderByClause() != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            orderByClause = this.visitOrderByClause(ctx.orderByClause());
        } else {
            orderByClause = new SqmOrderByClause();
        }
        sqmQuerySpec.setOrderByClause(orderByClause);
        if (ctx.limitClause() != null || ctx.offsetClause() != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
            }
            if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                throw new SemanticException("limit and offset clause require an order-by clause when used in sub-query");
            }
            sqmQuerySpec.setOffsetExpression(this.visitOffsetClause(ctx.offsetClause()));
            sqmQuerySpec.setLimitExpression(this.visitLimitClause(ctx.limitClause()));
        }
        return sqmQuerySpec;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        SqmSelectClause selectClause = new SqmSelectClause(false, fromClause.getNumberOfRoots(), this.creationContext.getNodeBuilder());
        fromClause.visitRoots(sqmRoot -> selectClause.addSelection(new SqmSelection(sqmRoot, sqmRoot.getExplicitAlias(), this.creationContext.getNodeBuilder())));
        return selectClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.SELECT));
        try {
            SqmSelectClause selectClause = new SqmSelectClause(ctx.DISTINCT() != null, this.creationContext.getNodeBuilder());
            for (HqlParser.SelectionContext selectionContext : ctx.selectionList().selection()) {
                selectClause.addSelection(this.visitSelection(selectionContext));
            }
            SqmSelectClause sqmSelectClause = selectClause;
            return sqmSelectClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmSelection visitSelection(HqlParser.SelectionContext ctx) {
        String resultIdentifier = this.visitResultIdentifier(ctx.resultIdentifier());
        SqmSelectableNode selectableNode = this.visitSelectableNode(ctx);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.creationContext.getNodeBuilder());
        this.getProcessingStateStack().getCurrent().getPathRegistry().register(selection);
        return selection;
    }

    private SqmSelectableNode visitSelectableNode(HqlParser.SelectionContext ctx) {
        if (ctx.selectExpression().dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.selectExpression().dynamicInstantiation());
        }
        if (ctx.selectExpression().jpaSelectObjectSyntax() != null) {
            return this.visitJpaSelectObjectSyntax(ctx.selectExpression().jpaSelectObjectSyntax());
        }
        if (ctx.selectExpression().mapEntrySelection() != null) {
            return this.visitMapEntrySelection(ctx.selectExpression().mapEntrySelection());
        }
        if (ctx.selectExpression().expression() != null) {
            return (SqmExpression)ctx.selectExpression().expression().accept(this);
        }
        throw new ParsingException("Unexpected selection rule type : " + ctx.getText());
    }

    @Override
    public String visitResultIdentifier(HqlParser.ResultIdentifierContext resultIdentifierContext) {
        if (resultIdentifierContext != null) {
            if (resultIdentifierContext.AS() != null) {
                Token aliasToken = resultIdentifierContext.identifier().getStart();
                String explicitAlias = aliasToken.getText();
                if (aliasToken.getType() != 169 && this.creationOptions.useStrictJpaCompliance()) {
                    throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), explicitAlias), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
                }
                return explicitAlias;
            }
            return resultIdentifierContext.getText();
        }
        return null;
    }

    @Override
    public SqmDynamicInstantiation visitDynamicInstantiation(HqlParser.DynamicInstantiationContext ctx) {
        SqmDynamicInstantiation dynamicInstantiation;
        if (ctx.dynamicInstantiationTarget().MAP() != null) {
            if (this.mapJavaTypeDescriptor == null) {
                this.mapJavaTypeDescriptor = this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Map.class);
            }
            dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaTypeDescriptor, this.creationContext.getNodeBuilder());
        } else if (ctx.dynamicInstantiationTarget().LIST() != null) {
            if (this.listJavaTypeDescriptor == null) {
                this.listJavaTypeDescriptor = this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(List.class);
            }
            dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaTypeDescriptor, this.creationContext.getNodeBuilder());
        } else {
            String className = ctx.dynamicInstantiationTarget().dotIdentifierSequence().getText();
            try {
                JavaTypeDescriptor jtd = this.resolveInstantiationTargetJtd(className);
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(jtd, this.creationContext.getNodeBuilder());
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Unable to resolve class named for dynamic instantiation : " + className);
            }
        }
        for (HqlParser.DynamicInstantiationArgContext arg : ctx.dynamicInstantiationArgs().dynamicInstantiationArg()) {
            dynamicInstantiation.addArgument(this.visitDynamicInstantiationArg(arg));
        }
        return dynamicInstantiation;
    }

    private JavaTypeDescriptor resolveInstantiationTargetJtd(String className) {
        Class targetJavaType = this.classForName(this.creationContext.getJpaMetamodel().qualifyImportableName(className));
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(targetJavaType);
    }

    private Class classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument visitDynamicInstantiationArg(HqlParser.DynamicInstantiationArgContext ctx) {
        return new SqmDynamicInstantiationArgument(this.visitDynamicInstantiationArgExpression(ctx.dynamicInstantiationArgExpression()), ctx.identifier() == null ? null : ctx.identifier().getText(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmSelectableNode visitDynamicInstantiationArgExpression(HqlParser.DynamicInstantiationArgExpressionContext ctx) {
        if (ctx.dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.dynamicInstantiation());
        }
        if (ctx.expression() != null) {
            return (SqmExpression)ctx.expression().accept(this);
        }
        throw new ParsingException("Unexpected dynamic-instantiation-argument rule type : " + ctx.getText());
    }

    @Override
    public SqmPath visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Unable to resolve alias [" + alias + "] in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public Object visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        return super.visitGroupByClause(ctx);
    }

    @Override
    public Object visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return super.visitHavingClause(ctx);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        SqmOrderByClause orderByClause = new SqmOrderByClause();
        for (HqlParser.SortSpecificationContext sortSpecificationContext : ctx.sortSpecification()) {
            orderByClause.addSortSpecification(this.visitSortSpecification(sortSpecificationContext));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        SortOrder sortOrder;
        SqmExpression sortExpression = this.visitSortExpression(ctx.sortExpression());
        if (sortExpression == null) {
            throw new ParsingException("Could not resolve sort-expression : " + ctx.sortExpression().getText());
        }
        if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
            HqlLogger.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
        }
        String collation = ctx.collationSpecification() != null && ctx.collationSpecification().collateName() != null ? ctx.collationSpecification().collateName().dotIdentifierSequence().getText() : null;
        if (ctx.orderingSpecification() != null) {
            String ordering = ctx.orderingSpecification().getText();
            try {
                sortOrder = this.interpretSortOrder(ordering);
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException("Unrecognized sort ordering: " + ordering, e);
            }
        } else {
            sortOrder = null;
        }
        NullPrecedence nullPrecedence = null;
        return new SqmSortSpecification(sortExpression, collation, sortOrder, nullPrecedence);
    }

    @Override
    public SqmExpression visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            SqmSelectableNode selectableNode;
            int position = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByPosition(position);
            if (selection != null && (selectableNode = selection.getSelectableNode()) instanceof SqmExpression) {
                return (SqmExpression)selectableNode;
            }
            return new SqmLiteral<Integer>(position, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        if (ctx.identifier() != null) {
            SqmSelectableNode selectableNode;
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByAlias(ctx.identifier().getText());
            if (selection != null && (selectableNode = selection.getSelectableNode()) instanceof SqmExpression) {
                return (SqmExpression)selectableNode;
            }
            SqmFrom sqmFrom = this.getCurrentProcessingState().getPathRegistry().findFromByAlias(ctx.identifier().getText());
            if (sqmFrom != null) {
                return sqmFrom;
            }
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(ctx.getText(), true, true);
            return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
        }
        return (SqmExpression)ctx.expression().accept(this);
    }

    @Override
    public SqmExpression visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrNumberLiteral().accept(this);
    }

    @Override
    public SqmExpression visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrNumberLiteral().accept(this);
    }

    @Override
    public Object visitPathExpression(HqlParser.PathExpressionContext ctx) {
        return ctx.path().accept(this);
    }

    @Override
    public SqmExpression visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        return null;
    }

    private SortOrder interpretSortOrder(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("ascending") || value.equalsIgnoreCase("asc")) {
            return SortOrder.ASCENDING;
        }
        if (value.equalsIgnoreCase("descending") || value.equalsIgnoreCase("desc")) {
            return SortOrder.DESCENDING;
        }
        throw new SemanticException("Unknown sort order : " + value);
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = parserEntityName.fullNameText;
        EntityDomainType entityReference = this.resolveEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve entity name [" + entityName + "] as DML target", entityName);
        }
        return entityReference;
    }

    private EntityDomainType resolveEntityReference(String entityName) {
        log.debugf("Attempting to resolve path [%s] as entity reference...", (Object)entityName);
        EntityDomainType reference = null;
        try {
            entityName = this.creationContext.getJpaMetamodel().qualifyImportableName(entityName);
            reference = this.creationContext.getJpaMetamodel().entity(entityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        this.treatHandlerStack.push(new TreatHandlerFromClause());
        try {
            SqmFromClause fromClause = new SqmFromClause(parserFromClause.fromClauseSpace().size());
            for (HqlParser.FromClauseSpaceContext parserSpace : parserFromClause.fromClauseSpace()) {
                SqmRoot sqmPathRoot = this.visitFromClauseSpace(parserSpace);
                fromClause.addRoot(sqmPathRoot);
            }
            SqmFromClause sqmFromClause = fromClause;
            return sqmFromClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmRoot visitFromClauseSpace(HqlParser.FromClauseSpaceContext parserSpace) {
        SqmRoot sqmRoot = this.visitPathRoot(parserSpace.pathRoot());
        for (HqlParser.CrossJoinContext crossJoinContext : parserSpace.crossJoin()) {
            this.consumeCrossJoin(crossJoinContext, sqmRoot);
        }
        for (HqlParser.QualifiedJoinContext qualifiedJoinContext : parserSpace.qualifiedJoin()) {
            this.consumeQualifiedJoin(qualifiedJoinContext, sqmRoot);
        }
        for (HqlParser.JpaCollectionJoinContext jpaCollectionJoinContext : parserSpace.jpaCollectionJoin()) {
            this.consumeJpaCollectionJoin(jpaCollectionJoinContext, sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot visitPathRoot(HqlParser.PathRootContext ctx) {
        String name = ctx.entityName().fullNameText;
        log.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Illegal implicit-polymorphic domain path in sub-query : " + entityDescriptor.getName());
            }
        }
        String alias = this.visitIdentificationVariableDef(ctx.identificationVariableDef());
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, this.creationContext.getNodeBuilder());
        this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitIdentificationVariableDef(HqlParser.IdentificationVariableDefContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.AS() != null && ctx.identifier() != null) {
            Token identificationVariableToken;
            if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken = ctx.identifier().getStart()).getType() != 169) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return ctx.identifier().getText();
        }
        if (ctx.IDENTIFIER() != null) {
            return ctx.IDENTIFIER().getText();
        }
        return null;
    }

    @Override
    public final SqmCrossJoin visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    private void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot sqmRoot) {
        String name = parserJoin.pathRoot().entityName().fullNameText;
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a CROSS JOIN target");
        }
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.visitIdentificationVariableDef(parserJoin.pathRoot().identificationVariableDef()), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin(join);
    }

    @Override
    public final SqmQualifiedJoin visitQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitQualifiedJoin, see #consumeQualifiedJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin, SqmRoot<?> sqmRoot) {
        block11: {
            HqlParser.JoinTypeQualifierContext joinTypeQualifier = parserJoin.joinTypeQualifier();
            if (joinTypeQualifier.FULL() != null) {
                throw new SemanticException("FULL OUTER joins are not yet supported : " + parserJoin.getText());
            }
            if (joinTypeQualifier.RIGHT() != null) {
                throw new SemanticException("RIGHT OUTER joins are not yet supported : " + parserJoin.getText());
            }
            SqmJoinType joinType = joinTypeQualifier.OUTER() != null || joinTypeQualifier.LEFT() != null ? SqmJoinType.LEFT : SqmJoinType.INNER;
            String alias = this.visitIdentificationVariableDef(parserJoin.qualifiedJoinRhs().identificationVariableDef());
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, parserJoin.FETCH() != null, alias, this));
            try {
                SqmQualifiedJoin join = (SqmQualifiedJoin)parserJoin.qualifiedJoinRhs().path().accept(this);
                join.setExplicitAlias(alias);
                if (join instanceof SqmEntityJoin) {
                    sqmRoot.addSqmJoin(join);
                } else if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && ((SqmAttributeJoin)join).isFetched()) {
                    throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                }
                if (parserJoin.qualifiedJoinPredicate() == null) break block11;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)parserJoin.qualifiedJoinPredicate().predicate().accept(this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    @Override
    public SqmJoin visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot sqmRoot) {
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.LEFT, false, null, this));
        try {
            this.consumePluralAttributeReference(ctx.path());
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.predicate() == null) {
            return null;
        }
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.predicate().accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return new SqmAndPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return new SqmOrPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.predicate().accept(this);
        if (predicate instanceof SqmNegatablePredicate) {
            ((SqmNegatablePredicate)predicate).negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return new SqmBetweenPredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.expression(2).accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        return new SqmNullnessPredicate((SqmExpression)ctx.expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        return new SqmEmptinessPredicate((SqmPath)ctx.expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmComparisonPredicate visitEqualityPredicate(HqlParser.EqualityPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.EQUAL, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitInequalityPredicate(HqlParser.InequalityPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.NOT_EQUAL, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitGreaterThanPredicate(HqlParser.GreaterThanPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitGreaterThanOrEqualPredicate(HqlParser.GreaterThanOrEqualPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN_OR_EQUAL, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitLessThanPredicate(HqlParser.LessThanPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.LESS_THAN, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitLessThanOrEqualPredicate(HqlParser.LessThanOrEqualPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.LESS_THAN_OR_EQUAL, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        if (ctx.likeEscape() != null) {
            return new SqmLikePredicate((SqmExpression)ctx.expression().get(0).accept(this), (SqmExpression)ctx.expression().get(1).accept(this), (SqmExpression)ctx.likeEscape().expression().accept(this), this.creationContext.getNodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)ctx.expression().get(0).accept(this), (SqmExpression)ctx.expression().get(1).accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        SqmPath sqmPluralPath = this.consumeDomainPath(ctx.path());
        if (sqmPluralPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return new SqmMemberOfPredicate(sqmPluralPath, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Path argument to MEMBER OF must be a plural attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        SqmExpression testExpression = (SqmExpression)ctx.expression().accept(this);
        if (ctx.inList() instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)ctx.inList();
            this.parameterDeclarationContextStack.push(() -> tupleExpressionListContext.expression().size() == 1);
            try {
                ArrayList listExpressions = new ArrayList(tupleExpressionListContext.expression().size());
                for (HqlParser.ExpressionContext expressionContext : tupleExpressionListContext.expression()) {
                    SqmExpression listItemExpression = (SqmExpression)expressionContext.accept(this);
                    listExpressions.add(listItemExpression);
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (ctx.inList() instanceof HqlParser.SubQueryInListContext) {
            HqlParser.SubQueryInListContext subQueryContext = (HqlParser.SubQueryInListContext)ctx.inList();
            SqmExpression subQueryExpression = (SqmExpression)subQueryContext.expression().accept(this);
            if (!(subQueryExpression instanceof SqmSubQuery)) {
                throw new ParsingException("Was expecting a SubQueryExpression, but found " + subQueryExpression.getClass().getSimpleName() + " : " + subQueryContext.expression().toString());
            }
            return new SqmInSubQueryPredicate(testExpression, (SqmSubQuery)subQueryExpression, this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        if (ctx.entityTypeReference().parameter() != null) {
            return new SqmParameterizedEntityType((SqmParameter)ctx.entityTypeReference().parameter().accept(this), this.creationContext.getNodeBuilder());
        }
        if (ctx.entityTypeReference().path() != null) {
            return new SqmPathEntityType((SqmPath)ctx.entityTypeReference().path().accept(this), this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Could not interpret grammar context as 'entity type' expression : " + ctx.getText());
    }

    @Override
    public SqmMapEntryReference visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference(ctx.path()), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the concat operator");
        }
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(Arrays.asList(ctx.expression(0).accept(this), ctx.expression(1).accept(this)), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmBinaryArithmetic<?> visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the + operator");
        }
        return new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, (SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBinaryArithmetic<?> visitSubtractionExpression(HqlParser.SubtractionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the - operator");
        }
        return new SqmBinaryArithmetic(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBinaryArithmetic visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the * operator");
        }
        return new SqmBinaryArithmetic(BinaryArithmeticOperator.MULTIPLY, (SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBinaryArithmetic<?> visitDivisionExpression(HqlParser.DivisionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the / operator");
        }
        return new SqmBinaryArithmetic(BinaryArithmeticOperator.DIVIDE, (SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitModuloExpression(HqlParser.ModuloExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the % operator");
        }
        SqmExpression dividend = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression divisor = (SqmExpression)ctx.expression(1).accept(this);
        return this.getFunctionTemplate("mod").makeSqmFunctionExpression(Arrays.asList(dividend, divisor), (AllowableFunctionReturnType)dividend.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryPlusExpression(HqlParser.UnaryPlusExpressionContext ctx) {
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_PLUS, (SqmExpression)ctx.expression().accept(this));
    }

    @Override
    public SqmUnaryOperation visitUnaryMinusExpression(HqlParser.UnaryMinusExpressionContext ctx) {
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, (SqmExpression)ctx.expression().accept(this));
    }

    @Override
    public SqmCaseSimple visitSimpleCaseStatement(HqlParser.SimpleCaseStatementContext ctx) {
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.expression().accept(this), this.creationContext.getNodeBuilder());
        for (HqlParser.SimpleCaseWhenContext simpleCaseWhen : ctx.simpleCaseWhen()) {
            caseExpression.when((SqmExpression)simpleCaseWhen.expression(0).accept(this), (SqmExpression)simpleCaseWhen.expression(1).accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched visitSearchedCaseStatement(HqlParser.SearchedCaseStatementContext ctx) {
        SqmCaseSearched caseExpression = new SqmCaseSearched(this.creationContext.getNodeBuilder());
        for (HqlParser.SearchedCaseWhenContext whenFragment : ctx.searchedCaseWhen()) {
            caseExpression.when((SqmPredicate)whenFragment.predicate().accept(this), (SqmExpression)whenFragment.expression().accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionTemplate("current_date").makeSqmFunctionExpression(this.resolveExpressableTypeBasic(Date.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionTemplate("current_time").makeSqmFunctionExpression(this.resolveExpressableTypeBasic(Time.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionTemplate("current_timestamp").makeSqmFunctionExpression(this.resolveExpressableTypeBasic(Timestamp.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCurrentInstantFunction(HqlParser.CurrentInstantFunctionContext ctx) {
        return this.getFunctionTemplate("current_timestamp").makeSqmFunctionExpression(this.resolveExpressableTypeBasic(Instant.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitLeastFunction(HqlParser.LeastFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionTemplate("least").makeSqmFunctionExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitGreatestFunction(HqlParser.GreatestFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionTemplate("greatest").makeSqmFunctionExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCoalesceExpression(HqlParser.CoalesceExpressionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.coalesce().expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionTemplate("coalesce").makeSqmFunctionExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitNullIfExpression(HqlParser.NullIfExpressionContext ctx) {
        SqmExpression arg1 = (SqmExpression)ctx.nullIf().expression(0).accept(this);
        SqmExpression arg2 = (SqmExpression)ctx.nullIf().expression(1).accept(this);
        return this.getFunctionTemplate("nullif").makeSqmFunctionExpression(Arrays.asList(arg1, arg2), (AllowableFunctionReturnType)arg1.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmLiteral visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        if (ctx.literal().CHARACTER_LITERAL() != null) {
            return this.characterLiteral(ctx.literal().CHARACTER_LITERAL().getText());
        }
        if (ctx.literal().STRING_LITERAL() != null) {
            return this.stringLiteral(ctx.literal().STRING_LITERAL().getText());
        }
        if (ctx.literal().INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.literal().INTEGER_LITERAL().getText());
        }
        if (ctx.literal().LONG_LITERAL() != null) {
            return this.longLiteral(ctx.literal().LONG_LITERAL().getText());
        }
        if (ctx.literal().BIG_INTEGER_LITERAL() != null) {
            return this.bigIntegerLiteral(ctx.literal().BIG_INTEGER_LITERAL().getText());
        }
        if (ctx.literal().HEX_LITERAL() != null) {
            String text = ctx.literal().HEX_LITERAL().getText();
            if (text.endsWith("l") || text.endsWith("L")) {
                return this.longLiteral(text);
            }
            return this.integerLiteral(text);
        }
        if (ctx.literal().OCTAL_LITERAL() != null) {
            String text = ctx.literal().OCTAL_LITERAL().getText();
            if (text.endsWith("l") || text.endsWith("L")) {
                return this.longLiteral(text);
            }
            return this.integerLiteral(text);
        }
        if (ctx.literal().FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.literal().FLOAT_LITERAL().getText());
        }
        if (ctx.literal().DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.literal().DOUBLE_LITERAL().getText());
        }
        if (ctx.literal().BIG_DECIMAL_LITERAL() != null) {
            return this.bigDecimalLiteral(ctx.literal().BIG_DECIMAL_LITERAL().getText());
        }
        if (ctx.literal().FALSE() != null) {
            return this.booleanLiteral(false);
        }
        if (ctx.literal().TRUE() != null) {
            return this.booleanLiteral(true);
        }
        if (ctx.literal().NULL() != null) {
            return new SqmLiteralNull(this.creationContext.getQueryEngine().getCriteriaBuilder());
        }
        if (ctx.literal().timestampLiteral() != null) {
            return LiteralHelper.timestampLiteralFrom(ctx.literal().timestampLiteral().dateTimeLiteralText().getText(), this);
        }
        if (ctx.literal().dateLiteral() != null) {
            return LiteralHelper.dateLiteralFrom(ctx.literal().dateLiteral().dateTimeLiteralText().getText(), this);
        }
        if (ctx.literal().timeLiteral() != null) {
            return LiteralHelper.timeLiteralFrom(ctx.literal().timeLiteral().dateTimeLiteralText().getText(), this);
        }
        throw new ParsingException("Unexpected literal expression type [" + ctx.getText() + "]");
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        BasicDomainType<Boolean> expressionType = this.resolveExpressableTypeBasic(Boolean.class);
        return new SqmLiteral<Boolean>(value, expressionType, this.creationContext.getQueryEngine().getCriteriaBuilder());
    }

    private SqmLiteral<Character> characterLiteral(String text) {
        if (text.length() > 1) {
            throw new ParsingException("Value for CHARACTER_LITERAL token was more than 1 character");
        }
        return new SqmLiteral<Character>(Character.valueOf(text.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(text, this.resolveExpressableTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    protected SqmLiteral<Integer> integerLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine().getCriteriaBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
        }
    }

    protected SqmLiteral<Long> longLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
            }
            Long value = Long.valueOf(text);
            return new SqmLiteral<Long>(value, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to Long", e);
        }
    }

    protected SqmLiteral<BigInteger> bigIntegerLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bi") || text.endsWith("BI")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigInteger>(new BigInteger(text), this.resolveExpressableTypeBasic(BigInteger.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigInteger", e);
        }
    }

    protected SqmLiteral<Float> floatLiteral(String text) {
        try {
            return new SqmLiteral<Float>(Float.valueOf(text), this.resolveExpressableTypeBasic(Float.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Float", e);
        }
    }

    protected SqmLiteral<Double> doubleLiteral(String text) {
        try {
            return new SqmLiteral<Double>(Double.valueOf(text), this.resolveExpressableTypeBasic(Double.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Double", e);
        }
    }

    protected SqmLiteral<BigDecimal> bigDecimalLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bd") || text.endsWith("BD")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigDecimal>(new BigDecimal(text), this.resolveExpressableTypeBasic(BigDecimal.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigDecimal", e);
        }
    }

    private <J> BasicDomainType<J> resolveExpressableTypeBasic(Class<J> javaType) {
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.parameter().accept(this);
    }

    @Override
    public SqmNamedParameter visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        SqmNamedParameter param = new SqmNamedParameter(ctx.identifier().getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmPositionalParameter visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        if (ctx.INTEGER_LITERAL() == null) {
            throw new SemanticException("Encountered positional parameter which did not declare position (? instead of, e.g., ?1)");
        }
        SqmPositionalParameter param = new SqmPositionalParameter(Integer.parseInt(ctx.INTEGER_LITERAL().getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmExpression visitJpaNonStandardFunction(HqlParser.JpaNonStandardFunctionContext ctx) {
        String functionName = ctx.jpaNonStandardFunctionName().STRING_LITERAL().getText().toLowerCase();
        Object functionArguments = this.visitNonStandardFunctionArguments(ctx.nonStandardFunctionArguments());
        SqmFunctionTemplate functionTemplate = this.getFunctionTemplate(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionTemplate(functionName, true, null, null);
        }
        return functionTemplate.makeSqmFunctionExpression((List<SqmTypedNode<?>>)functionArguments, null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitNonStandardFunction(HqlParser.NonStandardFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + (Object)((Object)ctx.nonStandardFunctionName()) + "], but strict JPQL compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        String functionName = ctx.nonStandardFunctionName().getText().toLowerCase();
        Object functionArguments = this.visitNonStandardFunctionArguments(ctx.nonStandardFunctionArguments());
        SqmFunctionTemplate functionTemplate = this.getFunctionTemplate(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionTemplate(functionName, true, null, null);
        }
        return functionTemplate.makeSqmFunctionExpression((List<SqmTypedNode<?>>)functionArguments, null, this.creationContext.getQueryEngine());
    }

    @Override
    public List<SqmTypedNode<?>> visitNonStandardFunctionArguments(HqlParser.NonStandardFunctionArgumentsContext ctx) {
        ArrayList arguments = new ArrayList();
        int size = ctx.expression().size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                arguments.add(this.visitFinalFunctionArgument(ctx.expression(i)));
                continue;
            }
            arguments.add((SqmTypedNode)ctx.expression(i).accept(this));
        }
        return arguments;
    }

    private SqmExpression visitFinalFunctionArgument(HqlParser.ExpressionContext expression) {
        this.parameterDeclarationContextStack.push(this.creationOptions::useStrictJpaCompliance);
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept(this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    @Override
    public SqmExpression visitCeilingFunction(HqlParser.CeilingFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("ceiling").makeSqmFunctionExpression(arg, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitFloorFunction(HqlParser.FloorFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("floor").makeSqmFunctionExpression(arg, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getQueryEngine());
    }

    private SqmFunctionTemplate getFunctionTemplate(String name) {
        return this.creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionTemplate(name);
    }

    @Override
    public SqmExpression visitAbsFunction(HqlParser.AbsFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("abs").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitSignFunction(HqlParser.SignFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("sign").makeSqmFunctionExpression(arg, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitModFunction(HqlParser.ModFunctionContext ctx) {
        SqmExpression dividend = (SqmExpression)ctx.modDividendArgument().accept(this);
        SqmExpression divisor = (SqmExpression)ctx.modDivisorArgument().accept(this);
        return this.getFunctionTemplate("mod").makeSqmFunctionExpression(Arrays.asList(dividend, divisor), (AllowableFunctionReturnType)dividend.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitPowerFunction(HqlParser.PowerFunctionContext ctx) {
        SqmExpression base = (SqmExpression)ctx.powerBaseArgument().accept(this);
        SqmExpression power = (SqmExpression)ctx.powerPowerArgument().accept(this);
        return this.getFunctionTemplate("power").makeSqmFunctionExpression(Arrays.asList(base, power), (AllowableFunctionReturnType)base.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitTrigFunction(HqlParser.TrigFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate(ctx.trigFunctionName().getText()).makeSqmFunctionExpression(arg, this.resolveExpressableTypeBasic(Double.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitSqrtFunction(HqlParser.SqrtFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("sqrt").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitRoundFunction(HqlParser.RoundFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmExpression precision = (SqmExpression)ctx.roundFunctionPrecision().expression().accept(this);
        return this.getFunctionTemplate("round").makeSqmFunctionExpression(Arrays.asList(arg, precision), (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitAtan2Function(HqlParser.Atan2FunctionContext ctx) {
        SqmExpression sin = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression cos = (SqmExpression)ctx.expression().get(1).accept(this);
        return this.getFunctionTemplate("atan2").makeSqmFunctionExpression(Arrays.asList(sin, cos), (AllowableFunctionReturnType)sin.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitLnFunction(HqlParser.LnFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("ln").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitExpFunction(HqlParser.ExpFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("exp").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.DAY() != null) {
            return new SqmExtractUnit<Integer>("day", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MONTH() != null) {
            return new SqmExtractUnit<Integer>("month", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.YEAR() != null) {
            return new SqmExtractUnit<Integer>("year", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.HOUR() != null) {
            return new SqmExtractUnit<Integer>("hour", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MINUTE() != null) {
            return new SqmExtractUnit<Integer>("minute", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.SECOND() != null) {
            return new SqmExtractUnit<Float>("second", this.resolveExpressableTypeBasic(Float.class), nodeBuilder);
        }
        if (ctx.WEEK() != null) {
            return new SqmExtractUnit<Integer>("week", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.QUARTER() != null) {
            return new SqmExtractUnit<Integer>("quarter", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitDatetimeField(ctx);
    }

    @Override
    public Object visitSecondsField(HqlParser.SecondsFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.MICROSECOND() != null) {
            return new SqmExtractUnit<Integer>("microsecond", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MILLISECOND() != null) {
            return new SqmExtractUnit<Integer>("millisecond", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitSecondsField(ctx);
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.TIMEZONE_HOUR() != null) {
            return new SqmExtractUnit<Integer>("timezone_hour", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.TIMEZONE_MINUTE() != null) {
            return new SqmExtractUnit<Integer>("timezone_minute", this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitTimeZoneField(ctx);
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExtractUnit extractFieldExpression;
        SqmExpression expressionToExtract = (SqmExpression)ctx.expression().accept(this);
        if (ctx.extractField() != null) {
            extractFieldExpression = (SqmExtractUnit)ctx.extractField().accept(this);
        } else if (ctx.datetimeField() != null) {
            extractFieldExpression = (SqmExtractUnit)ctx.datetimeField().accept(this);
        } else {
            return expressionToExtract;
        }
        return this.getFunctionTemplate("extract").makeSqmFunctionExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmCastTarget<?> castTargetExpression = this.interpretCastTarget(ctx.castTarget());
        return this.getFunctionTemplate("cast").makeSqmFunctionExpression(Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.creationContext.getQueryEngine());
    }

    private SqmCastTarget<?> interpretCastTarget(HqlParser.CastTargetContext castTargetContext) {
        String text = castTargetContext.identifier().getText();
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (text.toLowerCase()) {
            case "string": {
                return new SqmCastTarget<String>(this.resolveExpressableTypeBasic(String.class), nodeBuilder);
            }
            case "integer": {
                return new SqmCastTarget<Integer>(this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
            }
            case "long": {
                return new SqmCastTarget<Long>(this.resolveExpressableTypeBasic(Long.class), nodeBuilder);
            }
            case "float": {
                return new SqmCastTarget<Float>(this.resolveExpressableTypeBasic(Float.class), nodeBuilder);
            }
            case "double": {
                return new SqmCastTarget<Double>(this.resolveExpressableTypeBasic(Double.class), nodeBuilder);
            }
            case "time": {
                return new SqmCastTarget<Time>(this.resolveExpressableTypeBasic(Time.class), nodeBuilder);
            }
            case "date": {
                return new SqmCastTarget<Date>(this.resolveExpressableTypeBasic(Date.class), nodeBuilder);
            }
            case "timestamp": {
                return new SqmCastTarget<Timestamp>(this.resolveExpressableTypeBasic(Timestamp.class), nodeBuilder);
            }
        }
        throw new HqlInterpretationException("unrecognized cast target type: " + text);
    }

    @Override
    public SqmExpression visitUpperFunction(HqlParser.UpperFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("upper").makeSqmFunctionExpression(expression, (AllowableFunctionReturnType)expression.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitLowerFunction(HqlParser.LowerFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("lower").makeSqmFunctionExpression(expression, (AllowableFunctionReturnType)expression.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitConcatFunction(HqlParser.ConcatFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            arguments.add((SqmTypedNode)argument.accept(this));
        }
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(arguments, this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitLengthFunction(HqlParser.LengthFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("character_length").makeSqmFunctionExpression(arg, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.positionFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.positionFunctionPatternArgument().accept(this);
        return this.getFunctionTemplate("locate").makeSqmFunctionExpression(Arrays.asList(pattern, string), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitLocateFunction(HqlParser.LocateFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.locateFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.locateFunctionPatternArgument().accept(this);
        SqmExpression start = ctx.locateFunctionStartArgument() == null ? null : (SqmExpression)ctx.locateFunctionStartArgument().accept(this);
        return this.getFunctionTemplate("locate").makeSqmFunctionExpression(start == null ? Arrays.asList(pattern, string) : Arrays.asList(pattern, string, start), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitReplaceFunction(HqlParser.ReplaceFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.replaceFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.replaceFunctionPatternArgument().accept(this);
        SqmExpression replacement = (SqmExpression)ctx.replaceFunctionReplacementArgument().accept(this);
        return this.getFunctionTemplate("replace").makeSqmFunctionExpression(Arrays.asList(string, pattern, replacement), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitStrFunction(HqlParser.StrFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        BasicDomainType<String> type = this.resolveExpressableTypeBasic(String.class);
        return this.getFunctionTemplate("cast").makeSqmFunctionExpression(Arrays.asList(arg, new SqmCastTarget<String>(type, this.creationContext.getNodeBuilder())), type, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitMaxFunction(HqlParser.MaxFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("max").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitMinFunction(HqlParser.MinFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("min").makeSqmFunctionExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitSumFunction(HqlParser.SumFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode argument = ctx.DISTINCT() != null ? new SqmDistinct(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionTemplate("sum").makeSqmFunctionExpression(argument, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitAvgFunction(HqlParser.AvgFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode argument = ctx.DISTINCT() != null ? new SqmDistinct(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionTemplate("avg").makeSqmFunctionExpression(argument, this.resolveExpressableTypeBasic(Double.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitCountFunction(HqlParser.CountFunctionContext ctx) {
        SqmExpression<Object> arg = ctx.ASTERISK() != null ? new SqmStar(this.getCreationContext().getNodeBuilder()) : (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode<Object> argument = ctx.DISTINCT() != null ? new SqmDistinct<Object>(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionTemplate("count").makeSqmFunctionExpression(argument, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression start = (SqmExpression)ctx.substringFunctionStartArgument().accept(this);
        SqmExpression length = ctx.substringFunctionLengthArgument() == null ? null : (SqmExpression)ctx.substringFunctionLengthArgument().accept(this);
        return this.getFunctionTemplate("substring").makeSqmFunctionExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionTemplate("trim").makeSqmFunctionExpression(Arrays.asList(this.interpretTrimSpecification(ctx.trimSpecification()), this.visitTrimCharacter(ctx.trimCharacter()), source), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine());
    }

    private SqmTrimSpecification interpretTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = TrimSpec.BOTH;
        if (ctx.LEADING() != null) {
            spec = TrimSpec.LEADING;
        } else if (ctx.TRAILING() != null) {
            spec = TrimSpec.TRAILING;
        }
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        if (ctx.CHARACTER_LITERAL() != null) {
            String trimCharText = ctx.CHARACTER_LITERAL().getText();
            if (trimCharText.length() != 1) {
                throw new SemanticException("Expecting [trim character] for TRIM function to be  single character, found : " + trimCharText);
            }
            return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
        }
        if (ctx.STRING_LITERAL() != null) {
            String trimCharText = ctx.STRING_LITERAL().getText();
            if (trimCharText.length() != 1) {
                throw new SemanticException("Expecting [trim character] for TRIM function to be  single character, found : " + trimCharText);
            }
            return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
        }
        return new SqmLiteral<Character>(Character.valueOf(' '), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath(ctx.path()), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPath visitCollectionIndexFunction(HqlParser.CollectionIndexFunctionContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFrom = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFrom == null) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] to SqmFrom");
        }
        SqmPathSource pluralAttribute = sqmFrom.getReferencedPathSource();
        if (!(pluralAttribute instanceof PluralPersistentAttribute)) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] as plural-attribute");
        }
        return ((PluralPersistentAttribute)pluralAttribute).getIndexPathSource().createSqmPath(sqmFrom, this);
    }

    private boolean isIndexedPluralAttribute(SqmPath path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmMaxElementPath visitMaxElementFunction(HqlParser.MaxElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMaxElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMinElementPath visitMinElementFunction(HqlParser.MinElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMinElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMaxIndexPath visitMaxIndexFunction(HqlParser.MaxIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("maxindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMaxIndexPath(pluralPath);
    }

    @Override
    public SqmMinIndexPath visitMinIndexFunction(HqlParser.MinIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("minindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMinIndexPath(pluralPath);
    }

    @Override
    public SqmSubQuery visitSubQueryExpression(HqlParser.SubQueryExpressionContext ctx) {
        return this.visitSubQuery(ctx.subQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery visitSubQuery(HqlParser.SubQueryContext ctx) {
        if (ctx.querySpec().selectClause() == null) {
            throw new SemanticException("Sub-query cannot use implicit select-clause : " + ctx.getText());
        }
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            subQuery.setQuerySpec(this.visitQuerySpec(ctx.querySpec()));
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        if (ctx.syntacticDomainPath() != null) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath(ctx.syntacticDomainPath());
            if (ctx.pathContinuation() != null) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)ctx.pathContinuation().accept(this);
                    return semanticPathPart;
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (ctx.generalPathFragment() != null) {
            return (SemanticPathPart)ctx.generalPathFragment().accept(this);
        }
        throw new ParsingException("Unrecognized `path` rule branch");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitDotIdentifierSequence(ctx.dotIdentifierSequence());
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return this.visitTreatedNavigablePath(ctx.treatedNavigablePath());
        }
        if (ctx.collectionElementNavigablePath() != null) {
            return this.visitCollectionElementNavigablePath(ctx.collectionElementNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return this.visitMapKeyNavigablePath(ctx.mapKeyNavigablePath());
        }
        if (ctx.dotIdentifierSequence() != null && ctx.indexedPathAccessFragment() != null) {
            SqmAttributeJoin indexedJoinPath = (SqmAttributeJoin)ctx.dotIdentifierSequence().accept(this);
            return new SqmIndexedCollectionAccessPath(indexedJoinPath, (SqmExpression)ctx.indexedPathAccessFragment().accept(this));
        }
        throw new ParsingException("Unsure how to process `syntacticDomainPath` over : " + ctx.getText());
    }

    @Override
    public SemanticPathPart visitDotIdentifierSequence(HqlParser.DotIdentifierSequenceContext ctx) {
        int numberOfContinuations = ctx.dotIdentifierSequenceContinuation().size();
        boolean hasContinuations = numberOfContinuations != 0;
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        assert (ctx.identifier().getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(ctx.identifier().getChild(0).getText(), true, !hasContinuations);
        if (hasContinuations) {
            int i = 1;
            for (HqlParser.DotIdentifierSequenceContinuationContext continuation : ctx.dotIdentifierSequenceContinuation()) {
                assert (continuation.identifier().getChildCount() == 1);
                dotIdentifierConsumer.consumeIdentifier(continuation.identifier().getChild(0).getText(), false, i++ >= numberOfContinuations);
            }
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    @Override
    public Object visitDotIdentifierSequenceContinuation(HqlParser.DotIdentifierSequenceContinuationContext ctx) {
        return super.visitDotIdentifierSequenceContinuation(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeManagedTypeReference(ctx.path());
        String treatTargetName = ctx.dotIdentifierSequence().getText();
        EntityDomainType treatTarget = this.getCreationContext().getJpaMetamodel().entity(treatTargetName);
        SqmPath result = this.resolveTreatedPath(sqmPath, treatTarget);
        if (ctx.pathContinuation() != null) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                @Override
                protected void reset() {
                }
            });
            try {
                result = this.consumeDomainPath(ctx.pathContinuation().dotIdentifierSequence());
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return result;
    }

    private SqmTreatedPath resolveTreatedPath(SqmPath<?> sqmPath, EntityDomainType<?> treatTarget) {
        return sqmPath.treatAs(treatTarget);
    }

    @Override
    public SqmPath<?> visitCollectionElementNavigablePath(HqlParser.CollectionElementNavigablePathContext ctx) {
        SqmPath pluralAttributePath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Illegal attempt to treat non-plural path as a plural path : " + pluralAttributePath.getNavigablePath());
        }
        PluralPersistentAttribute attribute = (PluralPersistentAttribute)referencedPathSource;
        if (this.getCreationOptions().useStrictJpaCompliance() && attribute.getCollectionClassification() != CollectionClassification.MAP) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        SqmPath result = attribute.getElementPathSource().createSqmPath(pluralAttributePath, this);
        if (ctx.pathContinuation() != null) {
            result = this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    @Override
    public SqmPath visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        if (!(referencedPathSource instanceof MapPersistentAttribute)) {
            throw new PathException("SqmPath#referencedPathSource [" + sqmPath + "] does not refer");
        }
        MapPersistentAttribute attribute = (MapPersistentAttribute)referencedPathSource;
        SqmPath result = attribute.getKeyPathSource().createSqmPath(sqmPath, this);
        if (ctx.pathContinuation() != null) {
            return this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    private SqmPath consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeDomainPath(HqlParser.DotIdentifierSequenceContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        try {
            pathSource.sqmAs(ManagedDomainType.class);
            return sqmPath;
        }
        catch (Exception e) {
            throw new SemanticException("Expecting ManagedType valued path [" + sqmPath.getNavigablePath() + "], but found : " + pathSource.getSqmPathType());
        }
    }

    private SqmPath consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new SemanticException("Expecting plural attribute valued path [" + sqmPath.getNavigablePath() + "], but found : " + sqmPath.getReferencedPathSource().getSqmPathType());
    }

    private static class TreatHandlerFromClause
    implements TreatHandler {
        private TreatHandlerFromClause() {
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableDomainType downcastTarget) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private static class TreatHandlerNormal
    implements TreatHandler {
        private final DowncastLocation downcastLocation;

        public TreatHandlerNormal() {
            this(DowncastLocation.OTHER);
        }

        public TreatHandlerNormal(DowncastLocation downcastLocation) {
            this.downcastLocation = downcastLocation;
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableDomainType downcastTarget) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private static interface TreatHandler {
        public void addDowncast(SqmFrom var1, IdentifiableDomainType var2);
    }
}

