/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.hql.HqlLogger;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.AliasCollisionException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.select.SqmSelection;

public class SqmPathRegistryImpl
implements SqmPathRegistry {
    private final SqmCreationProcessingState associatedProcessingState;
    private final Map<NavigablePath, SqmPath> sqmPathByPath = new HashMap<NavigablePath, SqmPath>();
    private final Map<NavigablePath, SqmFrom> sqmFromByPath = new HashMap<NavigablePath, SqmFrom>();
    private final Map<String, SqmFrom> sqmFromByAlias = new HashMap<String, SqmFrom>();
    private final LinkedHashMap<String, SqmSelection> sqmSelectionsByAlias = new LinkedHashMap();

    public SqmPathRegistryImpl(SqmCreationProcessingState associatedProcessingState) {
        this.associatedProcessingState = associatedProcessingState;
    }

    @Override
    public void register(SqmPath sqmPath) {
        SqmPath previousPath;
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#register(SqmPath) : %s", (Object)sqmPath.getNavigablePath().getFullPath());
        if (sqmPath instanceof SqmFrom) {
            SqmFrom previousFrom;
            SqmFrom sqmFrom = (SqmFrom)sqmPath;
            String alias = sqmPath.getExplicitAlias();
            if (alias != null && (previousFrom = this.sqmFromByAlias.put(alias, sqmFrom)) != null) {
                throw new AliasCollisionException(String.format(Locale.ENGLISH, "Alias [%s] used for multiple from-clause elements : %s, %s", alias, previousFrom, sqmPath));
            }
            SqmFrom previousFromByPath = this.sqmFromByPath.put(sqmPath.getNavigablePath(), sqmFrom);
            if (previousFromByPath != null) {
                throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousFromByPath, sqmFrom));
            }
        }
        if ((previousPath = this.sqmPathByPath.put(sqmPath.getNavigablePath(), sqmPath)) instanceof SqmFrom) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousPath, sqmPath));
        }
    }

    @Override
    public SqmPath findPath(NavigablePath path) {
        SqmFrom containingQueryFrom;
        SqmPath found = this.sqmPathByPath.get(path);
        if (found != null) {
            return found;
        }
        if (this.associatedProcessingState.getParentProcessingState() != null && (containingQueryFrom = this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromByPath(path)) != null) {
            return containingQueryFrom;
        }
        return null;
    }

    @Override
    public SqmFrom findFromByPath(NavigablePath navigablePath) {
        SqmFrom containingQueryFrom;
        SqmFrom found = this.sqmFromByPath.get(navigablePath);
        if (found != null) {
            return found;
        }
        if (this.associatedProcessingState.getParentProcessingState() != null && (containingQueryFrom = this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromByPath(navigablePath)) != null) {
            return containingQueryFrom;
        }
        return null;
    }

    @Override
    public SqmFrom findFromByAlias(String alias) {
        SqmFrom registered = this.sqmFromByAlias.get(alias);
        if (registered != null) {
            return registered;
        }
        if (this.associatedProcessingState.getParentProcessingState() != null) {
            return this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromByAlias(alias);
        }
        return null;
    }

    @Override
    public SqmFrom findFromExposing(String navigableName) {
        SqmFrom found = null;
        for (SqmFrom fromElement : this.sqmFromByPath.values()) {
            if (!this.definesAttribute(fromElement.getReferencedPathSource(), navigableName)) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple from-elements expose unqualified attribute : " + navigableName);
            }
            found = fromElement;
        }
        if (found == null && this.associatedProcessingState.getParentProcessingState() != null) {
            HqlLogger.QUERY_LOGGER.debugf("Unable to resolve unqualified attribute [%s] in local from-clause; checking parent ", navigableName);
            found = this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromExposing(navigableName);
        }
        return found;
    }

    @Override
    public SqmPath resolvePath(NavigablePath navigablePath, Function<NavigablePath, SqmPath> creator) {
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#resolvePath(NavigablePath) : %s", (Object)navigablePath);
        SqmPath existing = this.sqmPathByPath.get(navigablePath);
        if (existing != null) {
            return existing;
        }
        SqmPath sqmPath = creator.apply(navigablePath);
        this.register(sqmPath);
        return sqmPath;
    }

    private boolean definesAttribute(SqmPathSource containerType, String name) {
        return containerType.findSubPathSource(name) != null;
    }

    @Override
    public SqmSelection findSelectionByAlias(String alias) {
        return this.sqmSelectionsByAlias.get(alias);
    }

    @Override
    public SqmSelection findSelectionByPosition(int position) {
        if (position >= 1 && position <= this.sqmSelectionsByAlias.size()) {
            int i = 1;
            for (Map.Entry<String, SqmSelection> entry : this.sqmSelectionsByAlias.entrySet()) {
                if (position != i++) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public void register(SqmSelection selection) {
        if (selection.getAlias() != null) {
            this.checkResultVariable(selection);
            this.sqmSelectionsByAlias.put(selection.getAlias(), selection);
        }
    }

    private void checkResultVariable(SqmSelection selection) {
        String alias = selection.getAlias();
        if (this.sqmSelectionsByAlias.containsKey(alias)) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Alias [%s] is already used in same select clause", alias));
        }
        SqmFrom registeredFromElement = this.sqmFromByAlias.get(alias);
        if (registeredFromElement != null && !registeredFromElement.equals(selection.getSelectableNode())) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Alias [%s] used in select-clause [%s] also used in from-clause [%s]", alias, selection.getSelectableNode(), registeredFromElement));
        }
    }
}

