/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;

public class QueryInterpretationCacheDisabledImpl
implements QueryInterpretationCache {
    public static final QueryInterpretationCacheDisabledImpl INSTANCE = new QueryInterpretationCacheDisabledImpl();

    @Override
    public int getNumberOfCachedHqlInterpretations() {
        return 0;
    }

    @Override
    public int getNumberOfCachedQueryPlans() {
        return 0;
    }

    @Override
    public SelectQueryPlan resolveSelectQueryPlan(QueryInterpretationCache.Key key, Supplier<SelectQueryPlan> creator) {
        return null;
    }

    @Override
    public NonSelectQueryPlan getNonSelectQueryPlan(QueryInterpretationCache.Key key) {
        return null;
    }

    @Override
    public void cacheNonSelectQueryPlan(QueryInterpretationCache.Key key, NonSelectQueryPlan plan) {
    }

    @Override
    public HqlInterpretation resolveHqlInterpretation(String queryString, Function<String, SqmStatement<?>> creator) {
        ParameterMetadataImpl parameterMetadata;
        DomainParameterXref domainParameterXref;
        final SqmStatement<?> sqmStatement = creator.apply(queryString);
        if (sqmStatement.getSqmParameters().isEmpty()) {
            domainParameterXref = DomainParameterXref.empty();
            parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            domainParameterXref = DomainParameterXref.from(sqmStatement);
            parameterMetadata = new ParameterMetadataImpl(domainParameterXref.getQueryParameters());
        }
        return new HqlInterpretation(){

            @Override
            public SqmStatement getSqmStatement() {
                return sqmStatement;
            }

            @Override
            public ParameterMetadataImplementor getParameterMetadata() {
                return parameterMetadata;
            }

            @Override
            public DomainParameterXref getDomainParameterXref() {
                return domainParameterXref;
            }
        };
    }

    @Override
    public ParameterInterpretation resolveNativeQueryParameters(String queryString, Function<String, ParameterInterpretation> creator) {
        return creator.apply(queryString);
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void close() {
    }
}

