/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.Incubating;
import org.hibernate.QueryException;
import org.hibernate.QueryParameterException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryParameterBindingImpl;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;

@Incubating
public class QueryParameterBindingsImpl
implements QueryParameterBindings {
    private final SessionFactoryImplementor sessionFactory;
    private final ParameterMetadataImplementor parameterMetadata;
    private final boolean queryParametersValidationEnabled;
    private Map<QueryParameter, QueryParameterBinding> parameterBindingMap;

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory) {
        return QueryParameterBindingsImpl.from(parameterMetadata, sessionFactory, sessionFactory.getSessionFactoryOptions().isQueryParametersValidationEnabled());
    }

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory, boolean queryParametersValidationEnabled) {
        if (parameterMetadata == null) {
            throw new QueryParameterException("Query parameter metadata cannot be null");
        }
        return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata, queryParametersValidationEnabled);
    }

    private QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, ParameterMetadataImplementor parameterMetadata, boolean queryParametersValidationEnabled) {
        this.sessionFactory = sessionFactory;
        this.parameterMetadata = parameterMetadata;
        this.queryParametersValidationEnabled = queryParametersValidationEnabled;
        this.parameterBindingMap = CollectionHelper.concurrentMap(parameterMetadata.getParameterCount());
    }

    protected QueryParameterBinding makeBinding(QueryParameterImplementor queryParameter) {
        if (this.parameterBindingMap == null) {
            this.parameterBindingMap = new IdentityHashMap<QueryParameter, QueryParameterBinding>();
        } else assert (!this.parameterBindingMap.containsKey(queryParameter));
        if (!this.parameterMetadata.containsReference(queryParameter)) {
            throw new IllegalArgumentException("Cannot create binding for parameter reference [" + queryParameter + "] - reference is not a parameter of this query");
        }
        QueryParameterBindingImpl binding = new QueryParameterBindingImpl(queryParameter, this.sessionFactory, null, this.queryParametersValidationEnabled);
        this.parameterBindingMap.put(queryParameter, binding);
        return binding;
    }

    public boolean isBound(QueryParameterImplementor parameter) {
        return this.getBinding(parameter).isBound();
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(QueryParameterImplementor<P> parameter) {
        if (this.parameterBindingMap == null) {
            return this.makeBinding(parameter);
        }
        QueryParameterBinding binding = this.parameterBindingMap.get(parameter);
        if (binding == null) {
            binding = this.makeBinding(parameter);
        }
        return binding;
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(int position) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(position));
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(String name) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(name));
    }

    @Override
    public void validate() {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            if (!this.parameterBindingMap.containsKey(queryParameter)) {
                if (queryParameter.getName() != null) {
                    throw new QueryException("Named parameter not bound : " + queryParameter.getName());
                }
                throw new QueryException("Ordinal parameter not bound : " + queryParameter.getPosition());
            }
        });
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        for (QueryParameterBinding binding : this.parameterBindingMap.values()) {
            if (!binding.isMultiValued()) continue;
            return true;
        }
        return false;
    }

    public void visitBindings(BiConsumer action) {
        this.parameterMetadata.visitRegistrations(queryParameterImplementor -> action.accept(queryParameterImplementor, this.parameterBindingMap.get(queryParameterImplementor)));
    }
}

