/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.jpa.QueryHints;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractQuery<R>
implements QueryImplementor<R> {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(AbstractQuery.class);
    private final SharedSessionContractImplementor session;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;

    public AbstractQuery(SharedSessionContractImplementor session) {
        this.session = session;
    }

    protected void applyOptions(NamedQueryMemento memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach((string, object) -> this.setHint((String)string, object));
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected abstract boolean canApplyAliasSpecificLockModes();

    protected abstract void verifySettingLockMode();

    protected abstract void verifySettingAliasSpecificLockModes();

    protected abstract QueryParameterBindings getQueryParameterBindings();

    @Override
    public abstract ParameterMetadataImplementor getParameterMetadata();

    @Override
    public abstract MutableQueryOptions getQueryOptions();

    public int getMaxResults() {
        return this.getQueryOptions().getLimit().getMaxRowsJpa();
    }

    @Override
    public QueryImplementor<R> setMaxResults(int maxResult) {
        this.getQueryOptions().getLimit().setMaxRows(maxResult);
        return this;
    }

    public int getFirstResult() {
        return this.getQueryOptions().getLimit().getFirstRowJpa();
    }

    @Override
    public QueryImplementor<R> setFirstResult(int startPosition) {
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
        return this;
    }

    @Override
    public QueryImplementor<R> setTupleTransformer(TupleTransformer transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    public LockModeType getLockMode() {
        return LockModeTypeHelper.getLockModeType(this.getQueryOptions().getLockOptions().getLockMode());
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.getQueryOptions().getFlushMode();
    }

    @Override
    public QueryImplementor setHibernateFlushMode(FlushMode flushMode) {
        this.getQueryOptions().setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        FlushMode flushMode = this.getQueryOptions().getFlushMode() == null ? this.getSession().getHibernateFlushMode() : this.getQueryOptions().getFlushMode();
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    @Override
    public QueryImplementor setFlushMode(FlushModeType flushModeType) {
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public QueryImplementor setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
    }

    @Override
    public QueryImplementor setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public QueryImplementor setCacheRegion(String cacheRegion) {
        this.getQueryOptions().setResultCacheRegionName(cacheRegion);
        return this;
    }

    @Override
    public Integer getTimeout() {
        return this.getQueryOptions().getTimeout();
    }

    @Override
    public QueryImplementor setTimeout(int timeout) {
        this.getQueryOptions().setTimeout(timeout);
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.getQueryOptions().getFetchSize();
    }

    @Override
    public QueryImplementor setFetchSize(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public QueryImplementor setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    public QueryImplementor setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().setLockMode(lockOptions.getLockMode());
        this.getQueryOptions().getLockOptions().setScope(lockOptions.getScope());
        this.getQueryOptions().getLockOptions().setTimeOut(lockOptions.getTimeOut());
        this.getQueryOptions().getLockOptions().setFollowOnLocking(lockOptions.getFollowOnLocking());
        return this;
    }

    public QueryImplementor setLockMode(String alias, LockMode lockMode) {
        if (!LockMode.NONE.equals((Object)lockMode)) {
            this.verifySettingAliasSpecificLockModes();
        }
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public QueryImplementor setLockMode(LockModeType lockModeType) {
        if (!LockModeType.NONE.equals((Object)lockModeType)) {
            this.verifySettingLockMode();
        }
        this.getQueryOptions().getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    public QueryImplementor setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    public QueryImplementor addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public Map<String, Object> getHints() {
        this.getSession().checkOpen(false);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.collectBaselineHints(hints);
        this.collectHints(hints);
        return hints;
    }

    protected void collectBaselineHints(Map<String, Object> hints) {
    }

    protected void collectHints(Map<String, Object> hints) {
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("javax.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        if (this.getLockOptions().getTimeOut() != -1) {
            hints.put("javax.persistence.lock.timeout", this.getLockOptions().getTimeOut());
        }
        if (this.getLockOptions().getScope()) {
            hints.put("javax.persistence.lock.scope", this.getLockOptions().getScope());
        }
        if (this.getLockOptions().hasAliasSpecificLockModes()) {
            for (Map.Entry<String, LockMode> entry : this.getLockOptions().getAliasSpecificLocks()) {
                hints.put("org.hibernate.lockMode." + entry.getKey(), entry.getValue().name());
            }
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getHibernateFlushMode());
        if (this.getCacheMode() != null) {
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum)CacheModeHelper.interpretCacheRetrieveMode(this.getCacheMode()));
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum)CacheModeHelper.interpretCacheStoreMode(this.getCacheMode()));
        }
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
        }
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Enum hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Object hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    @Override
    public QueryImplementor<R> setHint(String hintName, Object value) {
        this.getSession().checkOpen(true);
        boolean applied = false;
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                applied = this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("javax.persistence.query.timeout".equals(hintName)) {
                int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                applied = this.applyTimeoutHint(timeout);
            } else if ("javax.persistence.lock.timeout".equals(hintName)) {
                applied = this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.comment".equals(hintName)) {
                applied = this.applyCommentHint((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                applied = this.applyFetchSizeHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                applied = this.applyCacheableHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                applied = this.applyCacheRegionHint((String)value);
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                applied = this.applyReadOnlyHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                applied = this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                applied = this.applyCacheModeHint(ConfigurationHelper.getCacheMode(value));
            } else if ("javax.persistence.cache.retrieveMode".equals(hintName)) {
                CacheRetrieveMode retrieveMode = value != null ? CacheRetrieveMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheRetrieveMode(retrieveMode);
            } else if ("javax.persistence.cache.storeMode".equals(hintName)) {
                CacheStoreMode storeMode = value != null ? CacheStoreMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheStoreMode(storeMode);
            } else if ("org.hibernate.lockMode".equals(hintName)) {
                applied = this.applyNativeQueryLockMode(value);
            } else if (hintName.startsWith("org.hibernate.lockMode")) {
                if (this.canApplyAliasSpecificLockModes()) {
                    String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
                    try {
                        LockMode lockMode = LockModeTypeHelper.interpretLockMode(value);
                        this.applyAliasSpecificLockModeHint(alias, lockMode);
                    }
                    catch (Exception e) {
                        log.unableToDetermineLockModeValue(hintName, value);
                        applied = false;
                    }
                } else {
                    applied = false;
                }
            } else if (QueryHints.HINT_FETCHGRAPH.equals(hintName) || QueryHints.HINT_LOADGRAPH.equals(hintName)) {
                if (value instanceof RootGraphImplementor) {
                    this.applyEntityGraphQueryHint(hintName, (RootGraphImplementor)value);
                } else {
                    log.warnf("The %s hint was set, but the value was not an EntityGraph!", hintName);
                }
                applied = true;
            } else if ("hibernate.query.followOnLocking".equals(hintName)) {
                applied = this.applyFollowOnLockingHint(ConfigurationHelper.getBoolean(value));
            } else {
                log.ignoringUnrecognizedQueryHint(hintName);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        if (!applied) {
            log.debugf("Skipping unsupported query hint [%s]", hintName);
        }
        return this;
    }

    protected boolean applyJpaCacheRetrieveMode(CacheRetrieveMode retrieveMode) {
        CacheMode currentCacheMode = NullnessHelper.nullif(this.getCacheMode(), this.getSession().getCacheMode());
        this.setCacheMode(CacheModeHelper.interpretCacheMode(CacheModeHelper.interpretCacheStoreMode(currentCacheMode), retrieveMode));
        return true;
    }

    protected boolean applyJpaCacheStoreMode(CacheStoreMode storeMode) {
        CacheMode currentCacheMode = NullnessHelper.nullif(this.getCacheMode(), this.getSession().getCacheMode());
        this.setCacheMode(CacheModeHelper.interpretCacheMode(storeMode, CacheModeHelper.interpretCacheRetrieveMode(currentCacheMode)));
        return true;
    }

    protected boolean applyNativeQueryLockMode(Object value) {
        return false;
    }

    protected boolean applyTimeoutHint(int timeout) {
        this.setTimeout(timeout);
        return true;
    }

    protected boolean applyLockTimeoutHint(int timeout) {
        this.getLockOptions().setTimeOut(timeout);
        return true;
    }

    protected boolean applyCommentHint(String comment) {
        this.setComment(comment);
        return true;
    }

    protected boolean applyFetchSizeHint(int fetchSize) {
        this.setFetchSize(fetchSize);
        return true;
    }

    protected boolean applyCacheableHint(boolean isCacheable) {
        this.setCacheable(isCacheable);
        return true;
    }

    protected boolean applyCacheRegionHint(String regionName) {
        this.setCacheRegion(regionName);
        return true;
    }

    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.setReadOnly(isReadOnly);
        return true;
    }

    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.setCacheMode(cacheMode);
        return true;
    }

    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
        return true;
    }

    protected boolean applyLockModeTypeHint(LockModeType lockModeType) {
        this.getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return true;
    }

    protected boolean applyHibernateLockModeHint(LockMode lockMode) {
        this.getLockOptions().setLockMode(lockMode);
        return true;
    }

    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
        this.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
    }

    protected abstract void applyEntityGraphQueryHint(String var1, RootGraphImplementor var2);

    protected boolean applyFollowOnLockingHint(Boolean followOnLocking) {
        this.getLockOptions().setFollowOnLocking(followOnLocking);
        return true;
    }

    public Set<Parameter<?>> getParameters() {
        return this.getParameterMetadata().getRegistrations();
    }

    public Parameter<?> getParameter(String name) {
        try {
            return this.getParameterMetadata().getQueryParameter(name);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(name);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to name [" + name + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public Parameter<?> getParameter(int position) {
        try {
            return this.getParameterMetadata().getQueryParameter(position);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(position);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to position [" + position + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public boolean isBound(Parameter<?> param) {
        QueryParameter qp = this.getParameterMetadata().resolve(param);
        return qp != null && this.getQueryParameterBindings().isBound((QueryParameterImplementor<?>)qp);
    }

    protected <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        if (parameter instanceof QueryParameterImplementor) {
            return this.locateBinding((QueryParameterImplementor)parameter);
        }
        if (parameter.getName() != null) {
            return this.locateBinding(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.locateBinding(parameter.getPosition());
        }
        throw this.getSession().getExceptionConverter().convert(new IllegalArgumentException("Could not resolve binding for given parameter reference [" + parameter + "]"));
    }

    protected <P> QueryParameterBinding<P> locateBinding(QueryParameterImplementor<P> parameter) {
        return this.getQueryParameterBindings().getBinding(parameter);
    }

    protected <P> QueryParameterBinding<P> locateBinding(String name) {
        return this.getQueryParameterBindings().getBinding(name);
    }

    protected <P> QueryParameterBinding<P> locateBinding(int position) {
        return this.getQueryParameterBindings().getBinding(position);
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        this.locateBinding(parameter).setBindValue(value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        if (value instanceof TypedParameterValue) {
            this.setParameter(parameter, ((TypedParameterValue)value).getValue(), ((TypedParameterValue)value).getType());
        } else {
            this.locateBinding(parameter).setBindValue(value);
        }
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, Object value, AllowableParameterType type) {
        if (parameter instanceof QueryParameter) {
            this.setParameter((QueryParameter)parameter, value, type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, type);
        } else if (value instanceof Collection) {
            this.locateBinding(parameter).setBindValues((Collection)value);
        } else {
            this.locateBinding(parameter).setBindValue(value, type);
        }
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value) {
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValueWrapper = (TypedParameterValue)value;
            this.setParameter(name, typedValueWrapper.getValue(), typedValueWrapper.getType());
        } else if (value instanceof Collection) {
            this.setParameterList(name, (Collection)value);
        } else {
            this.locateBinding(name).setBindValue(value);
        }
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value) {
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)value;
            this.setParameter(position, typedParameterValue.getValue(), typedParameterValue.getType());
        }
        if (value instanceof Collection) {
            this.setParameterList(Integer.toString(position), (Collection)value);
        } else {
            this.locateBinding(position).setBindValue(value);
        }
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType type) {
        this.locateBinding(parameter).setBindValue(value, type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value, AllowableParameterType type) {
        this.locateBinding(name).setBindValue(value, type);
        return this;
    }

    public QueryImplementor setParameter(int position, Object value, AllowableParameterType type) {
        this.locateBinding(position).setBindValue(value, type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        this.locateBinding(parameter).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<P> values) {
        this.locateBinding(parameter).setBindValues(values);
        return this;
    }

    public QueryImplementor setParameterList(String name, Collection values) {
        this.locateBinding(name).setBindValues(values);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection values) {
        this.locateBinding(position).setBindValues(values);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Collection values, AllowableParameterType type) {
        this.locateBinding(name).setBindValues(values, type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection values, AllowableParameterType type) {
        this.locateBinding(position).setBindValues(values, type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values) {
        this.locateBinding(name).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values) {
        this.locateBinding(position).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType type) {
        this.locateBinding(name).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType type) {
        this.locateBinding(position).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Collection values, Class javaType) {
        JavaTypeDescriptor javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, values);
        } else {
            AllowableParameterType paramType;
            BasicType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getDomainModel().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = (AllowableParameterType)managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine AllowableParameterType : " + javaType.getName());
                }
            }
            this.setParameterList(name, values, paramType);
        }
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection values, Class javaType) {
        JavaTypeDescriptor javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, values);
        } else {
            AllowableParameterType paramType;
            BasicType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getDomainModel().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = (AllowableParameterType)managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine AllowableParameterType : " + javaType.getName());
                }
            }
            this.setParameterList(position, values, paramType);
        }
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.locateBinding((QueryParameter)param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.locateBinding((QueryParameter)param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        QueryParameter qp = this.getParameterMetadata().resolve(param);
        if (qp == null) {
            throw new IllegalArgumentException("The parameter [" + param + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(qp);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("The parameter [" + param + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return (T)binding.getBindValues();
        }
        return (T)binding.getBindValue();
    }

    public Object getParameterValue(String name) {
        QueryParameter qp = this.getParameterMetadata().getQueryParameter(name);
        if (qp == null) {
            throw new IllegalArgumentException("The parameter [" + name + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(qp);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("The parameter [" + name + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    public Object getParameterValue(int position) {
        QueryParameter qp = this.getParameterMetadata().getQueryParameter(position);
        if (qp == null) {
            throw new IllegalArgumentException("The parameter [" + position + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(qp);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("The parameter [" + position + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    protected void beforeQuery(boolean requiresTxn) {
        CacheMode effectiveCacheMode;
        this.getQueryParameterBindings().validate();
        this.getSession().prepareForQueryExecution(requiresTxn);
        this.prepareForExecution();
        assert (this.sessionFlushMode == null);
        assert (this.sessionCacheMode == null);
        FlushMode effectiveFlushMode = this.getHibernateFlushMode();
        if (effectiveFlushMode != null) {
            this.sessionFlushMode = this.getSession().getHibernateFlushMode();
            this.getSession().setHibernateFlushMode(effectiveFlushMode);
        }
        if ((effectiveCacheMode = this.getCacheMode()) != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(effectiveCacheMode);
        }
    }

    protected void prepareForExecution() {
    }

    @Override
    public QueryImplementor<R> setProperties(Object bean) {
        Class<?> clazz = bean.getClass();
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            try {
                PropertyAccess propertyAccess = BuiltInPropertyAccessStrategies.BASIC.getStrategy().buildPropertyAccess(clazz, paramName);
                Getter getter = propertyAccess.getGetter();
                Class retType = getter.getReturnType();
                Object object = getter.get(bean);
                if (Collection.class.isAssignableFrom(retType)) {
                    this.setParameterList(paramName, (Collection)object);
                    continue;
                }
                if (retType.isArray()) {
                    this.setParameterList(paramName, (Object[])object);
                    continue;
                }
                AllowableParameterType type = this.determineType(paramName, retType);
                this.setParameter(paramName, object, type);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        }
        return this;
    }

    protected AllowableParameterType determineType(String namedParam, Class retType) {
        AllowableParameterType type = this.locateBinding(namedParam).getBindType();
        if (type == null) {
            type = this.getParameterMetadata().getQueryParameter(namedParam).getHibernateType();
        }
        if (type == null) {
            type = this.getSession().getFactory().resolveParameterBindType(retType);
        }
        return type;
    }

    public QueryImplementor setProperties(Map map) {
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            Object object = map.get(paramName);
            if (object == null) {
                if (!map.containsKey(paramName)) continue;
                this.setParameter(paramName, null, this.determineType(paramName, null));
                continue;
            }
            Class<?> retType = object.getClass();
            if (Collection.class.isAssignableFrom(retType)) {
                this.setParameterList(paramName, (Collection)object);
                continue;
            }
            if (retType.isArray()) {
                this.setParameterList(paramName, (Object[])object);
                continue;
            }
            this.setParameter(paramName, object, this.determineType(paramName, retType));
        }
        return this;
    }

    protected void afterQuery() {
        if (this.sessionFlushMode != null) {
            this.getSession().setHibernateFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }

    @Override
    public List<R> list() {
        this.beforeQuery(false);
        try {
            List<R> list = this.doList();
            return list;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        finally {
            this.afterQuery();
        }
    }

    protected abstract List<R> doList();

    @Override
    public R uniqueResult() {
        return AbstractQuery.uniqueElement(this.list());
    }

    @Override
    public R getSingleResult() {
        try {
            List<R> list = this.list();
            if (list.size() == 0) {
                throw new NoResultException("No entity found for query");
            }
            return AbstractQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            if (this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw this.getSession().getExceptionConverter().convert(e);
            }
            throw e;
        }
    }

    public static <R> R uniqueElement(List<R> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        R first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return Optional.ofNullable(this.uniqueResult());
    }

    @Override
    public ScrollableResultsImplementor scroll() {
        return this.scroll(this.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getDialect().defaultScrollMode());
    }

    @Override
    public ScrollableResultsImplementor scroll(ScrollMode scrollMode) {
        this.beforeQuery(false);
        try {
            ScrollableResultsImplementor scrollableResultsImplementor = this.doScroll(scrollMode);
            return scrollableResultsImplementor;
        }
        finally {
            this.afterQuery();
        }
    }

    protected abstract ScrollableResultsImplementor doScroll(ScrollMode var1);

    @Override
    public Stream<R> stream() {
        ScrollableResultsImplementor scrollableResults = this.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    public int executeUpdate() throws HibernateException {
        if (!this.getSession().isTransactionInProgress()) {
            throw this.getSession().getExceptionConverter().convert((RuntimeException)new TransactionRequiredException("Executing an update/delete query"));
        }
        this.beforeQuery(true);
        try {
            int n = this.doExecuteUpdate();
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            if (this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw this.getSession().getExceptionConverter().convert(e);
            }
            throw e;
        }
        finally {
            this.afterQuery();
        }
    }

    protected abstract int doExecuteUpdate();

    @Override
    public void setOptionalId(Serializable id) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalEntityName(String entityName) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalObject(Object optionalObject) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }
}

