/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.Collections;
import java.util.List;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.Limit;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;

public interface QueryOptions {
    public static final QueryOptions NONE = new QueryOptions(){

        @Override
        public Limit getLimit() {
            return Limit.NONE;
        }

        @Override
        public Integer getFetchSize() {
            return null;
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public LockOptions getLockOptions() {
            return LockOptions.NONE;
        }

        @Override
        public List<String> getDatabaseHints() {
            return Collections.emptyList();
        }

        @Override
        public Integer getTimeout() {
            return null;
        }

        @Override
        public FlushMode getFlushMode() {
            return null;
        }

        @Override
        public Boolean isReadOnly() {
            return null;
        }

        @Override
        public CacheRetrieveMode getCacheRetrieveMode() {
            return CacheRetrieveMode.BYPASS;
        }

        @Override
        public CacheStoreMode getCacheStoreMode() {
            return CacheStoreMode.BYPASS;
        }

        @Override
        public CacheMode getCacheMode() {
            return CacheMode.IGNORE;
        }

        @Override
        public Boolean isResultCachingEnabled() {
            return null;
        }

        @Override
        public String getResultCacheRegionName() {
            return null;
        }

        @Override
        public AppliedGraph getAppliedGraph() {
            return null;
        }

        @Override
        public TupleTransformer getTupleTransformer() {
            return null;
        }

        @Override
        public ResultListTransformer getResultListTransformer() {
            return null;
        }
    };

    public Integer getTimeout();

    public FlushMode getFlushMode();

    public Boolean isReadOnly();

    public AppliedGraph getAppliedGraph();

    public TupleTransformer getTupleTransformer();

    public ResultListTransformer getResultListTransformer();

    public Boolean isResultCachingEnabled();

    public CacheRetrieveMode getCacheRetrieveMode();

    public CacheStoreMode getCacheStoreMode();

    default public CacheMode getCacheMode() {
        return CacheMode.fromJpaModes(this.getCacheRetrieveMode(), this.getCacheStoreMode());
    }

    public String getResultCacheRegionName();

    public LockOptions getLockOptions();

    public String getComment();

    public List<String> getDatabaseHints();

    public Integer getFetchSize();

    public Limit getLimit();

    default public Integer getFirstRow() {
        return this.getLimit().getFirstRow();
    }

    default public Integer getMaxRows() {
        return this.getLimit().getMaxRows();
    }

    default public Limit getEffectiveLimit() {
        Limit explicit = this.getLimit();
        return explicit != null ? explicit : Limit.NONE;
    }

    default public boolean hasLimit() {
        Limit limit = this.getLimit();
        if (limit != null) {
            if (limit.getFirstRow() != null) {
                return true;
            }
            if (limit.getMaxRows() != null) {
                return true;
            }
        }
        return false;
    }
}

