/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCoalesce<T>
extends AbstractSqmExpression<T>
implements JpaCoalesce<T>,
DomainResultProducer<T> {
    private List<SqmExpression<? extends T>> arguments = new ArrayList<SqmExpression<? extends T>>();
    private SqmFunctionTemplate coalesceFunction;

    public SqmCoalesce(NodeBuilder nodeBuilder) {
        this((AllowableFunctionReturnType<T>)null, nodeBuilder);
    }

    public SqmCoalesce(AllowableFunctionReturnType<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.coalesceFunction = nodeBuilder.getQueryEngine().getSqmFunctionRegistry().findFunctionTemplate("coalesce");
    }

    public void value(SqmExpression<? extends T> expression) {
        this.arguments.add(expression);
        this.setExpressableType(expression.getNodeType());
    }

    public List<SqmExpression<? extends T>> getArguments() {
        return this.arguments;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFunction(this.coalesceFunction.makeSqmFunctionExpression(new ArrayList(this.arguments), (AllowableFunctionReturnType)this.getNodeType(), this.nodeBuilder().getQueryEngine()));
    }

    @Override
    public String asLoggableText() {
        return "coalesce(...)";
    }

    @Override
    public SqmCoalesce<T> value(T value) {
        this.value((SqmExpression<? extends T>)this.nodeBuilder().literal((Object)value));
        return this;
    }

    @Override
    public SqmCoalesce<T> value(Expression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> value(JpaExpression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> values(T ... values) {
        for (T value : values) {
            this.value((SqmExpression<? extends T>)this.nodeBuilder().literal((Object)value));
        }
        return this;
    }
}

