/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.streams.StingArrayCollector;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmSelectTranslation;
import org.hibernate.query.sqm.sql.SqmSelectTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleElementImpl;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement sqm;
    private final DomainParameterXref domainParameterXref;
    private final RowTransformer<R> rowTransformer;
    private volatile CacheableSqmInterpretation cacheableSqmInterpretation;

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, Class<R> resultType, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = this.determineRowTransformer(sqm, resultType, queryOptions);
    }

    private RowTransformer<R> determineRowTransformer(SqmSelectStatement sqm, Class<R> resultType, QueryOptions queryOptions) {
        if (resultType == null || resultType.isArray()) {
            if (queryOptions.getTupleTransformer() != null) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            return RowTransformerPassThruImpl.instance();
        }
        if (Tuple.class.isAssignableFrom(resultType)) {
            if (queryOptions.getTupleTransformer() == null) {
                ArrayList tupleElementList = new ArrayList();
                for (SqmSelection selection : ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections()) {
                    tupleElementList.add(new TupleElementImpl(selection.getSelectableNode().getJavaTypeDescriptor().getJavaType(), selection.getAlias()));
                }
                return new RowTransformerJpaTupleImpl(tupleElementList);
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + queryOptions.getTupleTransformer());
        }
        if (queryOptions.getTupleTransformer() != null) {
            return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections().size() > 1) {
            throw new IllegalQueryOperationException("Query defined multiple selections, return cannot be typed (other that Object[] or Tuple)");
        }
        return RowTransformerSingularReturnImpl.instance();
    }

    private RowTransformer makeRowTransformerTupleTransformerAdapter(SqmSelectStatement sqm, QueryOptions queryOptions) {
        return new RowTransformerTupleTransformerAdapter(((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections().stream().map(SqmSelection::getAlias).collect(StingArrayCollector.INSTANCE), queryOptions.getTupleTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> performList(ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        CacheableSqmInterpretation sqmInterpretation = this.resolveCacheableSqmInterpretation(executionContext);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.getJdbcParamsXref(), session.getFactory().getDomainModel(), sqmInterpretation.getTableGroupAccess()::findTableGroup, session);
        try {
            List<R> list = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(sqmInterpretation.getJdbcSelect(), jdbcParameterBindings, executionContext, this.rowTransformer);
            return list;
        }
        finally {
            this.domainParameterXref.clearExpansions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheableSqmInterpretation resolveCacheableSqmInterpretation(ExecutionContext executionContext) {
        CacheableSqmInterpretation localCopy = this.cacheableSqmInterpretation;
        if (localCopy == null) {
            ConcreteSqmSelectQueryPlan concreteSqmSelectQueryPlan = this;
            synchronized (concreteSqmSelectQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    this.cacheableSqmInterpretation = localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                }
            }
        }
        return localCopy;
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        SqmTranslatorFactory sqmTranslatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmSelectTranslator sqmConverter = sqmTranslatorFactory.createSelectTranslator(executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), sessionFactory);
        FromClauseAccess tableGroupAccess = sqmConverter.getFromClauseAccess();
        SqmSelectTranslation interpretation = sqmConverter.translate(sqm);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(interpretation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, interpretation::getJdbcParamsBySqmParam);
        return new CacheableSqmInterpretation(jdbcSelect, tableGroupAccess, jdbcParamsXref);
    }

    @Override
    public ScrollableResultsImplementor performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    private static class CacheableSqmInterpretation {
        private final JdbcSelect jdbcSelect;
        private final FromClauseAccess tableGroupAccess;
        private final Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

        CacheableSqmInterpretation(JdbcSelect jdbcSelect, FromClauseAccess tableGroupAccess, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref) {
            this.jdbcSelect = jdbcSelect;
            this.tableGroupAccess = tableGroupAccess;
            this.jdbcParamsXref = jdbcParamsXref;
        }

        JdbcSelect getJdbcSelect() {
            return this.jdbcSelect;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> getJdbcParamsXref() {
            return this.jdbcParamsXref;
        }
    }
}

