/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslation;
import org.hibernate.query.sqm.sql.SimpleSqmDeleteTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.SqlAstDeleteTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final SqmDeleteStatement sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcDelete jdbcDelete;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

    public SimpleDeleteQueryPlan(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref) {
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        if (this.jdbcDelete == null) {
            QueryEngine queryEngine = factory.getQueryEngine();
            SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
            SimpleSqmDeleteTranslator translator = translatorFactory.createSimpleDeleteTranslator(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), factory);
            SimpleSqmDeleteTranslation sqmInterpretation = translator.translate(this.sqmDelete);
            this.tableGroupAccess = translator.getFromClauseAccess();
            JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
            SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
            SqlAstDeleteTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildDeleteTranslator(factory);
            this.jdbcDelete = sqlAstTranslator.translate(sqmInterpretation.getSqlAst());
            this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.tableGroupAccess::findTableGroup, executionContext.getSession());
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

