/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.QueryException;
import org.hibernate.SortOrder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.function.SqmCastTarget;
import org.hibernate.query.sqm.function.SqmCoalesce;
import org.hibernate.query.sqm.function.SqmDistinct;
import org.hibernate.query.sqm.function.SqmFunction;
import org.hibernate.query.sqm.function.SqmTrimSpecification;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmRestrictedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;

public class SqmCriteriaNodeBuilder
implements NodeBuilder {
    private final QueryEngine queryEngine;
    private final JpaMetamodel domainModel;
    private final ServiceRegistry serviceRegistry;

    public static SqmCriteriaNodeBuilder create(SessionFactoryImplementor sf) {
        return new SqmCriteriaNodeBuilder(sf.getQueryEngine(), sf.getMetamodel().getJpaMetamodel(), sf.getServiceRegistry());
    }

    public SqmCriteriaNodeBuilder(QueryEngine queryEngine, JpaMetamodel domainModel, ServiceRegistry serviceRegistry) {
        this.queryEngine = queryEngine;
        this.domainModel = domainModel;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public JpaMetamodel getDomainModel() {
        return this.domainModel;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public void close() {
    }

    @Override
    public SqmSelectStatement<Object> createQuery() {
        return new SqmSelectStatement<Object>(Object.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmSelectStatement<T> createQuery(Class<T> resultClass) {
        return new SqmSelectStatement<T>(resultClass, (NodeBuilder)this);
    }

    @Override
    public SqmSelectStatement<Tuple> createTupleQuery() {
        return new SqmSelectStatement<Tuple>(Tuple.class, (NodeBuilder)this);
    }

    @Override
    public <T> SqmUpdateStatement<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new SqmUpdateStatement<T>(targetEntity, this);
    }

    @Override
    public <T> SqmDeleteStatement<T> createCriteriaDelete(Class<T> targetEntity) {
        return new SqmDeleteStatement<T>(targetEntity, SqmQuerySource.CRITERIA, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInsertSelectStatement<T> createCriteriaInsertSelect(Class<T> targetEntity) {
        return new SqmInsertSelectStatement<T>(targetEntity, (NodeBuilder)this);
    }

    @Override
    public <X, T> SqmExpression<X> cast(JpaExpression<T> expression, Class<X> castTargetJavaType) {
        BasicType type = this.getTypeConfiguration().standardBasicTypeForJavaType(castTargetJavaType);
        return this.getFunctionTemplate("cast").makeSqmFunctionExpression(Arrays.asList((SqmTypedNode)((Object)expression), new SqmCastTarget(type, this)), type, this.queryEngine);
    }

    @Override
    public SqmPredicate wrap(Expression<Boolean> expression) {
        if (expression instanceof SqmPredicate) {
            return (SqmPredicate)expression;
        }
        return new SqmBooleanExpressionPredicate((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate wrap(Expression ... expressions) {
        SqmPredicate lhs = (SqmPredicate)expressions[0];
        SqmPredicate rhs = (SqmPredicate)expressions[0];
        SqmAndPredicate predicate = new SqmAndPredicate(lhs, rhs, this);
        if (expressions.length > 2) {
            for (Expression expression : expressions) {
                if (!(expression instanceof SqmPredicate)) {
                    return new SqmBooleanExpressionPredicate((SqmExpression)expression, (NodeBuilder)this);
                }
                SqmPredicate newRhs = (SqmPredicate)expression;
                predicate = new SqmAndPredicate(predicate, newRhs, this);
            }
        }
        return predicate;
    }

    @Override
    public <X, T extends X> SqmPath<T> treat(Path<X> path, Class<T> type) {
        return ((SqmPath)path).treatAs(type);
    }

    @Override
    public <X, T extends X> SqmRoot<T> treat(Root<X> root, Class<T> type) {
        return ((SqmRoot)root).treatAs(type);
    }

    @Override
    public <X, T, V extends T> SqmSingularJoin<X, V> treat(Join<X, T> join, Class<V> type) {
        return ((SqmSingularJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmBagJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return ((SqmBagJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return ((SqmSetJoin)join).treatAs(type);
    }

    @Override
    public <X, T, E extends T> SqmListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return ((SqmListJoin)join).treatAs(type);
    }

    @Override
    public <X, K, T, V extends T> SqmMapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        return ((SqmMapJoin)join).treatAs(type);
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, Selection<?>[] arguments) {
        SqmDynamicInstantiation instantiation = List.class.equals(resultClass) ? SqmDynamicInstantiation.forListInstantiation(this) : (Map.class.equals(resultClass) ? SqmDynamicInstantiation.forMapInstantiation(this) : SqmDynamicInstantiation.forClassInstantiation(resultClass, (NodeBuilder)this));
        for (Selection<?> argument : arguments) {
            instantiation.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)argument, argument.getAlias(), this));
        }
        return instantiation;
    }

    @Override
    public <Y> JpaCompoundSelection<Y> construct(Class<Y> resultClass, List<? extends JpaSelection<?>> arguments) {
        SqmDynamicInstantiation instantiation = List.class.equals(resultClass) ? SqmDynamicInstantiation.forListInstantiation(this) : (Map.class.equals(resultClass) ? SqmDynamicInstantiation.forMapInstantiation(this) : SqmDynamicInstantiation.forClassInstantiation(resultClass, (NodeBuilder)this));
        for (Selection selection : arguments) {
            instantiation.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)selection, selection.getAlias(), this));
        }
        return instantiation;
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression, SortOrder sortOrder) {
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder);
    }

    @Override
    public SqmSortSpecification sort(JpaExpression<?> sortExpression) {
        return new SqmSortSpecification((SqmExpression)sortExpression);
    }

    @Override
    public SqmSortSpecification asc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.ASCENDING);
    }

    @Override
    public SqmSortSpecification desc(Expression<?> x) {
        return new SqmSortSpecification((SqmExpression)x, SortOrder.DESCENDING);
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(Selection<?>[] selections) {
        return new SqmJpaCompoundSelection<Tuple>(ArrayHelper.toList(selections), this.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Tuple.class), this);
    }

    @Override
    public JpaCompoundSelection<Tuple> tuple(List<? extends JpaSelection<?>> selections) {
        return new SqmJpaCompoundSelection<Tuple>(selections, this.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Tuple.class), this);
    }

    @Override
    public <R> SqmTuple<R> tuple(Class<R> tupleType, JpaExpression<?> ... expressions) {
        return new SqmTuple(Arrays.asList(expressions), (NodeBuilder)this);
    }

    @Override
    public <R> SqmTuple<R> tuple(Class<R> tupleType, List<JpaExpression<?>> expressions) {
        return new SqmTuple(expressions, (NodeBuilder)this);
    }

    @Override
    public <R> SqmTuple<R> tuple(DomainType<R> tupleType, JpaExpression<?> ... expressions) {
        return new SqmTuple<R>(Arrays.asList(expressions), tupleType, this);
    }

    @Override
    public <R> SqmTuple<R> tuple(DomainType<R> tupleType, List<JpaExpression<?>> expressions) {
        return new SqmTuple<R>(new ArrayList(expressions), tupleType, this);
    }

    @Override
    public JpaCompoundSelection<Object[]> array(Selection<?>[] selections) {
        return new SqmJpaCompoundSelection<Object[]>(ArrayHelper.toList(selections), this.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Object[].class), this);
    }

    @Override
    public JpaCompoundSelection<Object[]> array(List<? extends JpaSelection<?>> selections) {
        return new SqmJpaCompoundSelection<Object[]>(selections, this.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Object[].class), this);
    }

    @Override
    public <N extends Number> SqmExpression<Double> avg(Expression<N> argument) {
        return this.getFunctionTemplate("avg").makeSqmFunctionExpression((SqmTypedNode)argument, StandardBasicTypes.DOUBLE, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<N> argument) {
        return this.getFunctionTemplate("sum").makeSqmFunctionExpression((SqmTypedNode)argument, (AllowableFunctionReturnType)((SqmExpression)argument).getNodeType(), this.queryEngine);
    }

    @Override
    public SqmExpression<Long> sumAsLong(Expression<Integer> argument) {
        return this.cast(this.sum((Expression)argument), Long.class);
    }

    @Override
    public SqmExpression<Double> sumAsDouble(Expression<Float> argument) {
        return this.cast(this.sum((Expression)argument), Double.class);
    }

    @Override
    public <N extends Number> SqmExpression<N> max(Expression<N> argument) {
        return this.getFunctionTemplate("max").makeSqmFunctionExpression((SqmTypedNode)argument, (AllowableFunctionReturnType)((SqmExpression)argument).getNodeType(), this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> min(Expression<N> argument) {
        return this.getFunctionTemplate("min").makeSqmFunctionExpression((SqmTypedNode)argument, (AllowableFunctionReturnType)((SqmExpression)argument).getNodeType(), this.queryEngine);
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> greatest(Expression<X> argument) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <X extends Comparable<? super X>> SqmExpression<X> least(Expression<X> argument) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmExpression<Long> count(Expression<?> argument) {
        return this.getFunctionTemplate("count").makeSqmFunctionExpression((SqmTypedNode)argument, StandardBasicTypes.LONG, this.queryEngine);
    }

    @Override
    public SqmExpression<Long> countDistinct(Expression<?> argument) {
        return this.getFunctionTemplate("count").makeSqmFunctionExpression(new SqmDistinct((SqmExpression)argument, this.getQueryEngine().getCriteriaBuilder()), StandardBasicTypes.LONG, this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> neg(Expression<N> x) {
        SqmExpression sqmExpression = (SqmExpression)x;
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, sqmExpression);
    }

    @Override
    public <N extends Number> SqmExpression<N> abs(Expression<N> x) {
        return this.getFunctionTemplate("abs").makeSqmFunctionExpression((SqmTypedNode)x, (AllowableFunctionReturnType)((SqmExpression)x).getNodeType(), this.queryEngine);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, (SqmExpression)y);
    }

    private <N extends Number> SqmExpression<N> createSqmArithmeticNode(BinaryArithmeticOperator operator, SqmExpression leftHandExpression, SqmExpression rightHandExpression) {
        return new SqmBinaryArithmetic(operator, leftHandExpression, rightHandExpression, this.getDomainModel().getTypeConfiguration().resolveArithmeticType(leftHandExpression.getNodeType(), rightHandExpression.getNodeType(), operator), (NodeBuilder)this);
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, (SqmExpression)x, this.literal(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> sum(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, this.literal(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.ADD, this.literal(x), (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(Expression<? extends N> x, N y) {
        return this.sum((Expression)x, (Number)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> prod(N x, Expression<? extends N> y) {
        return this.sum((Number)x, (Expression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(Expression<? extends N> x, N y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)x, this.literal(y));
    }

    @Override
    public <N extends Number> SqmExpression<N> diff(N x, Expression<? extends N> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.SUBTRACT, this.literal(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Number> quot(Expression<? extends Number> x, Number y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, (SqmExpression)x, this.literal(y));
    }

    @Override
    public SqmExpression<Number> quot(Number x, Expression<? extends Number> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.QUOT, this.literal(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public SqmExpression<Integer> mod(Expression<Integer> x, Integer y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, (SqmExpression)x, this.literal(y));
    }

    @Override
    public SqmExpression<Integer> mod(Integer x, Expression<Integer> y) {
        return this.createSqmArithmeticNode(BinaryArithmeticOperator.MODULO, this.literal(x), (SqmExpression)y);
    }

    @Override
    public SqmExpression<Double> sqrt(Expression<? extends Number> x) {
        return this.getFunctionTemplate("sqrt").makeSqmFunctionExpression((SqmTypedNode)x, (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType2(((SqmExpression)x).getNodeType(), StandardBasicTypes.DOUBLE), this.queryEngine);
    }

    @Override
    public SqmExpression<Long> toLong(Expression<? extends Number> number) {
        return ((SqmExpression)number).asLong();
    }

    @Override
    public SqmExpression<Integer> toInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asInteger();
    }

    @Override
    public SqmExpression<Float> toFloat(Expression<? extends Number> number) {
        return ((SqmExpression)number).asFloat();
    }

    @Override
    public SqmExpression<Double> toDouble(Expression<? extends Number> number) {
        return ((SqmExpression)number).asDouble();
    }

    @Override
    public SqmExpression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigDecimal();
    }

    @Override
    public SqmExpression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return ((SqmExpression)number).asBigInteger();
    }

    @Override
    public SqmExpression<String> toString(Expression<Character> character) {
        return ((SqmExpression)character).asString();
    }

    public <T> SqmLiteral<T> literal(T value) {
        if (value == null) {
            return new SqmLiteralNull(this);
        }
        return new SqmLiteral<T>(value, this.getTypeConfiguration().standardBasicTypeForJavaType(value.getClass()), this);
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(T[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> List<? extends SqmExpression<T>> literals(List<T> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqmExpression> literals = new ArrayList<SqmExpression>();
        for (T value : values) {
            literals.add(this.literal((Object)value));
        }
        return literals;
    }

    @Override
    public <T> SqmExpression<T> nullLiteral(Class<T> resultClass) {
        return new SqmLiteralNull(this.getTypeConfiguration().standardBasicTypeForJavaType(resultClass), (NodeBuilder)this);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass) {
        return new JpaCriteriaParameter(this.getTypeConfiguration().standardBasicTypeForJavaType(paramClass), false, this);
    }

    public <T> JpaCriteriaParameter<T> parameter(Class<T> paramClass, String name) {
        return new JpaCriteriaParameter(name, this.getTypeConfiguration().standardBasicTypeForJavaType(paramClass), false, this);
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, Expression<String> y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression ySqmExpression = (SqmExpression)y;
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(Arrays.asList(xSqmExpression, ySqmExpression), (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(xSqmExpression.getNodeType(), ySqmExpression.getNodeType(), StandardBasicTypes.STRING), this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(Expression<String> x, String y) {
        SqmExpression xSqmExpression = (SqmExpression)x;
        SqmExpression ySqmExpression = this.literal(y);
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(Arrays.asList(xSqmExpression, ySqmExpression), (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(xSqmExpression.getNodeType(), ySqmExpression.getNodeType(), StandardBasicTypes.STRING), this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(String x, Expression<String> y) {
        SqmExpression xSqmExpression = this.literal(x);
        SqmExpression ySqmExpression = (SqmExpression)y;
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(Arrays.asList(xSqmExpression, ySqmExpression), (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(xSqmExpression.getNodeType(), ySqmExpression.getNodeType(), StandardBasicTypes.STRING), this.getQueryEngine());
    }

    @Override
    public SqmExpression<String> concat(String x, String y) {
        SqmExpression xSqmExpression = this.literal(x);
        SqmExpression ySqmExpression = this.literal(y);
        return this.getFunctionTemplate("concat").makeSqmFunctionExpression(Arrays.asList(xSqmExpression, ySqmExpression), (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(xSqmExpression.getNodeType(), ySqmExpression.getNodeType(), StandardBasicTypes.STRING), this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, null);
    }

    private SqmFunction<String> createSubstringNode(SqmExpression source, SqmExpression from, SqmExpression len) {
        AllowableFunctionReturnType resultType = (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType2(source.getNodeType(), StandardBasicTypes.STRING);
        return this.getFunctionTemplate("substring").makeSqmFunctionExpression(len == null ? Arrays.asList(source, from) : Arrays.asList(source, from, len), resultType, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from) {
        return this.createSubstringNode((SqmExpression)source, this.literal((Object)from), null);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, Expression<Integer> from, Expression<Integer> len) {
        return this.createSubstringNode((SqmExpression)source, (SqmExpression)from, (SqmExpression)len);
    }

    @Override
    public SqmFunction<String> substring(Expression<String> source, int from, int len) {
        return this.createSubstringNode((SqmExpression)source, this.literal((Object)from), this.literal((Object)len));
    }

    @Override
    public SqmFunction<String> trim(Expression<String> source) {
        return this.createTrimNode(null, null, (SqmExpression)source);
    }

    private SqmFunction<String> createTrimNode(TrimSpec trimSpecification, SqmExpression trimCharacter, SqmExpression source) {
        ArrayList arguments = new ArrayList();
        if (trimSpecification != null) {
            arguments.add(new SqmTrimSpecification(trimSpecification, this));
        }
        if (trimCharacter != null) {
            arguments.add(trimCharacter);
        }
        arguments.add(source);
        return this.getFunctionTemplate("trim").makeSqmFunctionExpression(arguments, (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType2(source.getNodeType(), StandardBasicTypes.STRING), this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), null, (SqmExpression)source);
    }

    private static TrimSpec convertTrimSpec(CriteriaBuilder.Trimspec jpaTs) {
        if (jpaTs == null) {
            return null;
        }
        switch (jpaTs) {
            case BOTH: {
                return TrimSpec.BOTH;
            }
            case LEADING: {
                return TrimSpec.LEADING;
            }
            case TRAILING: {
                return TrimSpec.TRAILING;
            }
        }
        throw new QueryException("Could not resolve JPA TrimSpec : " + jpaTs);
    }

    @Override
    public SqmFunction<String> trim(Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(null, (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> trimChar, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), (SqmExpression)trimChar, (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(char trimChar, Expression<String> source) {
        return this.createTrimNode(null, this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> trim(CriteriaBuilder.Trimspec ts, char trimChar, Expression<String> source) {
        return this.createTrimNode(SqmCriteriaNodeBuilder.convertTrimSpec(ts), this.literal(Character.valueOf(trimChar)), (SqmExpression)source);
    }

    @Override
    public SqmFunction<String> lower(Expression<String> x) {
        AllowableFunctionReturnType type = (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(((SqmExpression)x).getNodeType(), StandardBasicTypes.STRING);
        return this.getFunctionTemplate("lower").makeSqmFunctionExpression((SqmExpression)x, type, this.getQueryEngine());
    }

    @Override
    public SqmFunction<String> upper(Expression<String> x) {
        AllowableFunctionReturnType type = (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(((SqmExpression)x).getNodeType(), StandardBasicTypes.STRING);
        return this.getFunctionTemplate("upper").makeSqmFunctionExpression((SqmExpression)x, type, this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> length(Expression<String> argument) {
        return this.getFunctionTemplate("length").makeSqmFunctionExpression((SqmExpression)argument, (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(((SqmExpression)argument).getNodeType(), StandardBasicTypes.INTEGER), this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, null);
    }

    private SqmFunction<Integer> createLocateFunctionNode(SqmExpression<String> source, SqmExpression<String> pattern, SqmExpression<Integer> startPosition) {
        AllowableFunctionReturnType type = (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(source.getNodeType(), StandardBasicTypes.INTEGER);
        List<SqmTypedNode<Object>> arguments = startPosition == null ? Arrays.asList(source, pattern) : Arrays.asList(source, pattern);
        return this.getFunctionTemplate("locate").makeSqmFunctionExpression(arguments, type, this.getQueryEngine());
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern) {
        return this.createLocateFunctionNode((SqmExpression)source, this.literal(pattern), null);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, Expression<String> pattern, Expression<Integer> startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, (SqmExpression)pattern, (SqmExpression)startPosition);
    }

    @Override
    public SqmFunction<Integer> locate(Expression<String> source, String pattern, int startPosition) {
        return this.createLocateFunctionNode((SqmExpression)source, this.literal(pattern), this.literal((Object)startPosition));
    }

    @Override
    public SqmFunction<Date> currentDate() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public SqmFunction<Timestamp> currentTimestamp() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public SqmFunction<Time> currentTime() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public SqmFunction<Instant> currentInstant() {
        return this.getFunctionTemplate("current_timestamp").makeSqmFunctionExpression(StandardBasicTypes.INSTANT, this.queryEngine);
    }

    @Override
    public <T> SqmFunction<T> function(String name, Class<T> type, Expression<?>[] args) {
        SqmFunctionTemplate functionTemplate = this.getFunctionTemplate(name);
        if (functionTemplate == null) {
            throw new SemanticException("Could not resolve function named `" + name + "`");
        }
        return functionTemplate.makeSqmFunctionExpression(SqmCriteriaNodeBuilder.expressionList(args), this.getTypeConfiguration().standardBasicTypeForJavaType(type), this.getQueryEngine());
    }

    private static List<SqmExpression<?>> expressionList(Expression<?>[] jpaExpressions) {
        if (jpaExpressions == null || jpaExpressions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList sqmExpressions = new ArrayList();
        for (Expression<?> jpaExpression : jpaExpressions) {
            sqmExpressions.add((SqmExpression)jpaExpression);
        }
        return sqmExpressions;
    }

    @Override
    public <Y> SqmRestrictedSubQueryExpression<Y> all(Subquery<Y> subquery) {
        return new SqmRestrictedSubQueryExpression((SqmSubQuery)subquery, SqmRestrictedSubQueryExpression.Modifier.ALL, this);
    }

    @Override
    public <Y> SqmRestrictedSubQueryExpression<Y> some(Subquery<Y> subquery) {
        return new SqmRestrictedSubQueryExpression((SqmSubQuery)subquery, SqmRestrictedSubQueryExpression.Modifier.SOME, this);
    }

    @Override
    public <Y> SqmRestrictedSubQueryExpression<Y> any(Subquery<Y> subquery) {
        return new SqmRestrictedSubQueryExpression((SqmSubQuery)subquery, SqmRestrictedSubQueryExpression.Modifier.ANY, this);
    }

    @Override
    public <K, M extends Map<K, ?>> SqmExpression<Set<K>> keys(M map) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <K, L extends List<?>> SqmExpression<Set<K>> indexes(L list) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <V, C extends Collection<V>> SqmExpression<Collection<V>> values(C collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(Expression<C> collection) {
        return new SqmCollectionSize((SqmPath)collection, (NodeBuilder)this);
    }

    @Override
    public <C extends Collection<?>> SqmExpression<Integer> size(C collection) {
        return new SqmLiteral<Integer>(collection.size(), StandardBasicTypes.INTEGER, this);
    }

    @Override
    public <T> SqmCoalesce<T> coalesce() {
        return new SqmCoalesce(this);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        return ((SqmCoalesce)new SqmCoalesce((AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(((SqmExpression)x).getNodeType(), ((SqmExpression)y).getNodeType()), (NodeBuilder)this).value((Expression)x)).value((Expression)y);
    }

    @Override
    public <Y> JpaCoalesce<Y> coalesce(Expression<? extends Y> x, Y y) {
        return this.coalesce((Expression)x, this.literal(y));
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return this.createNullifFunctionNode((SqmExpression)x, (SqmExpression)y);
    }

    @Override
    public <Y> SqmExpression<Y> nullif(Expression<Y> x, Y y) {
        return this.createNullifFunctionNode((SqmExpression)x, this.literal(y));
    }

    private <Y> SqmExpression<Y> createNullifFunctionNode(SqmExpression<Y> first, SqmExpression<Y> second) {
        AllowableFunctionReturnType type = (AllowableFunctionReturnType)QueryHelper.highestPrecedenceType(first.getNodeType(), second.getNodeType());
        return this.getFunctionTemplate("nullif").makeSqmFunctionExpression(Arrays.asList(first, second), type, this.getQueryEngine());
    }

    private SqmFunctionTemplate getFunctionTemplate(String name) {
        return this.queryEngine.getSqmFunctionRegistry().findFunctionTemplate(name);
    }

    public <C, R> SqmCaseSimple<C, R> selectCase(Expression<? extends C> expression) {
        return new SqmCaseSimple((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <R> SqmCaseSearched<R> selectCase() {
        return new SqmCaseSearched(this);
    }

    @Override
    public <M extends Map<?, ?>> SqmExpression<Integer> mapSize(JpaExpression<M> mapExpression) {
        return new SqmCollectionSize((SqmPath)mapExpression, (NodeBuilder)this);
    }

    @Override
    public SqmExpression<Integer> mapSize(Map map) {
        return new SqmLiteral<Integer>(map.size(), StandardBasicTypes.INTEGER, this);
    }

    @Override
    public SqmPredicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmAndPredicate((SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate and(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.conjunction();
        }
        SqmPredicate junction = (SqmPredicate)restrictions[0];
        for (int i = 1; i < restrictions.length; ++i) {
            junction = new SqmAndPredicate(junction, (SqmPredicate)restrictions[i], this);
        }
        return junction;
    }

    @Override
    public SqmPredicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new SqmOrPredicate((SqmPredicate)this.wrap((Expression)x), (SqmPredicate)this.wrap((Expression)y), this);
    }

    @Override
    public SqmPredicate or(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return this.disjunction();
        }
        SqmPredicate junction = (SqmPredicate)restrictions[0];
        for (int i = 1; i < restrictions.length; ++i) {
            junction = new SqmOrPredicate(junction, (SqmPredicate)restrictions[i], this);
        }
        return junction;
    }

    @Override
    public SqmPredicate not(Expression<Boolean> restriction) {
        JpaPredicate predicate = this.wrap((Expression)restriction);
        return predicate.not();
    }

    @Override
    public SqmPredicate conjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, StandardBasicTypes.INTEGER, this), ComparisonOperator.EQUAL, new SqmLiteral<Integer>(1, StandardBasicTypes.INTEGER, this), this);
    }

    @Override
    public SqmPredicate disjunction() {
        return new SqmComparisonPredicate(new SqmLiteral<Integer>(1, StandardBasicTypes.INTEGER, this), ComparisonOperator.NOT_EQUAL, new SqmLiteral<Integer>(1, StandardBasicTypes.INTEGER, this), this);
    }

    @Override
    public SqmPredicate isTrue(Expression<Boolean> x) {
        return this.wrap((Expression)x);
    }

    @Override
    public SqmPredicate isFalse(Expression<Boolean> x) {
        return this.wrap((Expression)x).not();
    }

    @Override
    public SqmPredicate isNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this);
    }

    @Override
    public SqmPredicate isNotNull(Expression<?> x) {
        return new SqmNullnessPredicate((SqmExpression)x, (NodeBuilder)this).not();
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Expression<? extends Y> lower, Expression<? extends Y> upper) {
        return new SqmBetweenPredicate((SqmExpression)value, (SqmExpression)lower, (SqmExpression)upper, false, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate between(Expression<? extends Y> value, Y lower, Y upper) {
        return new SqmBetweenPredicate((SqmExpression)value, this.literal(lower), this.literal(upper), false, this);
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate equal(Expression<?> x, Object y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.EQUAL, this.literal(y), this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Expression<?> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate notEqual(Expression<?> x, Object y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.NOT_EQUAL, this.literal(y), this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThan(Expression<? extends Y> x, Y y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, this.literal(y), this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, this.literal(y), this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThan(Expression<? extends Y> x, Y y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, this.literal(y), this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public <Y extends Comparable<? super Y>> SqmPredicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, this.literal(y), this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate gt(Expression<? extends Number> x, Number y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN, this.literal(y), this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate ge(Expression<? extends Number> x, Number y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.GREATER_THAN_OR_EQUAL, this.literal(y), this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate lt(Expression<? extends Number> x, Number y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN, this.literal(y), this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, (SqmExpression)y, this);
    }

    @Override
    public SqmPredicate le(Expression<? extends Number> x, Number y) {
        return new SqmComparisonPredicate((SqmExpression)x, ComparisonOperator.LESS_THAN_OR_EQUAL, this.literal(y), this);
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isEmpty(Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <C extends Collection<?>> SqmPredicate isNotEmpty(Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(Expression<E> elem, Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isMember(E elem, Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(Expression<E> elem, Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <E, C extends Collection<E>> SqmPredicate isNotMember(E elem, Expression<C> collection) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern) {
        return new SqmLikePredicate((SqmExpression)searchString, this.literal(pattern), this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, Expression<String> pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, (SqmExpression)pattern, this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, Expression<Character> escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.literal(pattern), (SqmExpression)escapeChar, this);
    }

    @Override
    public SqmPredicate like(Expression<String> searchString, String pattern, char escapeChar) {
        return new SqmLikePredicate((SqmExpression)searchString, this.literal(pattern), this.literal(Character.valueOf(escapeChar)), this);
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern) {
        return this.not(this.like((Expression)x, (Expression)pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern) {
        return this.not(this.like((Expression)x, pattern));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not(this.like((Expression)x, (Expression)pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not(this.like((Expression)x, (Expression)pattern, escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not(this.like((Expression)x, pattern, (Expression)escapeChar));
    }

    @Override
    public SqmPredicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return this.not(this.like((Expression)x, pattern, escapeChar));
    }

    @Override
    public <T> SqmInPredicate in(Expression<? extends T> expression) {
        return new SqmInListPredicate((SqmExpression)expression, (NodeBuilder)this);
    }

    @Override
    public <T> SqmInPredicate in(Expression<? extends T> expression, Expression<? extends T> ... values) {
        SqmInListPredicate predicate = new SqmInListPredicate((SqmExpression)expression, (NodeBuilder)this);
        for (Expression<? extends T> value : values) {
            predicate.addExpression((SqmExpression)value);
        }
        return predicate;
    }

    @Override
    public <T> SqmInPredicate in(Expression<? extends T> expression, T ... values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        SqmInListPredicate predicate = new SqmInListPredicate(sqmExpression, (NodeBuilder)this);
        for (T value : values) {
            predicate.addExpression(new SqmLiteral<T>(value, sqmExpression.getNodeType(), this));
        }
        return predicate;
    }

    @Override
    public <T> SqmInPredicate in(Expression<? extends T> expression, List<T> values) {
        SqmExpression sqmExpression = (SqmExpression)expression;
        SqmInListPredicate predicate = new SqmInListPredicate(sqmExpression, (NodeBuilder)this);
        for (T value : values) {
            predicate.addExpression(new SqmLiteral<T>(value, sqmExpression.getNodeType(), this));
        }
        return predicate;
    }

    @Override
    public <T> SqmInPredicate in(Expression<? extends T> expression, SqmSubQuery<T> subQuery) {
        return new SqmInSubQueryPredicate<T>((SqmExpression)expression, subQuery, this);
    }

    @Override
    public SqmPredicate exists(Subquery<?> subquery) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapEmpty(JpaExpression<M> mapExpression) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public <M extends Map<?, ?>> SqmPredicate isMapNotEmpty(JpaExpression<M> mapExpression) {
        throw new NotYetImplementedFor6Exception();
    }
}

