/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.spi.DomainResultCreationState;

public class MultiTableSqmMutationConverter
extends BaseSqmToSqlAstConverter
implements DomainResultCreationState {
    private final EntityMappingType mutatingEntityDescriptor;
    private final TableGroup mutatingTableGroup;
    private BiConsumer<SqmParameter, List<JdbcParameter>> parameterResolutionConsumer;

    public MultiTableSqmMutationConverter(EntityMappingType mutatingEntityDescriptor, DomainParameterXref domainParameterXref, QueryOptions queryOptions, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings);
        this.mutatingEntityDescriptor = mutatingEntityDescriptor;
        SqlAstProcessingStateImpl rootProcessingState = new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent);
        this.getProcessingStateStack().push(rootProcessingState);
        NavigablePath navigablePath = new NavigablePath(mutatingEntityDescriptor.getEntityName());
        this.mutatingTableGroup = mutatingEntityDescriptor.createRootTableGroup(navigablePath, null, JoinType.LEFT, LockMode.PESSIMISTIC_WRITE, this.getSqlAliasBaseGenerator(), this.getSqlExpressionResolver(), () -> predicate -> {}, creationContext.getSessionFactory());
        assert (!this.mutatingTableGroup.getTableReferenceJoins().isEmpty());
        this.getFromClauseAccess().registerTableGroup(navigablePath, this.mutatingTableGroup);
    }

    public EntityMappingType getMutatingEntityDescriptor() {
        return this.mutatingEntityDescriptor;
    }

    public TableGroup getMutatingTableGroup() {
        return this.mutatingTableGroup;
    }

    @Override
    public Stack<SqlAstProcessingState> getProcessingStateStack() {
        return super.getProcessingStateStack();
    }

    public void visitSetClause(SqmSetClause setClause, Consumer<Assignment> assignmentConsumer, BiConsumer<SqmParameter, List<JdbcParameter>> parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        for (SqmAssignment assignment : setClause.getAssignments()) {
            this.visitAssignment(assignment, assignmentConsumer);
        }
    }

    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        throw new UnsupportedOperationException();
    }

    private void visitAssignment(SqmAssignment sqmAssignment, Consumer<Assignment> assignmentConsumer) {
        Assignable assignable = (Assignable)sqmAssignment.getTargetPath().accept(this);
        Expression value = (Expression)sqmAssignment.getValue().accept(this);
        assignmentConsumer.accept(new Assignment(assignable, value));
    }

    @Override
    public Assignment visitAssignment(SqmAssignment sqmAssignment) {
        return new Assignment((Assignable)sqmAssignment.getTargetPath().accept(this), (Expression)sqmAssignment.getValue().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Predicate visitWhereClause(SqmWhereClause sqmWhereClause, final Consumer<ColumnReference> restrictionColumnReferenceConsumer, BiConsumer<SqmParameter, List<JdbcParameter>> parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        if (sqmWhereClause == null || sqmWhereClause.getPredicate() == null) {
            return null;
        }
        final SqlAstProcessingState rootProcessingState = this.getProcessingStateStack().getCurrent();
        SqlAstProcessingStateImpl restrictionProcessingState = new SqlAstProcessingStateImpl(rootProcessingState, this, this.getCurrentClauseStack()::getCurrent){

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this;
            }

            @Override
            public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                Expression expression = rootProcessingState.getSqlExpressionResolver().resolveSqlExpression(key, creator);
                if (expression instanceof ColumnReference) {
                    restrictionColumnReferenceConsumer.accept((ColumnReference)expression);
                }
                return expression;
            }
        };
        this.getProcessingStateStack().push(restrictionProcessingState);
        try {
            Predicate predicate = (Predicate)sqmWhereClause.getPredicate().accept(this);
            return predicate;
        }
        finally {
            this.getProcessingStateStack().pop();
            this.parameterResolutionConsumer = null;
        }
    }

    @Override
    public Predicate visitWhereClause(SqmWhereClause whereClause) {
        return (Predicate)super.visitWhereClause(whereClause);
    }

    @Override
    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        assert (this.parameterResolutionConsumer != null);
        Expression expression = super.consumeSqmParameter(sqmParameter);
        List<JdbcParameter> jdbcParameters = this.getJdbcParamsBySqmParam().get(sqmParameter);
        this.parameterResolutionConsumer.accept(sqmParameter, jdbcParameters);
        return expression;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSelectClause(SqmSelectClause sqmSelectClause, QuerySpec sqlQuerySpec, final Consumer<ColumnReference> columnReferenceConsumer, BiConsumer<SqmParameter, List<JdbcParameter>> parameterResolutionConsumer) {
        assert (sqmSelectClause != null);
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        final SqlAstProcessingState rootProcessingState = this.getProcessingStateStack().getCurrent();
        SqlAstQuerySpecProcessingStateImpl processingState = new SqlAstQuerySpecProcessingStateImpl(sqlQuerySpec, rootProcessingState, this, this.getCurrentClauseStack()::getCurrent){

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this;
            }

            @Override
            public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                Expression expression = rootProcessingState.getSqlExpressionResolver().resolveSqlExpression(key, creator);
                if (expression instanceof ColumnReference) {
                    columnReferenceConsumer.accept((ColumnReference)expression);
                }
                return expression;
            }
        };
        this.getProcessingStateStack().push(processingState);
        try {
            for (int i = 0; i < sqmSelectClause.getSelectionItems().size(); ++i) {
                DomainResultProducer domainResultProducer = (DomainResultProducer)sqmSelectClause.getSelectionItems().get(i).accept(this);
                domainResultProducer.applySqlSelections(this);
            }
        }
        finally {
            this.getProcessingStateStack().pop();
            this.parameterResolutionConsumer = null;
        }
    }
}

