/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;

public class SqmMutationStrategyHelper {
    public static final SqmMutationStrategyHelper INSTANCE = new SqmMutationStrategyHelper();

    private SqmMutationStrategyHelper() {
    }

    public static SqmMultiTableMutationStrategy resolveStrategy(RootClass entityBootDescriptor, EntityMappingType rootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        SessionFactoryOptions options = sessionFactory.getSessionFactoryOptions();
        SqmMultiTableMutationStrategy specifiedStrategy = options.getSqmMultiTableMutationStrategy();
        if (specifiedStrategy != null) {
            return specifiedStrategy;
        }
        return sessionFactory.getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect().getFallbackSqmMutationStrategy(rootEntityDescriptor, creationContext);
    }
}

